/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic.graticule;

import java.util.List;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.graticule.GraticuleStyle;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.commands.SetLayerCRSCommand;
import net.refractions.udig.style.IStyleConfigurator;
import net.refractions.udig.ui.CRSChooserDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GraticuleCRSConfigurator
extends IStyleConfigurator {
    private static final String EPSG = "EPSG:";
    private Text crsText;
    private Label crsLabel;

    public boolean canStyle(Layer layer) {
        return layer.hasResource(MapGraphic.class) && layer.getStyleBlackboard().get("net.refractions.udig.tool.edit.mapgraphic.graticule.style") != null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)gridLayout);
        this.crsLabel = new Label(composite, 0);
        this.crsLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.crsLabel.setText(Messages.GraticuleCRSConfigurator_CRS);
        this.crsText = new Text(composite, 2048);
        this.crsText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.crsText.setEditable(false);
        final Button crsButton = new Button(composite, 2048);
        crsButton.setText(Messages.GraticuleCRSConfigurator_Select);
        crsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoordinateReferenceSystem crs = GraticuleCRSConfigurator.this.getCRS(GraticuleCRSConfigurator.this.getStyle());
                CRSChooserDialog dialog = new CRSChooserDialog(crsButton.getShell(), crs);
                int code = dialog.open();
                if (code == 0) {
                    try {
                        crs = dialog.getResult();
                        GraticuleCRSConfigurator.this.crsText.setText(GraticuleCRSConfigurator.EPSG + CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
                    }
                    catch (FactoryException ex) {
                        MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
                        GraticuleCRSConfigurator.this.getLayer().setStatus(2);
                        GraticuleCRSConfigurator.this.getLayer().setStatusMessage(ex.getMessage());
                    }
                }
            }
        });
    }

    private GraticuleStyle getStyle() {
        return GraticuleStyle.getStyle((ILayer)this.getLayer());
    }

    protected void refresh() {
        try {
            CoordinateReferenceSystem crs = this.getCRS(this.getStyle());
            this.crsText.setText(EPSG + CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false));
        }
        catch (FactoryException ex) {
            MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
            this.getLayer().setStatus(2);
            this.getLayer().setStatusMessage(ex.getMessage());
        }
    }

    public void preApply() {
        GraticuleStyle style = this.getStyle();
        style.setCRS(this.crsText.getText());
        this.getStyleBlackboard().put("net.refractions.udig.tool.edit.mapgraphic.graticule.style", (Object)style);
        GraticuleCRSConfigurator.apply(this.getLayer(), this.getStyle().getCRS());
    }

    public static void apply(Layer layer, String code) {
        GraticuleCRSConfigurator.apply(layer, GraticuleCRSConfigurator.getCRS((ILayer)layer, code));
    }

    public static void apply(Layer layer, CoordinateReferenceSystem crs) {
        if (!layer.getCRS().equals(crs)) {
            UndoableComposite commands = new UndoableComposite();
            List commandList = commands.getCommands();
            commandList.add(new SetLayerCRSCommand((ILayer)layer, crs));
            layer.getMap().sendCommandASync((MapCommand)commands);
        }
    }

    public CoordinateReferenceSystem getCRS(GraticuleStyle style) {
        return GraticuleCRSConfigurator.getCRS((ILayer)this.getLayer(), style.getCRS());
    }

    public static CoordinateReferenceSystem getCRS(ILayer graticule, String code) {
        try {
            return CRS.decode((String)code);
        }
        catch (NoSuchAuthorityCodeException ex) {
            MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
        }
        catch (FactoryException ex) {
            MapGraphicPlugin.log(Messages.GraticuleGraphic_Error, ex);
        }
        return graticule.getCRS();
    }
}

