/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ui.ResolveLabelProviderSimple;
import net.refractions.udig.catalog.ui.ResolveTitlesDecorator;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.internal.MapGraphicResource;
import net.refractions.udig.mapgraphic.internal.MapGraphicService;
import net.refractions.udig.mapgraphic.internal.Messages;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public final class MapGraphicChooserDialog
extends TitleAreaDialog {
    private TreeViewer viewer;
    private final ArrayList<MapGraphicResource> resourceList = new ArrayList();
    private final boolean permitMultipleSelection;

    public MapGraphicChooserDialog(Shell parentShell, boolean permitMultipleSelection) {
        super(parentShell);
        this.permitMultipleSelection = permitMultipleSelection;
    }

    protected int getShellStyle() {
        return 66768;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.OtherAction_shellText);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.OtherAction_wizardTitle);
        this.setMessage(Messages.OtherAction_message1);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int style = 512;
        if (this.permitMultipleSelection) {
            style |= 2;
        }
        Tree tree = new Tree(composite, style);
        this.viewer = new TreeViewer(tree);
        GridData gridData = new GridData(1808);
        gridData.heightHint = -1;
        gridData.widthHint = -1;
        gridData.verticalSpan = 4;
        tree.setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new MapGraphicTreeContentProvider());
        ResolveLabelProviderSimple resolveLabelProviderSimple = new ResolveLabelProviderSimple();
        ResolveTitlesDecorator resolveTitlesDecorator = new ResolveTitlesDecorator(resolveLabelProviderSimple, true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)resolveLabelProviderSimple, (ILabelDecorator)resolveTitlesDecorator));
        this.viewer.setInput((Object)MapGraphicChooserDialog.getMapGraphicService());
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                if (s.isEmpty()) {
                    return;
                }
                String title = null;
                try {
                    IGeoResource resource = (IGeoResource)s.getFirstElement();
                    title = resource.getTitle();
                    if (title == null) {
                        title = resource.getInfo(null).getTitle();
                    }
                }
                catch (IOException e) {
                    MapGraphicPlugin.log("", e);
                }
                if (s.size() == 1 && title != null) {
                    MapGraphicChooserDialog.this.setMessage(String.valueOf(Messages.OtherAction_p1) + title + Messages.OtherAction_p2);
                } else {
                    MapGraphicChooserDialog.this.setMessage(Messages.OtherAction_addAll);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MapGraphicChooserDialog.this.buttonPressed(0);
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 0, Messages.OtherAction_addButton, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Iterator iter = selection.iterator();
            this.resourceList.clear();
            while (iter.hasNext()) {
                this.resourceList.add((MapGraphicResource)((Object)iter.next()));
            }
        }
        super.buttonPressed(buttonId);
    }

    public List<MapGraphicResource> getSelectedResources() {
        return this.resourceList;
    }

    public static MapGraphicResource findResource(Class<? extends MapGraphic> graphic) {
        MapGraphicService service = MapGraphicChooserDialog.getMapGraphicService();
        try {
            List<MapGraphicResource> resources = service.resources((IProgressMonitor)new NullProgressMonitor());
            for (MapGraphicResource mapGraphicResource : resources) {
                if (!graphic.isAssignableFrom(mapGraphicResource.getGraphic().getClass())) continue;
                return mapGraphicResource;
            }
            throw new NoSuchElementException(graphic + " does is not registered.  Check that it is in the plugin.xml");
        }
        catch (IOException e) {
            MapGraphicPlugin.log("Unexpected exception", e);
            throw new RuntimeException(e);
        }
    }

    public static MapGraphicService getMapGraphicService() {
        return (MapGraphicService)CatalogPlugin.getDefault().getLocalCatalog().getById(MapGraphicService.class, MapGraphicService.SERVICE_ID, ProgressManager.instance().get(new Object[0]));
    }

    public static class MapGraphicTreeContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof IService) {
                try {
                    return ((IService)inputElement).members(ProgressManager.instance().get(new Object[0])).toArray();
                }
                catch (IOException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IService;
        }

        public void dispose() {
        }
    }
}

