/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.mapgraphic;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicPlugin;
import net.refractions.udig.mapgraphic.internal.MapGraphicService;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.factory.BasicCommandFactory;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.commands.DeleteLayerCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractToggleMapGraphicAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        Map map = ApplicationGISInternal.getActiveMap();
        if (map == ApplicationGIS.NO_MAP) {
            return;
        }
        List layers = map.getMapLayers();
        for (ILayer layer : layers) {
            if (!layer.hasResource(this.getMapGraphicClass())) continue;
            this.removeLegend();
            return;
        }
        this.addLegend();
    }

    private void removeLegend() {
        Map map = ApplicationGISInternal.getActiveMap();
        if (map == ApplicationGIS.NO_MAP) {
            return;
        }
        List layers = map.getMapLayers();
        ArrayList<ILayer> toRemove = new ArrayList<ILayer>();
        for (ILayer layer : layers) {
            if (!layer.hasResource(this.getMapGraphicClass())) continue;
            toRemove.add(layer);
        }
        UndoableComposite composite = new UndoableComposite();
        for (ILayer layer : toRemove) {
            composite.getCommands().add(new DeleteLayerCommand((Layer)layer));
        }
        map.sendCommandASync((MapCommand)composite);
    }

    private void addLegend() {
        Map map = ApplicationGISInternal.getActiveMap();
        try {
            IGeoResource legendResource = null;
            URL url = new URL(MapGraphicService.SERVICE_URL, "#" + this.getExtensionID());
            List matches = CatalogPlugin.getDefault().getLocalCatalog().find(IGeoResource.class, url, ProgressManager.instance().get(new Object[0]));
            if (!matches.isEmpty()) {
                legendResource = (IGeoResource)matches.get(0);
            }
            if (legendResource == null) {
                List results = CatalogPlugin.getDefault().getServiceFactory().createService(url);
                for (IGeoResource resource : ((IService)results.get(0)).resources((IProgressMonitor)new NullProgressMonitor())) {
                    if (!resource.getIdentifier().getRef().equals(url.getRef())) continue;
                    legendResource = resource;
                    break;
                }
            }
            if (legendResource == null) {
                return;
            }
            Layer layer = map.getLayerFactory().createLayer(legendResource);
            map.sendCommandSync((MapCommand)BasicCommandFactory.getInstance().createAddLayer((ILayer)layer));
        }
        catch (MalformedURLException e) {
            MapGraphicPlugin.log("", e);
        }
        catch (IOException e) {
            MapGraphicPlugin.log("", e);
        }
    }

    protected abstract Class<? extends MapGraphic> getMapGraphicClass();

    protected abstract String getExtensionID();

    public void init(IWorkbenchWindow window) {
    }
}

