/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.teradata;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.teradata.TeradataDialect;
import org.geotools.data.teradata.TessellationInfo;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.logging.Logging;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class TeradataFilterToSQL
extends PreparedFilterToSQL {
    static final Logger LOGGER = Logging.getLogger(TeradataFilterToSQL.class);
    boolean looseBBOX;

    public TeradataFilterToSQL(TeradataDialect dialect) {
        super(dialect);
        this.looseBBOX = dialect.isLooseBBOXEnabled();
    }

    @Override
    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities caps = new FilterCapabilities();
        caps.addAll(SQLDialect.BASE_DBMS_CAPABILITIES);
        caps.addType(BBOX.class);
        caps.addType(Contains.class);
        caps.addType(Crosses.class);
        caps.addType(Disjoint.class);
        caps.addType(Equals.class);
        caps.addType(Intersects.class);
        caps.addType(Overlaps.class);
        caps.addType(Touches.class);
        caps.addType(Within.class);
        caps.addType(DWithin.class);
        caps.addType(Beyond.class);
        return caps;
    }

    @Override
    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        try {
            if (filter instanceof DistanceBufferOperator) {
                this.visitDistanceSpatialOperator((DistanceBufferOperator)filter, property, geometry, swapped, extraData);
            } else {
                this.visitComparisonSpatialOperator(filter, property, geometry, swapped, extraData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("io problem writing filter", e);
        }
        return extraData;
    }

    void visitDistanceSpatialOperator(DistanceBufferOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (filter instanceof DWithin && !swapped || filter instanceof Beyond && swapped) {
            this.encodeIndexPredicate(property, geometry);
            property.accept((ExpressionVisitor)this, extraData);
            this.out.write(".ST_DWithin(new ST_Geometry(");
            geometry.accept((ExpressionVisitor)this, extraData);
            this.out.write("),");
            this.out.write(Double.toString(filter.getDistance()));
            this.out.write(")");
        }
        if (filter instanceof DWithin && swapped || filter instanceof Beyond && !swapped) {
            this.encodeIndexPredicate(property, geometry);
            property.accept((ExpressionVisitor)this, extraData);
            this.out.write(".ST_Distance(SYSSPATIAL.ST_Geometry(");
            geometry.accept((ExpressionVisitor)this, extraData);
            this.out.write(")) > ");
            this.out.write(Double.toString(filter.getDistance()));
        }
    }

    void visitComparisonSpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) throws IOException {
        if (!(filter instanceof Disjoint) && this.encodeIndexPredicate(property, geometry)) {
            this.out.write(" AND ");
        }
        property.accept((ExpressionVisitor)this, extraData);
        this.out.write(".");
        if (filter instanceof Equals) {
            this.out.write("ST_Equals");
        } else if (filter instanceof Disjoint) {
            this.out.write("ST_Disjoint ");
        } else if (filter instanceof Intersects || filter instanceof BBOX) {
            this.out.write("ST_Intersects");
        } else if (filter instanceof Crosses) {
            this.out.write("ST_Crosses");
        } else if (filter instanceof Within) {
            if (swapped) {
                this.out.write("ST_Contains");
            } else {
                this.out.write("ST_Within");
            }
        } else if (filter instanceof Contains) {
            if (swapped) {
                this.out.write("ST_Within");
            } else {
                this.out.write("ST_Contains");
            }
        } else if (filter instanceof Overlaps) {
            this.out.write("ST_Overlaps");
        } else if (filter instanceof Touches) {
            this.out.write("ST_Touches");
        } else {
            throw new RuntimeException("Unsupported filter type " + filter.getClass());
        }
        int tdVersion = ((TeradataDialect)this.dialect).getTdVersion();
        if (tdVersion > 12) {
            this.out.write("(new ST_Geometry(");
            geometry.accept((ExpressionVisitor)this, extraData);
            this.out.write(")) = 1");
        } else {
            this.out.write("(CAST (");
            geometry.accept((ExpressionVisitor)this, extraData);
            this.out.write(" AS ST_Geometry)) = 1");
        }
    }

    boolean encodeIndexPredicate(PropertyName property, Literal geometry) throws IOException {
        TessellationInfo tinfo = (TessellationInfo)this.currentGeometry.getUserData().get(TessellationInfo.KEY);
        if (tinfo == null) {
            LOGGER.info("Tessellation info not available for " + this.currentGeometry.getLocalName() + ", unable to perform spatially indexed query");
            return false;
        }
        if (tinfo.getIndexTableName() == null) {
            LOGGER.info("Tessellation info available for " + this.currentGeometry.getLocalName() + ", but index table does not exist, unable to perform spatially index query.");
            return false;
        }
        if (this.primaryKey == null || this.primaryKey.getColumns().isEmpty()) {
            LOGGER.info("No primary key for " + this.featureType.getTypeName() + ", unable to perform spatially indexed query");
            return false;
        }
        Geometry g = (Geometry)geometry.getValue();
        Envelope oenv = g.getEnvelopeInternal();
        Envelope uenv = tinfo.getUBounds();
        if (!uenv.contains(oenv)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Bounds:" + oenv + " falls outside of univerise bounds: " + uenv + ". Unable to perform index query.");
            }
            return false;
        }
        double coverage = uenv.intersection(oenv).getArea() / uenv.getArea();
        if (coverage > 0.5) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Bounds:" + oenv + " covers " + coverage * 100.0 + " of universe bounds: " + uenv + ". Forgoing index query.");
            }
            return false;
        }
        this.out.write(40);
        Iterator<PrimaryKeyColumn> it = this.primaryKey.getColumns().iterator();
        while (it.hasNext()) {
            this.out.write(it.next().getName());
            if (!it.hasNext()) continue;
            this.out.write(", ");
        }
        this.out.write(41);
        this.out.write(" IN (SELECT DISTINCT ");
        it = this.primaryKey.getColumns().iterator();
        while (it.hasNext()) {
            this.out.write("t." + it.next().getName());
            if (!it.hasNext()) continue;
            this.out.write(", ");
        }
        this.out.write(" FROM ");
        if (tinfo.getSchemaName() != null) {
            this.out.write(this.escapeName(tinfo.getSchemaName()));
            this.out.write(".");
        }
        this.out.write(this.escapeName(tinfo.getIndexTableName()));
        this.out.write(" t, TABLE (SYSSPATIAL.tessellate_search(1,");
        this.out.write(String.format("%f, %f, %f, %f, %f, %f, %f, %f, %d, %d, %d, %f, %d)) AS i ", oenv.getMinX(), oenv.getMinY(), oenv.getMaxX(), oenv.getMaxY(), uenv.getMinX(), uenv.getMinY(), uenv.getMaxX(), uenv.getMaxY(), tinfo.getNx(), tinfo.getNy(), tinfo.getLevels(), tinfo.getScale(), tinfo.getShift()));
        this.out.write(" WHERE t.cellid = i.cellid)");
        return true;
    }
}

