/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.legend.ui;

import java.awt.Color;
import net.refractions.udig.legend.internal.Messages;
import net.refractions.udig.legend.ui.LegendGraphic;
import net.refractions.udig.legend.ui.LegendStyle;
import net.refractions.udig.legend.ui.LegendStyleContent;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.dialogs.ColorEditor;
import net.refractions.udig.style.IStyleConfigurator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LegendGraphicStyleConfigurator
extends IStyleConfigurator
implements SelectionListener,
ModifyListener {
    private Text verticalMargin;
    private Text horizontalMargin;
    private Text verticalSpacing;
    private Text horizontalSpacing;
    private Text indentSize;
    private ColorEditor fontColour;
    private ColorEditor backgroundColour;
    private LegendStyle style = null;
    private boolean fireEvents = true;

    public void createControl(Composite parent) {
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        Composite composite = new Composite((Composite)scrollComposite, 2048);
        GridLayout layout = new GridLayout(2, true);
        composite.setLayout((Layout)layout);
        Object layoutData = null;
        Label verticalMarginLabel = new Label(composite, 0);
        verticalMarginLabel.setText(Messages.LegendGraphicStyleConfigurator_vertical_margin);
        verticalMarginLabel.setLayoutData(layoutData);
        this.verticalMargin = new Text(composite, 2048);
        this.verticalMargin.setLayoutData(layoutData);
        Label horizontalMarginLabel = new Label(composite, 0);
        horizontalMarginLabel.setLayoutData(layoutData);
        horizontalMarginLabel.setText(Messages.LegendGraphicStyleConfigurator_horizontal_margin);
        this.horizontalMargin = new Text(composite, 2048);
        this.horizontalMargin.setLayoutData(layoutData);
        Label verticalSpacingLabel = new Label(composite, 0);
        verticalSpacingLabel.setLayoutData(layoutData);
        verticalSpacingLabel.setText(Messages.LegendGraphicStyleConfigurator_vertical_spacing);
        this.verticalSpacing = new Text(composite, 2048);
        this.verticalSpacing.setLayoutData(layoutData);
        Label horizontalSpacingLabel = new Label(composite, 0);
        horizontalSpacingLabel.setLayoutData(layoutData);
        horizontalSpacingLabel.setText(Messages.LegendGraphicStyleConfigurator_horizontal_spacing);
        this.horizontalSpacing = new Text(composite, 2048);
        this.horizontalSpacing.setLayoutData(layoutData);
        Label indentSizeLabel = new Label(composite, 0);
        indentSizeLabel.setLayoutData(layoutData);
        indentSizeLabel.setText(Messages.LegendGraphicStyleConfigurator_indent_size);
        this.indentSize = new Text(composite, 2048);
        this.indentSize.setLayoutData(layoutData);
        Label fontColourLabel = new Label(composite, 0);
        fontColourLabel.setLayoutData(layoutData);
        fontColourLabel.setText(Messages.LegendGraphicStyleConfigurator_font_colour);
        this.fontColour = new ColorEditor(composite);
        Label backgroundColourLabel = new Label(composite, 0);
        backgroundColourLabel.setLayoutData(layoutData);
        backgroundColourLabel.setText(Messages.LegendGraphicStyleConfigurator_background_colour);
        this.backgroundColour = new ColorEditor(composite);
        composite.layout();
        Point size = composite.computeSize(-1, -1);
        composite.setSize(size);
        scrollComposite.setContent((Control)composite);
        this.verticalMargin.addModifyListener((ModifyListener)this);
        this.horizontalMargin.addModifyListener((ModifyListener)this);
        this.verticalSpacing.addModifyListener((ModifyListener)this);
        this.horizontalSpacing.addModifyListener((ModifyListener)this);
        this.indentSize.addModifyListener((ModifyListener)this);
        this.backgroundColour.addSelectionListener((SelectionListener)this);
        this.fontColour.addSelectionListener((SelectionListener)this);
    }

    public boolean canStyle(Layer aLayer) {
        return aLayer.hasResource(LegendGraphic.class);
    }

    protected void refresh() {
        LegendStyle oldstyle = (LegendStyle)this.getStyleBlackboard().get("net.refractions.udig.legend.legendStyle");
        if (oldstyle == null) {
            oldstyle = LegendStyleContent.createDefault();
        }
        this.style = new LegendStyle(oldstyle);
        this.fireEvents = false;
        this.verticalMargin.setText(Integer.toString(this.style.verticalMargin));
        this.horizontalMargin.setText(Integer.toString(this.style.horizontalMargin));
        this.verticalSpacing.setText(Integer.toString(this.style.verticalSpacing));
        this.horizontalSpacing.setText(Integer.toString(this.style.horizontalSpacing));
        this.indentSize.setText(Integer.toString(this.style.indentSize));
        this.fontColour.setColorValue(new RGB(this.style.foregroundColour.getRed(), this.style.foregroundColour.getGreen(), this.style.foregroundColour.getBlue()));
        this.backgroundColour.setColorValue(new RGB(this.style.backgroundColour.getRed(), this.style.backgroundColour.getGreen(), this.style.backgroundColour.getBlue()));
        this.fireEvents = true;
        this.updateBlackboard();
    }

    private void updateBlackboard() {
        RGB bg = this.backgroundColour.getColorValue();
        this.style.backgroundColour = new Color(bg.red, bg.green, bg.blue);
        RGB fg = this.fontColour.getColorValue();
        this.style.foregroundColour = new Color(fg.red, fg.green, fg.blue);
        this.style.horizontalMargin = Integer.parseInt(this.horizontalMargin.getText());
        this.style.horizontalSpacing = Integer.parseInt(this.horizontalSpacing.getText());
        this.style.indentSize = Integer.parseInt(this.indentSize.getText());
        this.style.verticalMargin = Integer.parseInt(this.verticalMargin.getText());
        this.style.verticalSpacing = Integer.parseInt(this.verticalSpacing.getText());
        this.getStyleBlackboard().put("net.refractions.udig.legend.legendStyle", (Object)this.style);
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateBlackboard();
    }

    public void modifyText(ModifyEvent e) {
        if (this.fireEvents) {
            this.updateBlackboard();
        }
    }
}

