/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.legend.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.legend.ui.ColorMapLegendCreator;
import net.refractions.udig.legend.ui.LegendEntry;
import net.refractions.udig.legend.ui.LegendStyle;
import net.refractions.udig.legend.ui.LegendStyleContent;
import net.refractions.udig.mapgraphic.MapGraphic;
import net.refractions.udig.mapgraphic.MapGraphicContext;
import net.refractions.udig.mapgraphic.internal.MapGraphicResource;
import net.refractions.udig.mapgraphic.style.FontStyle;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IStyleBlackboard;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.ui.internal.LayerGeneratedGlyphDecorator;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.graphics.AWTSWTImageUtils;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.type.Name;

public class LegendGraphic
implements MapGraphic {
    private int verticalMargin;
    private int horizontalMargin;
    private int verticalSpacing;
    private int horizontalSpacing;
    private Color foregroundColour;
    private Color backgroundColour;
    private int indentSize;
    private int imageWidth;
    private int imageHeight;

    public void draw(MapGraphicContext context) {
        FontStyle fontStyle;
        Rectangle locationStyle;
        IStyleBlackboard blackboard = context.getLayer().getStyleBlackboard();
        LegendStyle legendStyle = (LegendStyle)blackboard.get("net.refractions.udig.legend.legendStyle");
        if (legendStyle == null) {
            legendStyle = LegendStyleContent.createDefault();
            blackboard.put("net.refractions.udig.legend.legendStyle", (Object)legendStyle);
        }
        if ((locationStyle = (Rectangle)blackboard.get("net.refractions.udig.printing.ui.locationStyle")) == null) {
            locationStyle = new Rectangle(-1, -1, -1, -1);
            blackboard.put("net.refractions.udig.printing.ui.locationStyle", (Object)locationStyle);
        }
        if ((fontStyle = (FontStyle)blackboard.get("net.refractions.udig.mapgraphic.style.font")) == null) {
            fontStyle = new FontStyle();
            blackboard.put("net.refractions.udig.mapgraphic.style.font", (Object)fontStyle);
        }
        this.backgroundColour = legendStyle.backgroundColour;
        this.foregroundColour = legendStyle.foregroundColour;
        this.horizontalMargin = legendStyle.horizontalMargin;
        this.verticalMargin = legendStyle.verticalMargin;
        this.horizontalSpacing = legendStyle.horizontalSpacing;
        this.verticalSpacing = legendStyle.verticalSpacing;
        this.indentSize = legendStyle.indentSize;
        this.imageHeight = legendStyle.imageHeight;
        this.imageWidth = legendStyle.imageWidth;
        final ViewportGraphics graphics = context.getGraphics();
        if (fontStyle.getFont() != null) {
            graphics.setFont(fontStyle.getFont());
        }
        ArrayList<Map<ILayer, LegendEntry[]>> layers = new ArrayList<Map<ILayer, LegendEntry[]>>();
        int longestRow = 0;
        final int[] numberOfEntries = new int[]{0};
        Dimension imageSize = new Dimension(this.imageWidth, this.imageHeight);
        Dimension textSize = new Dimension(0, graphics.getFontHeight());
        int i = context.getMapLayers().size() - 1;
        while (i >= 0) {
            ILayer layer = (ILayer)context.getMapLayers().get(i);
            if (!(layer.getGeoResource() instanceof MapGraphicResource) && layer.isVisible() && !layer.hasResource(MapGraphic.class)) {
                String layerName = layer.getName();
                if (layerName == null) {
                    layerName = null;
                }
                LegendEntry layerEntry = new LegendEntry(layerName);
                FeatureTypeStyle[] styles = this.locateStyle(layer);
                LegendEntry[] entries = null;
                if (styles == null) {
                    entries = new LegendEntry[]{layerEntry};
                } else {
                    List<LegendEntry> cmEntries;
                    List<Rule> rules = this.rules(styles);
                    int ruleCount = rules.size();
                    if (ruleCount == 1 && layer.getGeoResource().canResolve(GridCoverage.class) && (cmEntries = ColorMapLegendCreator.findEntries(styles, imageSize, textSize)) != null) {
                        cmEntries.add(0, layerEntry);
                        entries = cmEntries.toArray(new LegendEntry[cmEntries.size()]);
                    }
                    if (entries == null) {
                        ArrayList<LegendEntry> localEntries = new ArrayList<LegendEntry>();
                        if (ruleCount == 1) {
                            layerEntry.setRule(rules.get(0));
                        }
                        localEntries.add(layerEntry);
                        if (ruleCount > 1) {
                            for (Rule rule : rules) {
                                LegendEntry rentry = new LegendEntry(rule);
                                localEntries.add(rentry);
                            }
                        }
                        entries = localEntries.toArray(new LegendEntry[localEntries.size()]);
                    }
                }
                layers.add(Collections.singletonMap(layer, entries));
                int j = 0;
                while (j < entries.length) {
                    StringBuilder sb = new StringBuilder();
                    int k = 0;
                    while (k < entries[j].getText().length) {
                        sb.append(entries[j].getText()[k]);
                        ++k;
                    }
                    Rectangle2D bounds = graphics.getStringBounds(sb.toString());
                    int length = this.indentSize + this.imageWidth + this.horizontalSpacing + (int)bounds.getWidth();
                    if (length > longestRow) {
                        longestRow = length;
                    }
                    numberOfEntries[0] = numberOfEntries[0] + 1;
                    ++j;
                }
            }
            --i;
        }
        if (numberOfEntries[0] == 0) {
            return;
        }
        final int rowHeight = Math.max(this.imageHeight, graphics.getFontHeight());
        if (locationStyle.width == 0 || locationStyle.height == 0) {
            locationStyle = new Rectangle(locationStyle);
            if (locationStyle.width == 0) {
                int width;
                locationStyle.width = width = longestRow + this.horizontalMargin * 2;
            }
            if (locationStyle.height == 0) {
                int height = rowHeight * numberOfEntries[0] + this.verticalMargin * 2;
                int i2 = 0;
                while (i2 < layers.size()) {
                    Map map = (Map)layers.get(i2);
                    LegendEntry[] entries = (LegendEntry[])map.values().iterator().next();
                    int j = 0;
                    while (j < entries.length) {
                        height = entries[j].getSpacingAfter() == null ? (height += this.verticalSpacing) : (height += entries[j].getSpacingAfter().intValue());
                        ++j;
                    }
                    ++i2;
                }
                locationStyle.height = height - this.verticalSpacing;
            }
        }
        Dimension displaySize = context.getMapDisplay().getDisplaySize();
        if (locationStyle.x < 0) {
            locationStyle.x = displaySize.width - locationStyle.width + locationStyle.x;
        }
        if (locationStyle.x + locationStyle.width + 6 > displaySize.width) {
            locationStyle.x = displaySize.width - locationStyle.width - 5;
        }
        if (locationStyle.y < 0) {
            locationStyle.y = displaySize.height - locationStyle.height - 5 + locationStyle.y;
        }
        if (locationStyle.y + locationStyle.height + 6 > displaySize.height) {
            locationStyle.y = displaySize.height - locationStyle.height - 5;
        }
        graphics.setClip(new Rectangle(locationStyle.x, locationStyle.y, locationStyle.width + 1, locationStyle.height + 1));
        this.drawOutline(graphics, context, locationStyle);
        final int[] rowsDrawn = new int[]{0};
        final int[] x = new int[]{locationStyle.x + this.horizontalMargin};
        final int[] y = new int[]{locationStyle.y + this.verticalMargin};
        if (fontStyle.getFont() != null) {
            graphics.setFont(fontStyle.getFont());
        }
        int i3 = 0;
        while (i3 < layers.size()) {
            Map map = (Map)layers.get(i3);
            final ILayer layer = (ILayer)map.keySet().iterator().next();
            final LegendEntry[] entries = (LegendEntry[])map.values().iterator().next();
            try {
                ((IGeoResource)layer.getGeoResources().get(0)).getInfo(null);
            }
            catch (Exception exception) {}
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < entries.length) {
                        ImageDescriptor descriptor;
                        BufferedImage awtIcon = null;
                        if (entries[i].getRule() != null) {
                            descriptor = LayerGeneratedGlyphDecorator.generateStyledIcon((ILayer)layer, (Rule)entries[i].getRule());
                            if (descriptor == null) {
                                descriptor = LayerGeneratedGlyphDecorator.generateIcon((Layer)((Layer)layer));
                            }
                            if (descriptor != null) {
                                awtIcon = AWTSWTImageUtils.convertToAWT((ImageData)descriptor.getImageData());
                            }
                        } else if (entries[i].getIcon() != null) {
                            awtIcon = AWTSWTImageUtils.convertToAWT((ImageData)entries[i].getIcon().getImageData());
                        } else {
                            descriptor = LayerGeneratedGlyphDecorator.generateIcon((Layer)((Layer)layer));
                            if (descriptor != null) {
                                awtIcon = AWTSWTImageUtils.convertToAWT((ImageData)descriptor.getImageData());
                            }
                        }
                        LegendGraphic.this.drawRow(graphics, x[0], y[0], awtIcon, entries[i].getText(), i != 0, entries[i].getTextPosition());
                        y[0] = y[0] + rowHeight;
                        if (rowsDrawn[0] + 1 < numberOfEntries[0]) {
                            y[0] = entries[i].getSpacingAfter() != null ? y[0] + entries[i].getSpacingAfter() : y[0] + LegendGraphic.this.verticalSpacing;
                        }
                        rowsDrawn[0] = rowsDrawn[0] + 1;
                        ++i;
                    }
                }
            });
            ++i3;
        }
        graphics.setClip(null);
    }

    private List<Rule> rules(FeatureTypeStyle[] styles) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        FeatureTypeStyle[] featureTypeStyleArray = styles;
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureTypeStyle featureTypeStyle = featureTypeStyleArray[n2];
            rules.addAll(featureTypeStyle.rules());
            ++n2;
        }
        return rules;
    }

    private void drawRow(ViewportGraphics graphics, int x, int y, RenderedImage icon, String[] text, boolean indent, int position) {
        if (text.length == 0) {
            return;
        }
        Rectangle2D stringBounds = graphics.getStringBounds(text[0]);
        int textVerticalOffset = 0;
        int iconVerticalOffset = 0;
        if ((position | 0x1000000) == position) {
            if (this.imageHeight != (int)stringBounds.getHeight()) {
                int difference;
                if (this.imageHeight > (int)stringBounds.getHeight()) {
                    difference = this.imageHeight - (int)stringBounds.getHeight();
                    textVerticalOffset = difference / 2;
                } else if (this.imageHeight < (int)stringBounds.getHeight()) {
                    difference = (int)stringBounds.getHeight() - this.imageHeight;
                    iconVerticalOffset = difference / 2;
                }
            }
        } else if ((position | 0x80) == position) {
            textVerticalOffset = (int)((double)graphics.getFontAscent() * -0.6);
        }
        if (indent) {
            x += this.indentSize;
        }
        if (icon != null) {
            graphics.drawImage(icon, x, y + iconVerticalOffset);
            x += this.imageWidth;
        }
        if (text != null && text[0].length() != 0) {
            graphics.drawString(text[0], x + this.horizontalMargin, y + textVerticalOffset - (graphics.getFontHeight() - graphics.getFontAscent()), -1, 1);
        }
        if (text != null && text.length > 1) {
            String end = text[text.length - 1];
            graphics.drawString(end, x + this.horizontalMargin, y + this.imageHeight + (int)((double)graphics.getFontAscent() * 0.3), -1, -1);
        }
    }

    private FeatureTypeStyle[] locateStyle(ILayer layer) {
        StyleBlackboard blackboard = (StyleBlackboard)layer.getStyleBlackboard();
        if (blackboard == null) {
            return null;
        }
        Style sld = (Style)blackboard.lookup(Style.class);
        if (sld == null) {
            return null;
        }
        ArrayList<FeatureTypeStyle> styles = new ArrayList<FeatureTypeStyle>();
        String layerTypeName = null;
        if (layer.getSchema() != null && layer.getSchema().getTypeName() != null) {
            layerTypeName = layer.getSchema().getTypeName();
        }
        block0: for (FeatureTypeStyle style : sld.featureTypeStyles()) {
            Set names = style.featureTypeNames();
            if (names.size() == 0) {
                styles.add(style);
                continue;
            }
            for (Name name : names) {
                if (!name.getLocalPart().equals("Feature") && (layerTypeName == null || !layerTypeName.equals(name.getLocalPart()))) continue;
                styles.add(style);
                continue block0;
            }
        }
        return styles.toArray(new FeatureTypeStyle[0]);
    }

    private void drawOutline(ViewportGraphics graphics, MapGraphicContext context, Rectangle locationStyle) {
        Rectangle outline = new Rectangle(locationStyle.x, locationStyle.y, locationStyle.width, locationStyle.height);
        context.getLabelPainter().put((Rectangle2D)outline);
        graphics.setColor(this.backgroundColour);
        graphics.fill((Shape)outline);
        graphics.setColor(this.foregroundColour);
        graphics.setBackground(this.backgroundColour);
        graphics.draw((Shape)outline);
    }
}

