/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.legend.ui;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.legend.ui.LegendEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.expression.Expression;

public class ColorMapLegendCreator {
    private static ColorMap findColorMap(FeatureTypeStyle[] style) {
        if (style == null) {
            return null;
        }
        int i = 0;
        while (i < style.length) {
            FeatureTypeStyle fstyle = style[i];
            List rules = fstyle.rules();
            if (rules != null) {
                for (Rule rule : rules) {
                    Symbolizer[] syms = rule.getSymbolizers();
                    if (syms == null) continue;
                    int j = 0;
                    while (j < syms.length) {
                        Symbolizer sym = syms[j];
                        if (sym instanceof RasterSymbolizer && ((RasterSymbolizer)sym).getColorMap() != null) {
                            return ((RasterSymbolizer)sym).getColorMap();
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static List<LegendEntry> findEntries(FeatureTypeStyle[] style, Dimension imageSize, Dimension textSize) {
        ColorMap cm = ColorMapLegendCreator.findColorMap(style);
        if (cm == null || cm.getColorMapEntries().length == 0) {
            return null;
        }
        return ColorMapLegendCreator.findEntries(cm, imageSize, textSize);
    }

    public static List<LegendEntry> findEntries(ColorMap colorMap, Dimension imageSize, Dimension textSize) {
        if (colorMap.getType() == 2) {
            return ColorMapLegendCreator.createIntervalEntries(colorMap, imageSize);
        }
        if (colorMap.getType() == 1) {
            if (imageSize.height < textSize.height) {
                imageSize = new Dimension(imageSize.width, textSize.height);
            }
            return ColorMapLegendCreator.createRampEntries(colorMap, imageSize);
        }
        if (colorMap.getType() == 3) {
            return ColorMapLegendCreator.createValuesEntries(colorMap, imageSize);
        }
        return null;
    }

    private static boolean isNoData(ColorMapEntry entry) {
        return entry.getLabel() != null && entry.getLabel().equals("-no data-");
    }

    private static List<LegendEntry> createRampEntries(ColorMap colorMap, final Dimension imageSize) {
        ArrayList<LegendEntry> lentries = new ArrayList<LegendEntry>();
        ColorMapEntry[] entries = colorMap.getColorMapEntries();
        boolean first = true;
        int i = 1;
        while (i < entries.length) {
            final ColorMapEntry entry = entries[i];
            final ColorMapEntry prevEntry = entries[i - 1];
            if (!ColorMapLegendCreator.isNoData(prevEntry)) {
                ImageDescriptor dd = null;
                int idx = -1;
                if (first) {
                    idx = 0;
                } else if (i > entries.length - 2) {
                    idx = 2;
                }
                final int index = idx;
                first = false;
                dd = new ImageDescriptor(){

                    public ImageData getImageData() {
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        Image swtImage = new Image((Device)display, imageSize.width, imageSize.height);
                        GC gc = new GC((Drawable)swtImage);
                        gc.setAntialias(1);
                        Color c1 = ColorMapLegendCreator.getColor(display, entry.getColor());
                        Color c2 = ColorMapLegendCreator.getColor(display, prevEntry.getColor());
                        gc.setAlpha(ColorMapLegendCreator.getAlpha(entry.getOpacity()));
                        gc.setBackground(c1);
                        gc.setForeground(c2);
                        gc.fillGradientRectangle(1, 0, imageSize.width - 2, imageSize.height, true);
                        gc.setAlpha(150);
                        gc.setForeground(display.getSystemColor(2));
                        gc.drawLine(0, 0, 0, imageSize.height);
                        gc.drawLine(imageSize.width - 1, 0, imageSize.width - 1, imageSize.height);
                        if (index == 0) {
                            gc.drawLine(0, 0, imageSize.width - 1, 0);
                        } else if (index == 2) {
                            gc.drawLine(0, imageSize.height - 1, imageSize.width - 1, imageSize.height - 1);
                        }
                        c1.dispose();
                        c2.dispose();
                        ImageData clone = (ImageData)swtImage.getImageData().clone();
                        swtImage.dispose();
                        return clone;
                    }
                };
                String[] text = null;
                String q1 = (String)entry.getQuantity().evaluate(null, String.class);
                String q2 = (String)prevEntry.getQuantity().evaluate(null, String.class);
                String l1 = entry.getLabel();
                String l2 = prevEntry.getLabel();
                text = i <= entries.length - 3 ? (l2 == null ? new String[]{q2} : new String[]{String.valueOf(l2) + " (" + q2 + ")"}) : new String[]{l2 == null ? q2 : String.valueOf(l2) + " (" + q2 + ")", l1 == null ? q1 : String.valueOf(l1) + " (" + q1 + ")"};
                LegendEntry le = new LegendEntry(text, dd);
                le.setSpacingAfter(0);
                le.setTextPosition(128);
                lentries.add(le);
            }
            ++i;
        }
        ((LegendEntry)lentries.get(lentries.size() - 1)).setSpacingAfter(null);
        return lentries;
    }

    private static List<LegendEntry> createIntervalEntries(ColorMap colorMap, final Dimension imageSize) {
        ArrayList<LegendEntry> lentries = new ArrayList<LegendEntry>();
        ColorMapEntry[] entries = colorMap.getColorMapEntries();
        int i = 0;
        while (i < entries.length) {
            ColorMapEntry entry;
            ColorMapEntry prevEntry = null;
            if (i > 0) {
                prevEntry = entries[i - 1];
            }
            if (!ColorMapLegendCreator.isNoData(entry = entries[i])) {
                ImageDescriptor dd = null;
                dd = new ImageDescriptor(){

                    public ImageData getImageData() {
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        Image swtImage = new Image((Device)display, imageSize.width, imageSize.height);
                        GC gc = new GC((Drawable)swtImage);
                        gc.setAntialias(1);
                        Color c = ColorMapLegendCreator.getColor(display, entry.getColor());
                        gc.setAlpha(ColorMapLegendCreator.getAlpha(entry.getOpacity()));
                        gc.setBackground(c);
                        gc.fillRectangle(1, 1, imageSize.width - 2, imageSize.height - 2);
                        c.dispose();
                        gc.setAlpha(150);
                        gc.setForeground(display.getSystemColor(2));
                        gc.drawRectangle(1, 1, imageSize.width - 2, imageSize.height - 2);
                        ImageData clone = (ImageData)swtImage.getImageData().clone();
                        swtImage.dispose();
                        return clone;
                    }
                };
                String text = null;
                String q1 = (String)entry.getQuantity().evaluate(null, String.class);
                String l1 = entry.getLabel();
                if (prevEntry == null) {
                    text = "< " + q1;
                    if (l1 != null) {
                        text = String.valueOf(l1) + " (" + text + ")";
                    }
                } else {
                    String q2 = (String)prevEntry.getQuantity().evaluate(null, String.class);
                    text = String.valueOf(q2) + " - " + q1;
                    if (l1 != null) {
                        text = String.valueOf(l1) + " (" + text + ")";
                    }
                }
                LegendEntry le = new LegendEntry(text, dd);
                lentries.add(le);
            }
            ++i;
        }
        return lentries;
    }

    private static List<LegendEntry> createValuesEntries(ColorMap colorMap, final Dimension imageSize) {
        ArrayList<LegendEntry> lentries = new ArrayList<LegendEntry>();
        ColorMapEntry[] entries = colorMap.getColorMapEntries();
        int i = 0;
        while (i < entries.length) {
            final ColorMapEntry entry = entries[i];
            if (!ColorMapLegendCreator.isNoData(entry)) {
                ImageDescriptor dd = null;
                dd = new ImageDescriptor(){

                    public ImageData getImageData() {
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        Image swtImage = new Image((Device)display, imageSize.width, imageSize.height);
                        GC gc = new GC((Drawable)swtImage);
                        gc.setAntialias(1);
                        Color c = ColorMapLegendCreator.getColor(display, entry.getColor());
                        gc.setAlpha(ColorMapLegendCreator.getAlpha(entry.getOpacity()));
                        gc.setBackground(c);
                        gc.fillRectangle(1, 1, imageSize.width - 2, imageSize.height - 2);
                        gc.setAlpha(150);
                        gc.setForeground(display.getSystemColor(2));
                        gc.drawRectangle(1, 1, imageSize.width - 2, imageSize.height - 2);
                        c.dispose();
                        ImageData clone = (ImageData)swtImage.getImageData().clone();
                        swtImage.dispose();
                        return clone;
                    }
                };
                String text = null;
                String q1 = (String)entry.getQuantity().evaluate(null, String.class);
                String l1 = entry.getLabel();
                text = q1;
                if (l1 != null) {
                    text = String.valueOf(l1) + " (" + q1 + ")";
                }
                LegendEntry le = new LegendEntry(text, dd);
                lentries.add(le);
            }
            ++i;
        }
        return lentries;
    }

    private static Color getColor(Display display, Expression colorExpression) {
        String colorString = (String)colorExpression.evaluate(null, String.class);
        if (colorString.startsWith("0x")) {
            colorString = colorString.substring(2);
        }
        if (!colorString.startsWith("#")) {
            colorString = "#" + colorString;
        }
        java.awt.Color c1 = java.awt.Color.decode(colorString);
        Color c = new Color((Device)display, c1.getRed(), c1.getGreen(), c1.getBlue());
        return c;
    }

    private static int getAlpha(Expression alphaExpression) {
        Double alpha = (Double)alphaExpression.evaluate(null, Double.class);
        if (alpha != null) {
            return (int)(alpha * 255.0);
        }
        return 255;
    }
}

