/*
 * Decompiled with CFR 0.152.
 */
package geodb;

import geodb.Box;

public class GeoString {
    Box bound;
    int depth;
    double originx;
    double originy;
    double sizex;
    double sizey;
    String hash;

    static byte[] toBits(double f) {
        return GeoString.toBits(f, 32);
    }

    static byte[] toBits(double f, int depth) {
        f *= (double)(1L << depth);
        byte[] bits = new byte[depth];
        for (int i = 1; i < depth + 1; ++i) {
            bits[i - 1] = (byte)((long)f >> depth - i & 1L);
        }
        return bits;
    }

    static String bitstring(double x, double y, Box b, int depth) {
        byte[] xbits = GeoString.toBits((x - b.l) / (b.r - b.l), depth);
        byte[] ybits = GeoString.toBits((y - b.b) / (b.t - b.b), depth);
        StringBuffer bits = new StringBuffer();
        for (int i = 0; i < xbits.length; ++i) {
            bits.append(xbits[i]).append(ybits[i]);
        }
        return bits.toString();
    }

    static double round(double d, int n) {
        double scale = Math.pow(10.0, n);
        double r = d * scale + 0.5;
        return (double)((int)r) / scale;
    }

    public GeoString(double x, double y) {
        this(x, y, 32);
    }

    public GeoString(double x, double y, Box bound) {
        this(x, y, bound, 32);
    }

    public GeoString(double x, double y, int depth) {
        this(x, y, Box.WGS84, depth);
    }

    public GeoString(double x, double y, Box bound, int depth) {
        this.bound = bound;
        this.depth = depth;
        this.originx = bound.l;
        this.originy = bound.b;
        this.sizex = bound.r - bound.l;
        this.sizey = bound.t - bound.b;
        this.hash = GeoString.bitstring(x, y, bound, depth);
    }

    public GeoString(String hash) {
        this(hash, 32);
    }

    public GeoString(String hash, Box bound) {
        this(hash, bound, 32);
    }

    public GeoString(String hash, int depth) {
        this(hash, Box.WGS84, depth);
    }

    public GeoString(String hash, Box bound, int depth) {
        this.bound = bound;
        this.depth = depth;
        this.hash = hash;
        this.originx = bound.l;
        this.originy = bound.b;
        this.sizex = bound.r - bound.l;
        this.sizey = bound.t - bound.b;
    }

    public Box bbox() {
        return this.bbox(this.hash.length());
    }

    public Box bbox(int prefix) {
        String bits = this.hash.substring(0, prefix);
        int depth = bits.length() / 2;
        double minx = 0.0;
        double miny = 0.0;
        double maxx = 1.0;
        double maxy = 1.0;
        for (int i = 0; i < depth + 1; ++i) {
            try {
                minx += Double.parseDouble(String.valueOf(bits.charAt(i * 2))) / (double)(2L << i);
                miny += Double.parseDouble(String.valueOf(bits.charAt(i * 2 + 1))) / (double)(2L << i);
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (depth > 0) {
            maxx = minx + 1.0 / (double)(2L << depth - 1);
            maxy = miny + 1.0 / (double)(2L << depth - 1);
        } else if (bits.length() == 1) {
            maxx = Math.min(minx + 0.5, 1.0);
        }
        minx = GeoString.round(this.originx + minx * this.sizex, 6);
        maxx = GeoString.round(this.originx + maxx * this.sizex, 6);
        miny = GeoString.round(this.originy + miny * this.sizey, 6);
        maxy = GeoString.round(this.originy + maxy * this.sizey, 6);
        return new Box(minx, miny, maxx, maxy);
    }

    public GeoString union(GeoString string) {
        int i;
        String other = string.hash;
        int n = Math.min(this.hash.length(), other.length());
        for (i = 0; i < n && this.hash.charAt(i) == other.charAt(i); ++i) {
        }
        String union = this.hash.substring(0, i);
        return new GeoString(union, this.bound, this.depth);
    }

    public String toString() {
        return this.hash;
    }

    public static void main(String[] args) {
        GeoString gs = new GeoString(-0.25, 51.5);
        System.out.println(gs);
        System.out.println(gs.bbox());
    }
}

