/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.internal;

import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseWheelEvent;
import net.refractions.udig.project.ui.tool.AbstractTool;
import net.refractions.udig.tools.internal.NavigationUpdateThread;

public class ScrollZoom
extends AbstractTool {
    private static final int INTERVAL = 50;
    private int distance = 0;
    private int start;
    boolean in = true;

    public ScrollZoom() {
        super(7);
    }

    public void mouseWheelMoved(MapMouseWheelEvent e) {
        if (e.modifiersDown()) {
            return;
        }
        NavigationUpdateThread.getUpdater().zoomWithFixedPoint(e.clickCount * 3, this.getContext(), 500, e.getPoint());
    }

    public void mousePressed(MapMouseEvent e) {
        if (e.modifiers == 65536 && e.buttons == 8) {
            this.start = e.x;
        }
    }

    public void mouseDragged(MapMouseEvent e) {
        if (e.modifiers == 65536 && e.buttons == 8) {
            this.distance += this.start - e.x;
            if (this.distance >= 50 || this.distance <= -50) {
                NavigationUpdateThread.getUpdater().zoom(10 * (this.distance > 0 ? 1 : -1), this.getContext(), 300);
                this.distance = 0;
                this.start = e.x;
            }
        }
    }

    public void mouseReleased(MapMouseEvent e) {
        this.distance = 0;
    }
}

