/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.tools.internal;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.Point;
import java.util.ArrayList;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.internal.command.navigation.NavComposite;
import net.refractions.udig.project.internal.command.navigation.PanCommand;
import net.refractions.udig.project.internal.command.navigation.ZoomCommand;
import net.refractions.udig.project.ui.commands.TransformDrawCommand;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.internal.Messages;
import net.refractions.udig.tools.internal.ToolsPlugin;

public class NavigationUpdateThread
implements Runnable {
    private static final int PAN_AMOUNT = 30;
    private static final double FACTOR = 1.01;
    private static volatile long request = Long.MAX_VALUE;
    private static Thread thread;
    private static TransformDrawCommand command;
    private static final NavigationUpdateThread updater;
    public static final int DEFAULT_DELAY = 500;
    int zoomAmount = 0;
    private int vertical = 0;
    private int horizontal = 0;
    private IToolContext context;
    private volatile long updateDelay = 1000L;
    private Coordinate fixedPoint;
    private double previousZoom = 1.0;

    static {
        updater = new NavigationUpdateThread();
    }

    private NavigationUpdateThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final void run() {
        var1_1 = NavigationUpdateThread.class;
        // MONITORENTER : net.refractions.udig.tools.internal.NavigationUpdateThread.class
        if (NavigationUpdateThread.thread != Thread.currentThread()) {
            // MONITOREXIT : var1_1
            return;
        }
        // MONITOREXIT : var1_1
        if (true) ** GOTO lbl43
        do {
            var1_1 = NavigationUpdateThread.class;
            // MONITORENTER : net.refractions.udig.tools.internal.NavigationUpdateThread.class
            if (NavigationUpdateThread.thread != Thread.currentThread()) {
                // MONITOREXIT : var1_1
                return;
            }
            // MONITOREXIT : var1_1
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                ToolsPlugin.log("", e);
                var2_3 = NavigationUpdateThread.class;
                // MONITORENTER : net.refractions.udig.tools.internal.NavigationUpdateThread.class
                if (NavigationUpdateThread.thread != Thread.currentThread()) {
                    // MONITOREXIT : var2_3
                    return;
                }
                NavigationUpdateThread.thread = null;
                // MONITOREXIT : var2_3
                this.cancel();
                return;
            }
lbl43:
            // 2 sources

        } while (this.getElapsedTimeSinceLastRequest() < this.updateDelay);
        var1_1 = NavigationUpdateThread.class;
        // MONITORENTER : net.refractions.udig.tools.internal.NavigationUpdateThread.class
        if (NavigationUpdateThread.thread != Thread.currentThread()) {
            // MONITOREXIT : var1_1
            return;
        }
        NavigationUpdateThread.thread = null;
        // MONITOREXIT : var1_1
        this.performChange();
    }

    private synchronized long getElapsedTimeSinceLastRequest() {
        return System.currentTimeMillis() - request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void requestStart() {
        request = System.currentTimeMillis();
        Class<NavigationUpdateThread> clazz = NavigationUpdateThread.class;
        synchronized (NavigationUpdateThread.class) {
            if (thread == null) {
                thread = new Thread(this);
                thread.setName(Messages.ScrollZoom_scroll_zoom);
                thread.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized void left(IToolContext context, int updateDelay) {
        ++this.horizontal;
        this.update(context, updateDelay);
    }

    public synchronized void right(IToolContext context, int updateDelay) {
        --this.horizontal;
        this.update(context, updateDelay);
    }

    public synchronized void up(IToolContext context, int updateDelay) {
        ++this.vertical;
        this.update(context, updateDelay);
    }

    public synchronized void down(IToolContext context, int updateDelay) {
        --this.vertical;
        this.update(context, updateDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(IToolContext context, int updateDelay2) {
        Class<NavigationUpdateThread> clazz = NavigationUpdateThread.class;
        synchronized (NavigationUpdateThread.class) {
            this.updateDelay = updateDelay2;
            this.context = context;
            if (command == null) {
                TransformDrawCommand transformDrawCommand;
                command = transformDrawCommand = new TransformDrawCommand();
                transformDrawCommand.pan(this.horizontal * 30, this.vertical * 30);
                context.sendASyncCommand((Command)transformDrawCommand);
            } else {
                command.pan(this.horizontal * 30, this.vertical * 30);
                context.getViewportPane().repaint();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.requestStart();
            return;
        }
    }

    public void zoom(int change, IToolContext context, int updateDelay) {
        this.zoomWithFixedPoint(change, context, updateDelay, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomWithFixedPoint(int change, IToolContext context, int updateDelay, Point fixedPoint) {
        double zoomChange = Math.pow(1.01, change);
        if (change < 0) {
            zoomChange = -zoomChange;
        }
        Class<NavigationUpdateThread> clazz = NavigationUpdateThread.class;
        synchronized (NavigationUpdateThread.class) {
            double targetZoom;
            this.updateDelay = updateDelay;
            if (command == null) {
                TransformDrawCommand transformDrawCommand;
                command = transformDrawCommand = new TransformDrawCommand();
                if (fixedPoint == null) {
                    fixedPoint = new Point(context.getViewportPane().getWidth() / 2, context.getViewportPane().getHeight() / 2);
                }
                transformDrawCommand.fixPoint(fixedPoint);
                this.fixedPoint = context.pixelToWorld(fixedPoint.x, fixedPoint.y);
                targetZoom = context.calculateZoomLevel(this.previousZoom, zoomChange, this.fixedPoint, false, change != 0);
                if (Math.abs(targetZoom - this.previousZoom) > 1.0E-4) {
                    transformDrawCommand.zoom(targetZoom, targetZoom);
                    context.sendASyncCommand((Command)transformDrawCommand);
                }
            } else {
                targetZoom = context.calculateZoomLevel(this.previousZoom, zoomChange, this.fixedPoint, false, change != 0);
                command.zoom(targetZoom, targetZoom);
                if (Math.abs(targetZoom - this.previousZoom) > 1.0E-4) {
                    context.getViewportPane().repaint();
                }
            }
            if (Math.abs(targetZoom - this.previousZoom) > 1.0E-4) {
                this.zoomAmount += change;
                this.previousZoom = targetZoom;
            }
            // ** MonitorExit[var7_6] (shouldn't be in output)
            this.context = context;
            this.requestStart();
            return;
        }
    }

    protected synchronized void performChange() {
        double zoom = Math.abs(Math.pow(1.01, this.previousZoom));
        ArrayList<Object> commands = new ArrayList<Object>();
        if (this.horizontal != 0 || this.vertical != 0) {
            commands.add(new PanCommand(this.horizontal * -30, this.vertical * -30));
        }
        if (zoom > 1.0E-8) {
            this.context.calculateZoomLevel(1.0, this.previousZoom, this.fixedPoint, false, this.zoomAmount != 0);
            ZoomCommand zoomCommand = new ZoomCommand(this.previousZoom);
            zoomCommand.setFixedPoint(this.fixedPoint);
            commands.add(zoomCommand);
        }
        if (commands.size() > 0) {
            NavComposite composite = new NavComposite(commands);
            this.context.sendASyncCommand((Command)composite);
        }
        this.previousZoom = 1.0;
        this.zoomAmount = 0;
        if (command != null) {
            command.setValid(false);
        }
        command = null;
        this.horizontal = 0;
        this.vertical = 0;
    }

    protected void cancel() {
        if (this.context != null) {
            this.zoomAmount = 0;
            this.previousZoom = 1.0;
            boolean requireUpdate = false;
            if (command != null) {
                requireUpdate = true;
                command.setValid(false);
            }
            command = null;
            this.horizontal = 0;
            this.vertical = 0;
            if (this.context.getViewportPane() != null && requireUpdate) {
                this.context.getViewportPane().repaint();
            }
        }
    }

    public static NavigationUpdateThread getUpdater() {
        return updater;
    }
}

