/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.shape;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.shapefile.FileReader;
import org.geotools.data.shapefile.ShpFileType;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.geotools.index.TreeException;
import org.geotools.index.quadtree.QuadTree;
import org.geotools.index.quadtree.StoreException;
import org.geotools.index.quadtree.fs.FileSystemIndexStore;
import org.geotools.renderer.shape.ShapefileRenderer;

public class IndexInfo
implements FileReader {
    final IndexType treeType;
    private QuadTree qtree;
    private ShpFiles shpFiles;

    public IndexInfo(IndexType treeType, ShpFiles shpFiles) {
        this.treeType = treeType;
        this.shpFiles = shpFiles;
    }

    CloseableIterator<Data> queryQuadTree(Envelope bbox) throws DataSourceException, IOException, TreeException {
        try {
            if (this.qtree != null && !bbox.contains(this.qtree.getRoot().getBounds())) {
                return this.qtree.search(bbox);
            }
        }
        catch (Exception e) {
            ShapefileRenderer.LOGGER.warning(e.getLocalizedMessage());
        }
        return null;
    }

    QuadTree openQuadTree() throws StoreException {
        URL url = this.shpFiles.acquireRead(ShpFileType.QIX, (FileReader)this);
        try {
            File file = DataUtilities.urlToFile((URL)url);
            FileSystemIndexStore store = new FileSystemIndexStore(file);
            try {
                QuadTree quadTree = store.load(this.openIndexFile(), false);
                return quadTree;
            }
            catch (IOException e) {
                throw new StoreException((Throwable)e);
            }
        }
        finally {
            this.shpFiles.unlockRead(url, (FileReader)this);
        }
    }

    IndexFile openIndexFile() throws IOException {
        if (this.shpFiles.get(ShpFileType.SHX) == null || this.shpFiles.isLocal() && !this.shpFiles.exists(ShpFileType.SHX)) {
            return null;
        }
        try {
            return new IndexFile(this.shpFiles, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    private CloseableIterator<Data> queryTree(Envelope bbox) throws IOException, TreeException {
        if (this.treeType == IndexType.QIX) {
            return this.queryQuadTree(bbox);
        }
        return null;
    }

    public String id() {
        return this.getClass().getName();
    }

    static class Reader
    implements RecordNumberTracker {
        private ShapefileReader shp;
        Iterator goodRecs;
        private int recno = 1;
        private Data next;
        private IndexInfo info;

        public Reader(IndexInfo info, ShapefileReader reader, Envelope bbox) throws IOException {
            this.shp = reader;
            try {
                if (info.treeType == IndexType.QIX) {
                    info.qtree = info.openQuadTree();
                }
                this.goodRecs = info.queryTree(bbox);
            }
            catch (Exception e) {
                ShapefileRenderer.LOGGER.log(Level.FINE, "Exception occured attempting to use indexing:", e);
                this.goodRecs = null;
            }
            this.info = info;
        }

        public int getRecordNumber() {
            return this.recno;
        }

        public boolean hasNext() throws IOException {
            if (this.goodRecs != null) {
                if (this.next != null) {
                    return true;
                }
                if (this.goodRecs.hasNext()) {
                    this.next = (Data)this.goodRecs.next();
                    this.recno = (Integer)this.next.getValue(0);
                    return true;
                }
                return false;
            }
            return this.shp.hasNext();
        }

        public ShapefileReader.Record next() throws IOException {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException("No more features in reader");
            }
            if (this.goodRecs != null) {
                Long l = (Long)this.next.getValue(1);
                ShapefileReader.Record record = this.shp.recordAt(l.intValue());
                this.next = null;
                return record;
            }
            ++this.recno;
            return this.shp.nextRecord();
        }

        public void close() throws IOException {
            this.shp.close();
            try {
                if (this.info.qtree != null) {
                    this.info.qtree.close(this.goodRecs);
                    this.info.qtree.close();
                }
            }
            catch (StoreException e) {
                e.printStackTrace();
            }
        }
    }
}

