/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.chart;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import org.geotools.geometry.jts.LiteShape;
import org.geotools.renderer.chart.GeometryDataset;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ShapeUtilities;

public class GeometryRenderer
extends AbstractXYItemRenderer {
    boolean renderCoordinates = true;
    boolean fillCoordinates = false;
    boolean fillPolygons;
    float polygonFillOpacity = 0.2f;

    public GeometryRenderer() {
        this.setStrokeWidth(2.0f);
        this.setAutoPopulateSeriesShape(false);
        this.setBaseShape(new Ellipse2D.Float(-3.0f, -3.0f, 6.0f, 6.0f));
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        return super.initialise(g2, dataArea, plot, data, info);
    }

    public void setRenderCoordinates(boolean renderCoordinates) {
        this.renderCoordinates = renderCoordinates;
    }

    public boolean isRenderCoordinates() {
        return this.renderCoordinates;
    }

    public void setFillCoordinates(boolean fillCoordinates) {
        this.fillCoordinates = fillCoordinates;
    }

    public boolean isFillCoordinates() {
        return this.fillCoordinates;
    }

    public void setFillPolygons(boolean fillPolygons) {
        this.fillPolygons = fillPolygons;
    }

    public boolean isFillPolygons() {
        return this.fillPolygons;
    }

    public void setPolygonFillOpacity(float polygonFillOpacity) {
        this.polygonFillOpacity = Math.max(0.0f, Math.min(polygonFillOpacity, 1.0f));
    }

    public float getPolygonFillOpacity() {
        return this.polygonFillOpacity;
    }

    public void setStrokeWidth(float width) {
        this.setBaseStroke(new BasicStroke(width));
    }

    public void setLegend(boolean legend) {
        this.setBaseSeriesVisibleInLegend(legend);
    }

    public int getPassCount() {
        return this.renderCoordinates ? 2 : 1;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo plotInfo, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        GeometryDataset gd = (GeometryDataset)dataset;
        Geometry g = gd.getGeometries().get(series);
        g2.setPaint(this.getItemPaint(series, item));
        g2.setStroke(this.getItemStroke(series, item));
        if (pass == 0) {
            this.drawGeometry(g, g2, series, item, dataArea, plot, domainAxis, rangeAxis);
        }
        if (pass == 1 && this.renderCoordinates) {
            if (g instanceof Point || g instanceof MultiPoint) {
                return;
            }
            for (Coordinate c : g.getCoordinates()) {
                this.drawCoordinate(c, g2, series, item, dataArea, plot, domainAxis, rangeAxis);
            }
        }
    }

    void drawGeometry(Geometry g, Graphics2D g2, int series, int item, Rectangle2D dataArea, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis) {
        if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.drawGeometry(gc.getGeometryN(i), g2, series, item, dataArea, plot, domainAxis, rangeAxis);
            }
        } else if (g instanceof Point) {
            this.drawCoordinate(((Point)g).getCoordinate(), g2, series, item, dataArea, plot, domainAxis, rangeAxis);
        } else if (g instanceof LineString) {
            g2.draw(new TranslatedLiteShape(g, dataArea, plot, domainAxis, rangeAxis));
        } else {
            if (this.fillPolygons) {
                Paint p = this.getSeriesPaint(series);
                if (p instanceof Color) {
                    Color c = (Color)p;
                    p = new Color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, this.polygonFillOpacity);
                }
                g2.setPaint(p);
                g2.fill(new TranslatedLiteShape(g, dataArea, plot, domainAxis, rangeAxis));
            }
            g2.setPaint(this.getSeriesPaint(series));
            g2.draw(new TranslatedLiteShape(g, dataArea, plot, domainAxis, rangeAxis));
        }
    }

    void drawCoordinate(Coordinate c, Graphics2D g2, int series, int item, Rectangle2D dataArea, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis) {
        double tx = domainAxis.valueToJava2D(c.x, dataArea, plot.getDomainAxisEdge());
        double ty = rangeAxis.valueToJava2D(c.y, dataArea, plot.getRangeAxisEdge());
        Shape shape = this.getItemShape(series, item);
        shape = ShapeUtilities.createTranslatedShape((Shape)shape, (double)tx, (double)ty);
        if (this.fillCoordinates) {
            g2.fill(shape);
        } else {
            g2.draw(shape);
        }
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        Paint fillPaint;
        LegendItem li = super.getLegendItem(datasetIndex, series);
        Stroke outlineStroke = this.getItemStroke(series, 0);
        Paint outlinePaint = fillPaint = li.getFillPaint();
        if (!this.fillCoordinates) {
            fillPaint = new Color(255, 255, 255, 255);
        }
        return new LegendItem(li.getLabel(), li.getDescription(), li.getToolTipText(), li.getURLText(), li.getShape(), fillPaint, outlineStroke, outlinePaint);
    }

    static class TranslatedLiteShape
    extends LiteShape {
        Rectangle2D dataArea;
        XYPlot plot;
        ValueAxis domainAxis;
        ValueAxis rangeAxis;

        public TranslatedLiteShape(Geometry geom, Rectangle2D dataArea, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis) {
            super(geom, new AffineTransform(), false);
            this.dataArea = dataArea;
            this.plot = plot;
            this.domainAxis = domainAxis;
            this.rangeAxis = rangeAxis;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            return new TranslatedIterator(super.getPathIterator(at));
        }

        class TranslatedIterator
        implements PathIterator {
            PathIterator delegate;

            public TranslatedIterator(PathIterator delegate) {
                this.delegate = delegate;
            }

            @Override
            public int currentSegment(float[] coords) {
                int i = this.delegate.currentSegment(coords);
                coords[0] = (float)TranslatedLiteShape.this.domainAxis.valueToJava2D((double)coords[0], TranslatedLiteShape.this.dataArea, TranslatedLiteShape.this.plot.getDomainAxisEdge());
                coords[1] = (float)TranslatedLiteShape.this.rangeAxis.valueToJava2D((double)coords[1], TranslatedLiteShape.this.dataArea, TranslatedLiteShape.this.plot.getRangeAxisEdge());
                return i;
            }

            @Override
            public int currentSegment(double[] coords) {
                int i = this.delegate.currentSegment(coords);
                coords[0] = TranslatedLiteShape.this.domainAxis.valueToJava2D(coords[0], TranslatedLiteShape.this.dataArea, TranslatedLiteShape.this.plot.getDomainAxisEdge());
                coords[1] = TranslatedLiteShape.this.rangeAxis.valueToJava2D(coords[1], TranslatedLiteShape.this.dataArea, TranslatedLiteShape.this.plot.getRangeAxisEdge());
                return i;
            }

            @Override
            public int getWindingRule() {
                return this.delegate.getWindingRule();
            }

            @Override
            public boolean isDone() {
                return this.delegate.isDone();
            }

            @Override
            public void next() {
                this.delegate.next();
            }
        }
    }
}

