/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster.format;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.grassraster.GrassCoverageReader;
import org.geotools.gce.grassraster.GrassCoverageWriter;
import org.geotools.gce.grassraster.JGrassUtilities;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public final class GrassCoverageFormat
extends AbstractGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.grassraster");

    public GrassCoverageFormat() {
        this.mInfo = new HashMap();
        this.mInfo.put("name", "grass");
        this.mInfo.put("description", "Grass Coverage Format");
        this.mInfo.put("vendor", "Geotools");
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D}));
        this.writeParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{GEOTOOLS_WRITE_PARAMS}));
    }

    public GrassCoverageReader getReader(Object o) {
        return this.getReader(o, null);
    }

    public GrassCoverageWriter getWriter(Object destination, Hints hints) {
        try {
            return new GrassCoverageWriter(destination);
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GridCoverageWriter getWriter(Object destination) {
        return this.getWriter(destination, null);
    }

    public boolean accepts(Object o, Hints hints) {
        File fileToUse;
        if (o instanceof File) {
            fileToUse = (File)o;
        } else if (o instanceof URL) {
            fileToUse = DataUtilities.urlToFile((URL)o);
        } else if (o instanceof String) {
            fileToUse = new File((String)o);
        } else {
            return false;
        }
        if (!fileToUse.exists()) {
            return false;
        }
        return JGrassUtilities.isGrass(fileToUse.getAbsolutePath());
    }

    public GrassCoverageReader getReader(Object o, Hints hints) {
        try {
            GrassCoverageReader coverageReader = new GrassCoverageReader(o);
            return coverageReader;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        return null;
    }
}

