/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.grid.io.AbstractGridCoverageWriter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.GrassBinaryImageWriter;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.spi.GrassBinaryImageWriterSpi;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.util.ProgressListener;

public class GrassCoverageWriter
extends AbstractGridCoverageWriter
implements GridCoverageWriter {
    private File output;
    private ProgressListener monitor = new DummyProgressListener();

    public GrassCoverageWriter(Object output) {
        if (!(output instanceof File)) {
            throw new IllegalArgumentException("Illegal input argument!");
        }
        this.output = (File)output;
    }

    public void setProgressListener(ProgressListener monitor) {
        this.monitor = monitor;
    }

    public void writeRaster(GridCoverage2D gridCoverage2D) throws IOException {
        try {
            Envelope2D env = gridCoverage2D.getEnvelope2D();
            GridEnvelope2D worldToGrid = gridCoverage2D.getGridGeometry().worldToGrid(env);
            double xRes = env.getWidth() / worldToGrid.getWidth();
            double yRes = env.getHeight() / worldToGrid.getHeight();
            JGrassRegion region = new JGrassRegion(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), xRes, yRes);
            GrassBinaryImageWriterSpi writerSpi = new GrassBinaryImageWriterSpi();
            GrassBinaryImageWriter writer = new GrassBinaryImageWriter(writerSpi, this.monitor);
            RenderedImage renderedImage = gridCoverage2D.view(ViewType.GEOPHYSICS).getRenderedImage();
            writer.setOutput(this.output, region);
            writer.write(renderedImage);
            writer.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeRaster(GridCoverage2D gridCoverage2D, GeneralParameterValue[] params) throws IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        JGrassRegion writeRegion = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) continue;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                dim = gg.getGridRange2D().getBounds();
            }
            if (requestedEnvelope != null && dim != null) {
                DirectPosition lowerCorner = requestedEnvelope.getLowerCorner();
                double[] westSouth = lowerCorner.getCoordinate();
                DirectPosition upperCorner = requestedEnvelope.getUpperCorner();
                double[] eastNorth = upperCorner.getCoordinate();
                writeRegion = new JGrassRegion(westSouth[0], eastNorth[0], westSouth[1], eastNorth[1], dim.height, dim.width);
            }
        }
        if (writeRegion == null) {
            throw new IOException("Unable to define writing region.");
        }
        GrassBinaryImageWriterSpi writerSpi = new GrassBinaryImageWriterSpi();
        GrassBinaryImageWriter writer = new GrassBinaryImageWriter(writerSpi, this.monitor);
        RenderedImage renderedImage = gridCoverage2D.view(ViewType.GEOPHYSICS).getRenderedImage();
        writer.setOutput(this.output, writeRegion);
        writer.write(renderedImage);
        writer.dispose();
    }

    public Format getFormat() {
        return new GrassCoverageFormat();
    }

    public void write(GridCoverage coverage, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        if (coverage instanceof GridCoverage2D) {
            GridCoverage2D gridCoverage = (GridCoverage2D)coverage;
            if (parameters == null) {
                this.writeRaster(gridCoverage);
            } else {
                this.writeRaster(gridCoverage, parameters);
            }
        } else {
            throw new IllegalArgumentException("Coverage not a GridCoverage2D");
        }
    }
}

