/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageReadParam;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.GrassBinaryImageReader;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.JGrassUtilities;
import org.geotools.gce.grassraster.core.color.JGrassColorTable;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.metadata.GrassBinaryImageMetadata;
import org.geotools.gce.grassraster.spi.GrassBinaryImageReaderSpi;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.ProgressListener;

public class GrassCoverageReader
extends AbstractGridCoverage2DReader
implements GridCoverageReader {
    private GrassBinaryImageReader imageReader = null;
    private String name;
    private PixelInCell cellAnchor = PixelInCell.CELL_CENTER;
    private boolean useSubSamplingAsRequestedColsRows = false;
    private boolean castDoubleToFloating = false;
    private ProgressListener monitor = new DummyProgressListener();
    private JGrassMapEnvironment jgMapEnvironment;
    private double[] range;
    private String colorRulesString;
    private String categoriesString;
    private Interpolation interpolation;

    public GrassCoverageReader(Object input) {
        if (input instanceof File) {
            File file = (File)input;
            this.imageReader = new GrassBinaryImageReader(new GrassBinaryImageReaderSpi());
            this.imageReader.setInput(input);
            this.jgMapEnvironment = new JGrassMapEnvironment(file);
            this.name = file.getName();
            try {
                this.crs = this.jgMapEnvironment.getCoordinateReferenceSystem();
                JGrassRegion fileRegion = this.jgMapEnvironment.getFileRegion();
                Envelope env = fileRegion.getEnvelope();
                this.originalEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), this.crs));
                this.originalGridRange = new GridEnvelope2D(0, 0, fileRegion.getCols(), fileRegion.getRows());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Illegal input argument!");
        }
    }

    public void setParams(PixelInCell cellAnchor, Interpolation interpolation, boolean useSubSamplingAsColsRows, boolean castDoubleToFloating, ProgressListener monitor) {
        this.useSubSamplingAsRequestedColsRows = useSubSamplingAsColsRows;
        this.castDoubleToFloating = castDoubleToFloating;
        if (monitor != null) {
            this.monitor = monitor;
        }
        if (cellAnchor != null) {
            this.cellAnchor = cellAnchor;
        }
        if (interpolation != null) {
            this.interpolation = interpolation;
        }
    }

    public GridCoverage2D readRaster(JGrassRegion region) throws IOException {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        double EPS;
        double scaleY;
        double scaleX;
        HashMap<String, String> metaDataTable = ((GrassBinaryImageMetadata)this.imageReader.getImageMetadata(0)).toHashMap();
        double fileNorth = Double.parseDouble(metaDataTable.get("NORTH"));
        double fileSouth = Double.parseDouble(metaDataTable.get("SOUTH"));
        double fileEast = Double.parseDouble(metaDataTable.get("EAST"));
        double fileWest = Double.parseDouble(metaDataTable.get("WEST"));
        int fileRows = Integer.parseInt(metaDataTable.get("NROWS"));
        int fileCols = Integer.parseInt(metaDataTable.get("NCOLS"));
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        try {
            crs = CRS.parseWKT((String)metaDataTable.get("CRS"));
        }
        catch (FactoryException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        ImageReadParam imageReadParam = new ImageReadParam();
        Envelope2D requestedRegionEnvelope = null;
        Rectangle sourceRegion = null;
        int requestedRows = 0;
        int requestedCols = 0;
        double requestedWest = -1.0;
        double requestedEast = -1.0;
        double requestedSouth = -1.0;
        double requestedNorth = -1.0;
        double requestedXres = -1.0;
        double requestedYres = -1.0;
        int subSamplingX = 1;
        int subSamplingY = 1;
        double xDeltaW = 0.0;
        double xDeltaE = 0.0;
        double yDeltaN = 0.0;
        double yDeltaS = 0.0;
        double tmpDxW = 0.0;
        double tmpDyS = 0.0;
        double tmpDyN = 0.0;
        double tmpDxE = 0.0;
        int xPaddingSx = 0;
        int yPaddingTop = 0;
        if (region != null) {
            requestedRows = region.getRows();
            requestedCols = region.getCols();
            requestedWest = region.getWest();
            requestedEast = region.getEast();
            requestedSouth = region.getSouth();
            requestedNorth = region.getNorth();
            requestedXres = region.getWEResolution();
            requestedYres = region.getNSResolution();
            scaleX = (double)fileCols / (fileEast - fileWest);
            scaleY = (double)fileRows / (fileNorth - fileSouth);
            EPS = 1.0E-7;
            xmin = (int)Math.floor((requestedWest - fileWest) * scaleX + EPS);
            xmax = (int)Math.ceil((requestedEast - fileWest) * scaleX - EPS);
            ymin = (int)Math.floor((fileNorth - requestedNorth) * scaleY + EPS);
            ymax = (int)Math.ceil((fileNorth - requestedSouth) * scaleY - EPS);
            if (xmin < 0) {
                xPaddingSx = xmin;
                xmin = 0;
            }
            if (ymin < 0) {
                yPaddingTop = ymin;
                ymin = 0;
            }
            sourceRegion = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            requestedRegionEnvelope = new Envelope2D((CoordinateReferenceSystem)crs, requestedWest, requestedSouth, requestedEast - requestedWest, requestedNorth - requestedSouth);
            xDeltaW = requestedWest - fileWest;
            yDeltaS = requestedSouth - fileSouth;
            xDeltaE = requestedEast - fileEast;
            yDeltaN = requestedNorth - fileNorth;
            tmpDxW = xDeltaW > 0.0 ? 0.0 : xDeltaW;
            tmpDyS = yDeltaS > 0.0 ? 0.0 : yDeltaS;
            tmpDyN = yDeltaN < 0.0 ? 0.0 : yDeltaN;
            double d = tmpDxE = xDeltaE < 0.0 ? 0.0 : xDeltaE;
            if (!this.useSubSamplingAsRequestedColsRows) {
                JGrassRegion tmpRegion = new JGrassRegion(region);
                tmpRegion.setWEResolution((fileEast - fileWest) / (double)fileCols);
                tmpRegion.setNSResolution((fileNorth - fileSouth) / (double)fileRows);
                subSamplingX = (int)Math.floor((double)tmpRegion.getCols() / (double)requestedCols);
                subSamplingY = (int)Math.floor((double)tmpRegion.getRows() / (double)requestedRows);
                if (subSamplingX == 0) {
                    subSamplingX = 1;
                }
                if (subSamplingY == 0) {
                    subSamplingY = 1;
                }
                if (subSamplingX != subSamplingY) {
                    if (subSamplingX < subSamplingY) {
                        subSamplingY = subSamplingX;
                    } else {
                        subSamplingX = subSamplingY;
                    }
                }
            } else {
                double sourceCols = (requestedEast - requestedWest) / (double)(1 + xPaddingSx / (xmax - xmin)) / requestedXres;
                double sourceRows = (requestedNorth - requestedSouth) / (double)(1 + yPaddingTop / (ymax - ymin)) / requestedYres;
                subSamplingX = (int)Math.round(sourceCols += (double)xPaddingSx);
                subSamplingY = (int)Math.round(sourceRows += (double)yPaddingTop);
                if (subSamplingX < 1) {
                    subSamplingX = 1;
                }
                if (subSamplingY < 1) {
                    subSamplingY = 1;
                }
            }
        } else {
            requestedRows = fileRows;
            requestedCols = fileCols;
            requestedWest = fileWest;
            requestedEast = fileEast;
            requestedSouth = fileSouth;
            requestedNorth = fileNorth;
            scaleX = (double)fileCols / (fileEast - fileWest);
            scaleY = (double)fileRows / (fileNorth - fileSouth);
            EPS = 1.0E-6;
            xmin = (int)Math.floor((requestedWest - fileWest) * scaleX + EPS);
            xmax = (int)Math.ceil((requestedEast - fileWest) * scaleX - EPS);
            ymin = (int)Math.floor((fileNorth - requestedNorth) * scaleY + EPS);
            ymax = (int)Math.ceil((fileNorth - requestedSouth) * scaleY - EPS);
            sourceRegion = new Rectangle(xmin, ymin, xmax - xmin, ymax - ymin);
            requestedRegionEnvelope = new Envelope2D((CoordinateReferenceSystem)crs, requestedWest, requestedSouth, requestedEast - requestedWest, requestedNorth - requestedSouth);
            if (!this.useSubSamplingAsRequestedColsRows) {
                subSamplingX = 1;
                subSamplingY = 1;
            } else {
                subSamplingX = fileCols;
                subSamplingY = fileRows;
            }
        }
        if (sourceRegion.getWidth() <= 0.0 || sourceRegion.getHeight() <= 0.0) {
            return null;
        }
        imageReadParam.setSourceRegion(sourceRegion);
        imageReadParam.setSourceSubsampling(subSamplingX, subSamplingY, 0, 0);
        RenderedImage finalImage = null;
        BufferedImage image = this.imageReader.read(0, imageReadParam, this.useSubSamplingAsRequestedColsRows, this.castDoubleToFloating, this.monitor);
        this.imageReader.dispose();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        if (requestedSouth < fileSouth || requestedWest < fileWest || requestedEast > fileEast || requestedNorth > fileNorth) {
            double totalHeigth = requestedNorth - tmpDyN - (requestedSouth - tmpDyS);
            int xPaddingDx = 0;
            if (xDeltaE > 0.0) {
                xPaddingDx = (int)Math.round(xDeltaE * (double)imageWidth / (requestedEast - tmpDxE - (requestedWest - tmpDxW)));
            }
            int yPaddingBottom = 0;
            if (yDeltaS < 0.0) {
                yPaddingBottom = (int)Math.round(yDeltaS * (double)imageHeight / totalHeigth);
            }
            RenderedImage translatedImage = this.setPadding(xPaddingSx, xPaddingDx, yPaddingTop, yPaddingBottom, image);
            finalImage = requestedRows != imageHeight || requestedCols != imageWidth ? JGrassUtilities.scaleJAIImage(requestedCols, requestedRows, translatedImage, this.interpolation) : translatedImage;
        } else {
            finalImage = requestedRows != imageHeight || requestedCols != imageWidth ? JGrassUtilities.scaleJAIImage(requestedCols, requestedRows, image, this.interpolation) : image;
        }
        if (finalImage instanceof RenderedOp) {
            RenderedOp rOp = (RenderedOp)finalImage;
            finalImage = rOp.getAsBufferedImage();
        }
        double min = JGrassMapEnvironment.defaultMapMin;
        double max = JGrassMapEnvironment.defaultMapMax;
        File rangeFile = this.jgMapEnvironment.getCELLMISC_RANGE();
        if (rangeFile.exists()) {
            FileInputStream is = new FileInputStream(rangeFile);
            byte[] numbers = new byte[16];
            int testread = ((InputStream)is).read(numbers);
            ((InputStream)is).close();
            if (testread == 16) {
                ByteBuffer rangeBuffer = ByteBuffer.wrap(numbers);
                min = rangeBuffer.getDouble();
                max = rangeBuffer.getDouble();
            }
        }
        this.range = new double[]{min, max};
        GridSampleDimension band = this.createGridSampleDimension(metaDataTable, this.range);
        band = band.geophysics(true);
        GridToEnvelopeMapper g2eMapper = new GridToEnvelopeMapper();
        g2eMapper.setEnvelope((org.opengis.geometry.Envelope)requestedRegionEnvelope);
        g2eMapper.setGridRange((GridEnvelope)new GridEnvelope2D(0, 0, requestedCols, requestedRows));
        g2eMapper.setPixelAnchor(this.cellAnchor);
        MathTransform gridToEnvelopeTransform = g2eMapper.createTransform();
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D coverage2D = factory.create((CharSequence)this.name, finalImage, (CoordinateReferenceSystem)crs, gridToEnvelopeTransform, new GridSampleDimension[]{band}, null, null);
        return coverage2D;
    }

    private RenderedImage setPadding(int xPaddingSx, int xPaddingDx, int yPaddingTop, int yPaddingBottom, RenderedImage image) {
        ParameterBlock block = new ParameterBlock();
        block.addSource(image);
        block.add(Math.abs(xPaddingSx));
        block.add(Math.abs(0));
        block.add(Math.abs(yPaddingTop));
        block.add(Math.abs(0));
        block.add(new BorderExtenderConstant(new double[]{Double.NaN}));
        RenderedOp paddedImage = JAI.create((String)"Border", (ParameterBlock)block);
        block = new ParameterBlock();
        block.addSource(paddedImage);
        block.add((float)(-xPaddingSx));
        block.add((float)(-yPaddingTop));
        return JAI.create((String)"translate", (ParameterBlock)block);
    }

    private GridSampleDimension createGridSampleDimension(HashMap<String, String> metaDataTable, double[] range) throws IOException {
        String[] colorRulesSplit;
        this.colorRulesString = metaDataTable.get("colorRulesDescriptor");
        this.categoriesString = metaDataTable.get("categoriesDescriptor");
        if (this.colorRulesString.length() > 3 && !this.colorRulesString.matches(".*Infinty.*|.*NaN.*")) {
            colorRulesSplit = this.colorRulesString.split("@@split@@");
        } else {
            List<String> defColorTable = JGrassColorTable.createDefaultColorTable(range, 255);
            colorRulesSplit = defColorTable.toArray(new String[defColorTable.size()]);
            File colrFile = this.jgMapEnvironment.getCOLR();
            JGrassUtilities.makeColorRulesPersistent(colrFile, defColorTable, range, 255);
        }
        if (colorRulesSplit != null) {
            int COLORNUM = 60000;
            int rulesNum = colorRulesSplit.length;
            if (colorRulesSplit.length > COLORNUM) {
                COLORNUM = colorRulesSplit.length + 1;
            }
            if (COLORNUM > 65500) {
                COLORNUM = 65500;
            }
            ArrayList<Category> catsList = new ArrayList<Category>();
            double[][] values = new double[rulesNum][2];
            Color[][] colors = new Color[rulesNum][2];
            for (int i = 0; i < rulesNum; ++i) {
                String colorRule = colorRulesSplit[i];
                JGrassColorTable.parseColorRule(colorRule, values[i], colors[i]);
                if (values[i][0] != values[i][1]) continue;
                colors[i][1] = colors[i][0];
            }
            Category noData = new Category((CharSequence)"novalue", new Color(Color.WHITE.getRed(), Color.WHITE.getGreen(), Color.WHITE.getBlue(), 0), 0);
            catsList.add(noData);
            double a = (values[values.length - 1][1] - values[0][0]) / (double)(COLORNUM - 1);
            double pmin = 1.0;
            double scale = a;
            if (scale == 0.0) {
                scale = 1.0;
            }
            double offSet = values[0][0] - scale * pmin;
            int previousUpper = -2147483647;
            for (int i = 0; i < rulesNum; ++i) {
                StringBuilder sB = new StringBuilder();
                sB.append(this.name);
                sB.append("_");
                sB.append(i);
                double tmpLower = values[i][0];
                double tmpUpper = values[i][1];
                int lower = (int)((tmpLower - values[0][0]) / scale + pmin);
                int upper = (int)((tmpUpper - values[0][0]) / scale + pmin);
                if (lower <= previousUpper) {
                    lower = previousUpper + 1;
                }
                if (lower >= upper) {
                    upper = lower + 1;
                }
                previousUpper = upper;
                Category dataCategory = new Category((CharSequence)sB.toString(), colors[i], lower, upper, scale, offSet);
                catsList.add(dataCategory);
            }
            Category[] array = catsList.toArray(new Category[catsList.size()]);
            return new GridSampleDimension((CharSequence)this.name, array, null);
        }
        return new GridSampleDimension((CharSequence)this.name, new Category[0], null);
    }

    public String getLegendString() {
        return this.colorRulesString;
    }

    public String getCategoriesString() {
        return this.categoriesString;
    }

    public double[] getRange() {
        return this.range;
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) continue;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                requestedEnvelope = new GeneralEnvelope((org.opengis.geometry.Envelope)gg.getEnvelope2D());
                dim = gg.getGridRange2D().getBounds();
            }
        }
        if (requestedEnvelope != null && dim != null) {
            DirectPosition lowerCorner = requestedEnvelope.getLowerCorner();
            double[] westSouth = lowerCorner.getCoordinate();
            DirectPosition upperCorner = requestedEnvelope.getUpperCorner();
            double[] eastNorth = upperCorner.getCoordinate();
            JGrassRegion region = new JGrassRegion(westSouth[0], eastNorth[0], westSouth[1], eastNorth[1], dim.height, dim.width);
            return this.readRaster(region);
        }
        return this.readRaster(null);
    }

    public Format getFormat() {
        return new GrassCoverageFormat();
    }
}

