/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.imageio;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.imageio.ImageServiceImpl;
import net.refractions.udig.catalog.imageio.internal.GDALFormatProvider;
import net.refractions.udig.catalog.imageio.internal.Messages;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;

public class ImageServiceExtension
implements ServiceExtension2 {
    public static final String URL_PARAM = "URL";
    public static final String TYPE = "imageio";

    public IService createService(URL id, Map<String, Serializable> params) {
        URL id2 = id;
        if (id2 == null) {
            id2 = this.getID(params);
        }
        if (!this.canProcess(id2)) {
            return null;
        }
        ImageServiceImpl service = new ImageServiceImpl(id2, ImageServiceExtension.getFactoryForObject(id2, null));
        return service;
    }

    private URL getID(Map<String, Serializable> params) {
        if (params.containsKey(URL_PARAM)) {
            Serializable param = params.get(URL_PARAM);
            if (param instanceof String) {
                try {
                    return new URL((String)((Object)param));
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            if (param instanceof URL) {
                return (URL)param;
            }
            return null;
        }
        return null;
    }

    public static synchronized GridFormatFactorySpi getFactory(String formatName) {
        return GDALFormatProvider.factories.get(formatName);
    }

    private boolean canProcess(URL id) {
        return this.reasonForFailure(id) == null;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!this.canProcess(url)) {
            return null;
        }
        if (url != null) {
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(URL_PARAM, url);
            return params;
        }
        return null;
    }

    public String reasonForFailure(Map<String, Serializable> params) {
        return this.reasonForFailure(this.getID(params));
    }

    public String reasonForFailure(URL id) {
        if (id == null) {
            return Messages.ImageServiceExtension_noID;
        }
        if (!id.getProtocol().equals("file")) {
            return Messages.ImageServiceExtension_mustBeFIle;
        }
        File file = null;
        try {
            file = URLUtils.urlToFile((URL)id);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return String.valueOf(Messages.ImageServiceExtension_IllegalFilePart1) + id.getFile() + Messages.ImageServiceExtension_IllegalFilePart2;
        }
        String filename = file.getName();
        int split = filename.lastIndexOf(".");
        String fileExt = split == -1 ? "" : filename.substring(split + 1);
        String found = null;
        if (GDALFormatProvider.supportedExtensions.contains(fileExt.toLowerCase())) {
            found = fileExt;
        }
        if (found == null) {
            return Messages.ImageServiceExtension_geotoolsDisagrees;
        }
        AbstractGridFormat format = ImageServiceExtension.getFormatForObject(id, file);
        if (format == null) {
            return Messages.ImageServiceExtension_geotoolsDisagrees;
        }
        return null;
    }

    private static GridFormatFactorySpi getFactoryForObject(URL id, File file) {
        for (GridFormatFactorySpi spi : GDALFormatProvider.factories.values()) {
            AbstractGridFormat format = spi.createFormat();
            if (file != null && format.accepts((Object)file)) {
                return spi;
            }
            if (id == null || !format.accepts((Object)id)) continue;
            return spi;
        }
        return null;
    }

    private static AbstractGridFormat getFormatForObject(URL id, File file) {
        GridFormatFactorySpi spi = ImageServiceExtension.getFactoryForObject(id, file);
        return spi != null ? spi.createFormat() : null;
    }
}

