/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.geotiff;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension2;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.geotiff.internal.Messages;
import net.refractions.udig.catalog.internal.geotiff.GeoTiffServiceImpl;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffFormatFactorySpi;

public class GeoTiffServiceExtension
implements ServiceExtension2 {
    public static final String URL_PARAM = "URL";
    public static final String TYPE = "geotiff";
    private static GeoTiffFormatFactorySpi factory;
    private static GeoTiffFormat format;

    public IService createService(URL id, Map<String, Serializable> params) {
        URL id2 = id;
        if (id2 == null) {
            id2 = this.extractID(params);
        }
        if (!this.canProcess(this.extractID(params))) {
            return null;
        }
        GeoTiffServiceImpl service = new GeoTiffServiceImpl(this.extractID(params), (GridFormatFactorySpi)GeoTiffServiceExtension.getFactory());
        return service;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL extractID(Map<String, Serializable> params) {
        if (!params.containsKey(URL_PARAM)) return null;
        Serializable param = params.get(URL_PARAM);
        if (param instanceof String) {
            try {
                return new URL((String)((Object)param));
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (!(param instanceof URL)) return null;
        return (URL)param;
    }

    private static synchronized GeoTiffFormat getFormat() {
        if (format == null) {
            format = (GeoTiffFormat)GeoTiffServiceExtension.getFactory().createFormat();
        }
        return format;
    }

    public static synchronized GeoTiffFormatFactorySpi getFactory() {
        if (factory == null) {
            factory = new GeoTiffFormatFactorySpi();
        }
        return factory;
    }

    private boolean canProcess(URL id) {
        return this.reasonForFailure(id) == null;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!this.canProcess(url)) {
            return null;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        if (url != null) {
            params.put(URL_PARAM, url);
        }
        return params;
    }

    public String reasonForFailure(Map<String, Serializable> params) {
        return this.reasonForFailure(this.extractID(params));
    }

    public String reasonForFailure(URL url) {
        if (url == null) {
            return Messages.GeoTiffServiceExtension_nullURL;
        }
        if (!this.isSupportedExtension(url)) {
            return Messages.GeoTiffServiceExtension_badExt;
        }
        File file = null;
        try {
            ID id = new ID(url);
            file = id.toFile();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return String.valueOf(url.toExternalForm()) + Messages.GeoTiffServiceExtension_notFile;
        }
        if (!file.exists()) {
            return file + Messages.GeoTiffServiceExtension_notExist;
        }
        try {
            if (!GeoTiffServiceExtension.getFormat().accepts((Object)file)) {
                return Messages.GeoTiffServiceExtension_unknown;
            }
        }
        catch (RuntimeException runtimeException) {
            return Messages.GeoTiffServiceExtension_unknown;
        }
        return null;
    }

    private boolean isSupportedExtension(URL url) {
        boolean isTiff;
        File file = URLUtils.urlToFile((URL)url);
        String fileLower = file.getAbsolutePath().toLowerCase();
        boolean bl = isTiff = fileLower.endsWith(".tiff") || fileLower.endsWith(".tif");
        return isTiff;
    }
}

