/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageTypeSpecifier;
import org.geotools.arcsde.raster.info.PyramidLevelInfo;
import org.geotools.arcsde.raster.info.RasterBandInfo;
import org.geotools.arcsde.raster.info.RasterCellType;
import org.geotools.arcsde.raster.info.RasterInfo;
import org.geotools.arcsde.raster.info.RasterUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.NumberRange;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class RasterDatasetInfo {
    private String rasterTable = null;
    private String[] rasterColumns;
    private List<RasterInfo> subRasterInfo;
    private GridEnvelope originalGridRange;
    private List<GridSampleDimension> gridSampleDimensions;
    private final Map<Integer, ImageTypeSpecifier> renderedImageSpec = new HashMap<Integer, ImageTypeSpecifier>();

    void setRasterTable(String rasterTable) {
        this.rasterTable = rasterTable;
    }

    public String getRasterTable() {
        return this.rasterTable;
    }

    void setRasterColumns(String[] rasterColumns) {
        this.rasterColumns = rasterColumns;
    }

    public String[] getRasterColumns() {
        return this.rasterColumns;
    }

    public void setPyramidInfo(List<RasterInfo> pyramidInfo) {
        this.subRasterInfo = pyramidInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridSampleDimension[] getGridSampleDimensions() {
        if (this.gridSampleDimensions == null) {
            RasterDatasetInfo rasterDatasetInfo = this;
            synchronized (rasterDatasetInfo) {
                if (this.gridSampleDimensions == null) {
                    this.gridSampleDimensions = this.buildSampleDimensions();
                }
            }
        }
        return this.gridSampleDimensions.toArray(new GridSampleDimension[this.getNumBands()]);
    }

    private List<GridSampleDimension> buildSampleDimensions() {
        int numBands = this.getNumBands();
        ArrayList<GridSampleDimension> dimensions = new ArrayList<GridSampleDimension>(numBands);
        Color transparent = new Color(0, 0, 0, 0);
        List<RasterBandInfo> bands = this.subRasterInfo.get(0).getBands();
        for (RasterBandInfo band : bands) {
            Category[] categories;
            NumberRange sampleValueRange;
            RasterCellType targetCellType = this.getNativeCellType();
            String bandName = band.getBandName();
            double statsMin = band.getStatsMin();
            double statsMax = band.getStatsMax();
            if (Double.isNaN(statsMin) || Double.isNaN(statsMax)) {
                sampleValueRange = targetCellType.getSampleValueRange();
            } else {
                sampleValueRange = NumberRange.create((double)statsMin, (double)statsMax);
                Class elementClass = targetCellType.getSampleValueRange().getElementClass();
                sampleValueRange = sampleValueRange.castTo(elementClass);
            }
            Color[] colorRange = null;
            boolean geophysics = this.isGeoPhysics();
            Category valuesCat = new Category((CharSequence)"values", colorRange, sampleValueRange, (MathTransform1D)LinearTransform1D.IDENTITY).geophysics(geophysics);
            if (geophysics) {
                double noDataValue = band.getNoDataValue().doubleValue();
                Category nodataCat = new Category((CharSequence)Vocabulary.formatInternational((int)147), transparent, noDataValue);
                categories = new Category[]{valuesCat, nodataCat};
            } else {
                categories = new Category[]{valuesCat};
            }
            GridSampleDimension sampleDim = new GridSampleDimension((CharSequence)bandName, categories, null).geophysics(false);
            dimensions.add(sampleDim);
        }
        return dimensions;
    }

    private boolean isGeoPhysics() {
        if (this.isColorMapped()) {
            return false;
        }
        return RasterUtils.isGeoPhysics(this.getNumBands(), this.getNativeCellType());
    }

    public int getNumBands() {
        return this.subRasterInfo.get(0).getNumBands();
    }

    public int getImageWidth() {
        GridEnvelope originalGridRange = this.getOriginalGridRange();
        int width = originalGridRange.getSpan(0);
        return width;
    }

    public int getImageHeight() {
        GridEnvelope originalGridRange = this.getOriginalGridRange();
        int height = originalGridRange.getSpan(1);
        return height;
    }

    public CoordinateReferenceSystem getCoverageCrs() {
        return this.subRasterInfo.get(0).getCoordinateReferenceSystem();
    }

    public GridEnvelope getOriginalGridRange() {
        if (this.originalGridRange == null) {
            MathTransform modelToRaster;
            int rasterCount = this.getNumRasters();
            if (1 == rasterCount) {
                this.originalGridRange = this.getGridRange(0, 0);
                return this.originalGridRange;
            }
            try {
                MathTransform rasterToModel = this.getRasterToModel();
                modelToRaster = rasterToModel.inverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalStateException("Can't create transform from model to raster");
            }
            int minx = Integer.MAX_VALUE;
            int miny = Integer.MAX_VALUE;
            int maxx = Integer.MIN_VALUE;
            int maxy = Integer.MIN_VALUE;
            for (int rasterN = 0; rasterN < rasterCount; ++rasterN) {
                GeneralEnvelope rasterGridRangeInDataSet;
                GeneralEnvelope rasterEnvelope = this.getGridEnvelope(rasterN, 0);
                try {
                    rasterGridRangeInDataSet = CRS.transform((MathTransform)modelToRaster, (Envelope)rasterEnvelope);
                }
                catch (NoninvertibleTransformException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (TransformException e) {
                    throw new IllegalArgumentException(e);
                }
                minx = Math.min(minx, (int)Math.floor(rasterGridRangeInDataSet.getMinimum(0)));
                miny = Math.min(miny, (int)Math.floor(rasterGridRangeInDataSet.getMinimum(1)));
                maxx = Math.max(maxx, (int)Math.ceil(rasterGridRangeInDataSet.getMaximum(0)));
                maxy = Math.max(maxy, (int)Math.ceil(rasterGridRangeInDataSet.getMaximum(1)));
            }
            int width = maxx - minx;
            int height = maxy - miny;
            Rectangle range = new Rectangle(0, 0, width, height);
            this.originalGridRange = new GeneralGridEnvelope(range, 2);
        }
        return this.originalGridRange;
    }

    public MathTransform getRasterToModel() {
        return this.getRasterToModel(0, 0);
    }

    public MathTransform getRasterToModel(int rasterIndex, int pyramidLevel) {
        GeneralEnvelope levelEnvelope = this.getGridEnvelope(rasterIndex, pyramidLevel);
        GridEnvelope levelGridRange = this.getGridRange(rasterIndex, pyramidLevel);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(levelGridRange, (Envelope)levelEnvelope);
        geMapper.setPixelAnchor(PixelInCell.CELL_CORNER);
        MathTransform rasterToModel = geMapper.createTransform();
        return rasterToModel;
    }

    public GeneralEnvelope getOriginalEnvelope(PixelInCell pixelAnchor) {
        GeneralEnvelope env = null;
        if (1 == this.getNumRasters()) {
            env = this.getGridEnvelope(0, 0);
        } else {
            for (RasterInfo raster : this.subRasterInfo) {
                int rasterIndex = this.getRasterIndex(raster.getRasterId());
                GeneralEnvelope rasterEnvelope = this.getGridEnvelope(rasterIndex, 0);
                if (env == null) {
                    env = new GeneralEnvelope((Envelope)rasterEnvelope);
                    continue;
                }
                env.add((Envelope)rasterEnvelope);
            }
        }
        if (PixelInCell.CELL_CENTER.equals((Object)pixelAnchor)) {
            double[] resolution = this.getResolution(0, 0);
            double deltaX = resolution[0] / 2.0;
            double deltaY = resolution[1] / 2.0;
            env.setEnvelope(new double[]{env.getMinimum(0) + deltaX, env.getMinimum(1) + deltaY, env.getMaximum(0) - deltaX, env.getMaximum(1) - deltaY});
        }
        return env;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ArcSDE Raster: " + this.getRasterTable());
        sb.append(", Raster columns: ").append(Arrays.asList(this.getRasterColumns()));
        sb.append(", Num bands: ").append(this.getNumBands());
        sb.append(", Dimension: ").append(this.getImageWidth()).append("x").append(this.getImageHeight());
        sb.append(", Pixel type: ").append((Object)this.getNativeCellType());
        sb.append(", Has Color Map: ").append(this.isColorMapped());
        for (int rasterIndex = 0; rasterIndex < this.getNumRasters(); ++rasterIndex) {
            RasterInfo raster = this.getRasterInfo(rasterIndex);
            sb.append("\n ");
            sb.append(raster.toString());
        }
        return sb.toString();
    }

    public int getNumRasters() {
        return this.subRasterInfo.size();
    }

    public RasterBandInfo getBand(int rasterIndex, int bandIndex) {
        RasterInfo rasterInfo = this.getRasterInfo(rasterIndex);
        return rasterInfo.getBand(bandIndex);
    }

    public int getNumPyramidLevels(int rasterIndex) {
        RasterInfo rasterInfo = this.getRasterInfo(rasterIndex);
        return rasterInfo.getNumLevels();
    }

    public GeneralEnvelope getGridEnvelope(int rasterIndex, int pyramidLevel) {
        PyramidLevelInfo level = this.getLevel(rasterIndex, pyramidLevel);
        return level.getSpatialExtent();
    }

    public GridEnvelope getGridRange(int rasterIndex, int pyramidLevel) {
        PyramidLevelInfo level = this.getLevel(rasterIndex, pyramidLevel);
        GridEnvelope levelRange = level.getGridEnvelope();
        return levelRange;
    }

    public int getNumTilesWide(int rasterIndex, int pyramidLevel) {
        PyramidLevelInfo level = this.getLevel(rasterIndex, pyramidLevel);
        return level.getNumTilesWide();
    }

    public int getNumTilesHigh(int rasterIndex, int pyramidLevel) {
        PyramidLevelInfo level = this.getLevel(rasterIndex, pyramidLevel);
        return level.getNumTilesHigh();
    }

    public int getTileWidth(long rasterId) {
        return this.getTileDimension((long)rasterId).width;
    }

    public int getTileHeight(long rasterId) {
        return this.getTileDimension((long)rasterId).height;
    }

    public Dimension getTileDimension(long rasterId) {
        int rasterIndex = this.getRasterIndex(rasterId);
        RasterInfo rasterInfo = this.getRasterInfo(rasterIndex);
        return rasterInfo.getTileDimension();
    }

    public Dimension getTileDimension(int rasterIndex) {
        RasterInfo rasterInfo = this.getRasterInfo(rasterIndex);
        return rasterInfo.getTileDimension();
    }

    private PyramidLevelInfo getLevel(int rasterIndex, int pyramidLevel) {
        RasterInfo rasterInfo = this.getRasterInfo(rasterIndex);
        PyramidLevelInfo level = rasterInfo.getPyramidLevel(pyramidLevel);
        return level;
    }

    private RasterInfo getRasterInfo(int rasterIndex) {
        RasterInfo rasterInfo = this.subRasterInfo.get(rasterIndex);
        return rasterInfo;
    }

    public ImageTypeSpecifier getRenderedImageSpec(long rasterId) {
        int rasterIndex = this.getRasterIndex(rasterId);
        return this.getRenderedImageSpec(rasterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageTypeSpecifier getRenderedImageSpec(int rasterIndex) {
        if (!this.renderedImageSpec.containsKey(rasterIndex)) {
            RasterDatasetInfo rasterDatasetInfo = this;
            synchronized (rasterDatasetInfo) {
                if (!this.renderedImageSpec.containsKey(rasterIndex)) {
                    ImageTypeSpecifier imageTypeSpecifier = RasterUtils.createFullImageTypeSpecifier(this, rasterIndex);
                    this.renderedImageSpec.put(rasterIndex, imageTypeSpecifier);
                }
            }
        }
        return this.renderedImageSpec.get(rasterIndex);
    }

    public IndexColorModel getColorMap(int rasterIndex) {
        RasterBandInfo bandOne = this.getBand(rasterIndex, 0);
        return bandOne.getColorMap();
    }

    public boolean isColorMapped() {
        RasterInfo rasterInfo = this.getRasterInfo(0);
        return rasterInfo.isColorMapped();
    }

    public RasterCellType getNativeCellType() {
        RasterInfo rasterInfo = this.getRasterInfo(0);
        return rasterInfo.getNativeCellType();
    }

    public RasterCellType getTargetCellType(int rasterIndex) {
        RasterInfo rasterInfo = this.getRasterInfo(rasterIndex);
        return rasterInfo.getTargetCellType();
    }

    public RasterCellType getTargetCellType(long rasterId) {
        int rasterIndex = this.getRasterIndex(rasterId);
        return this.getTargetCellType(rasterIndex);
    }

    public Long getRasterId(int rasterIndex) {
        RasterInfo rasterInfo = this.getRasterInfo(rasterIndex);
        return rasterInfo.getRasterId();
    }

    public int getOptimalPyramidLevel(int rasterIndex, OverviewPolicy policy, GeneralEnvelope requestedEnvelope, GridEnvelope requestedDim) {
        RasterInfo rasterInfo = this.getRasterInfo(rasterIndex);
        double[] requestedRes = new double[2];
        double reqSpanX = requestedEnvelope.getSpan(0);
        double reqSpanY = requestedEnvelope.getSpan(1);
        requestedRes[0] = reqSpanX / (double)requestedDim.getSpan(0);
        requestedRes[1] = reqSpanY / (double)requestedDim.getSpan(1);
        return rasterInfo.getOptimalPyramidLevel(policy, requestedRes);
    }

    public int getRasterIndex(Long rasterId) {
        int index = -1;
        for (RasterInfo p : this.subRasterInfo) {
            ++index;
            if (!rasterId.equals(p.getRasterId())) continue;
            return index;
        }
        throw new IllegalArgumentException("rasterId: " + rasterId);
    }

    public double[] getResolution(int rasterN, int pyramidLevel) {
        RasterInfo rasterInfo = this.getRasterInfo(rasterN);
        double[] resolution = rasterInfo.getResolution(pyramidLevel);
        return resolution;
    }

    public Number getNoDataValue(long rasterId, int bandIndex) {
        int rasterIndex = this.getRasterIndex(rasterId);
        return this.getNoDataValue(rasterIndex, bandIndex);
    }

    public Number getNoDataValue(int rasterIndex, int bandIndex) {
        RasterBandInfo band = this.getBand(rasterIndex, bandIndex);
        Number noDataValue = band.getNoDataValue();
        return noDataValue;
    }

    public List<Number> getNoDataValues(int rasterIndex) {
        return this.getRasterInfo(rasterIndex).getNoDataValues();
    }

    public int getArcSDEPyramidLevel(Long rasterId, int pyramidLevel) {
        if (pyramidLevel == 0) {
            return 0;
        }
        RasterInfo rasterInfo = this.getRasterInfo(this.getRasterIndex(rasterId));
        boolean skipLevelOne = rasterInfo.isSkipLevelOne();
        if (skipLevelOne) {
            return pyramidLevel + 1;
        }
        return pyramidLevel;
    }
}

