/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SeQueryInfo;
import java.util.logging.Logger;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.geotools.arcsde.data.FIDReader;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;

final class FeatureTypeInfo {
    private static final Logger LOGGER = Logging.getLogger((String)FeatureTypeInfo.class.getName());
    private final SimpleFeatureType featureType;
    private final FIDReader fidStrategy;
    private final boolean isWritable;
    private final boolean versioned;
    private final boolean isView;
    private final PlainSelect definitionQuery;
    private final SeQueryInfo sdeDefinitionQuery;

    public FeatureTypeInfo(SimpleFeatureType featureType, FIDReader fidStrategy, boolean isWritable, boolean isMultiVersion, boolean isView) {
        this(featureType, fidStrategy, isWritable, isMultiVersion, isView, null, null);
    }

    public FeatureTypeInfo(SimpleFeatureType featureType, FIDReader fidStrategy, PlainSelect definitionQuery, SeQueryInfo sdeDefinitionQuery) {
        this(featureType, fidStrategy, false, false, false, definitionQuery, sdeDefinitionQuery);
    }

    private FeatureTypeInfo(SimpleFeatureType featureType, FIDReader fidStrategy, boolean isWritable, boolean isMultiVersion, boolean isView, PlainSelect definitionQuery, SeQueryInfo sdeDefinitionQuery) {
        assert (featureType != null);
        assert (fidStrategy != null);
        if (definitionQuery != null || sdeDefinitionQuery != null) {
            if (definitionQuery == null || sdeDefinitionQuery == null) {
                throw new NullPointerException("both SeQueryInfo and PlainSelect are needed for an in-process view");
            }
            if (isWritable) {
                throw new IllegalArgumentException("In-process views can't be writable");
            }
        }
        this.featureType = featureType;
        this.fidStrategy = fidStrategy;
        this.versioned = isMultiVersion;
        this.isView = isView;
        this.definitionQuery = definitionQuery;
        this.sdeDefinitionQuery = sdeDefinitionQuery;
        if (isView && isWritable) {
            LOGGER.info("Asked to create a writable view feature type, which is not supported. Using it readonly");
            this.isWritable = false;
        } else {
            this.isWritable = isWritable;
        }
    }

    public String getFeatureTypeName() {
        return this.featureType.getTypeName();
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public FIDReader getFidStrategy() {
        return this.fidStrategy;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public boolean isInProcessView() {
        return this.definitionQuery != null;
    }

    public PlainSelect getDefinitionQuery() {
        return this.definitionQuery;
    }

    public SeQueryInfo getSdeDefinitionQuery() {
        return this.sdeDefinitionQuery;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public boolean isView() {
        return this.isView;
    }
}

