/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.jts;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.hatbox.Entry;
import net.sourceforge.hatbox.RTree;
import net.sourceforge.hatbox.RTreeDml;
import net.sourceforge.hatbox.RTreeSessionDb;
import net.sourceforge.hatbox.jts.AbstractTrigger;

public class UpdateTrigger
extends AbstractTrigger {
    private String schema;
    private String table;

    public void fire(Connection con, Object[] oldRow, Object[] newRow) throws SQLException {
        Envelope e;
        byte[] bytes;
        RTreeDml dml = RTreeDml.createDml(con, this.schema, this.table);
        RTreeSessionDb session = new RTreeSessionDb(con, dml, true);
        RTree rTree = new RTree(session);
        int pkI = dml.getPkColumnIndex();
        int geomI = dml.getGeomColumnIndex();
        WKBReader reader = new WKBReader();
        Entry oldEntry = null;
        Entry newEntry = null;
        if (oldRow[geomI] != null) {
            try {
                bytes = this.toBytes(oldRow[geomI]);
            }
            catch (IOException e2) {
                throw (SQLException)new SQLException("Failed to obtain geom for " + oldRow[pkI]).initCause(e2);
            }
            Geometry oldGeom = null;
            try {
                oldGeom = reader.read(bytes);
            }
            catch (ParseException pe) {
                throw new SQLException("Failed to parse geom for " + oldRow[pkI]);
            }
            e = oldGeom.getEnvelopeInternal();
            oldEntry = new Entry(e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), ((Number)oldRow[pkI]).longValue());
        }
        if (newRow[geomI] != null) {
            try {
                bytes = this.toBytes(newRow[geomI]);
            }
            catch (IOException e3) {
                throw (SQLException)new SQLException("Failed to obtain geom for " + newRow[pkI]).initCause(e3);
            }
            Geometry newGeom = null;
            try {
                newGeom = reader.read(bytes);
            }
            catch (ParseException pe) {
                throw new SQLException("Failed to parse geom for " + newRow[pkI]);
            }
            e = newGeom.getEnvelopeInternal();
            newEntry = new Entry(e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), ((Number)newRow[pkI]).longValue());
        }
        if (newEntry == null || !newEntry.equals(oldEntry)) {
            if (oldEntry != null) {
                rTree.delete(oldEntry);
            }
            if (newEntry != null) {
                rTree.insert(newEntry);
            }
        }
        session.closeAll();
    }

    public void init(Connection con, String schema, String trigger, String table, boolean before, int type) throws SQLException {
        this.schema = schema;
        this.table = table;
    }
}

