/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.jts;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.sql.SQLException;
import java.util.List;
import net.sourceforge.hatbox.IdResultSet;
import net.sourceforge.hatbox.RTreeSessionDb;
import net.sourceforge.hatbox.SpatialPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredResultSet
extends IdResultSet {
    private Geometry query;
    private SpatialPredicate predicate;
    private WKBReader reader = new WKBReader();
    private RTreeSessionDb session;

    public FilteredResultSet(List<Long> ids, RTreeSessionDb session, Geometry query, SpatialPredicate predicate, String schema, String table) throws SQLException {
        super(ids, schema, table);
        this.session = session;
        this.query = query;
        this.predicate = predicate;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.query = null;
    }

    @Override
    public boolean next() throws SQLException {
        this.rowAvailable = false;
        byte[] candidateWKB = null;
        while (this.ids != null && !this.rowAvailable) {
            ++this.currentIndex;
            if (this.currentIndex < this.size) {
                this.id = (Long)this.ids.get(this.currentIndex);
                if (this.id == null || (candidateWKB = this.session.getWKB(this.id)) == null) continue;
                try {
                    this.rowAvailable = this.testPredicate(this.reader.read(candidateWKB));
                    continue;
                }
                catch (ParseException pe) {
                    throw new SQLException("Failed to parse WKB: " + pe.getMessage());
                }
            }
            this.ids = null;
        }
        return this.rowAvailable;
    }

    private boolean testPredicate(Geometry candidate) throws SQLException {
        boolean test = false;
        try {
            switch (this.predicate) {
                case CONTAINS: {
                    test = candidate.contains(this.query);
                    break;
                }
                case COVERS: {
                    test = candidate.covers(this.query);
                    break;
                }
                case COVEREDBY: {
                    test = candidate.coveredBy(this.query);
                    break;
                }
                case CROSSES: {
                    test = candidate.crosses(this.query);
                    break;
                }
                case DISJOINT: {
                    test = candidate.disjoint(this.query);
                    break;
                }
                case EQUALS: {
                    test = candidate.equals(this.query);
                    break;
                }
                case INTERSECTS: {
                    test = candidate.intersects(this.query);
                    break;
                }
                case OVERLAPS: {
                    test = candidate.overlaps(this.query);
                    break;
                }
                case TOUCHES: {
                    test = candidate.touches(this.query);
                    break;
                }
                case WITHIN: {
                    test = candidate.within(this.query);
                }
            }
        }
        catch (Exception e) {
            throw new SQLException("Failed spatial relation: " + (Object)((Object)this.predicate) + " " + e.getMessage());
        }
        return test;
    }
}

