/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox.jts;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import net.sourceforge.hatbox.Entry;
import net.sourceforge.hatbox.RTree;
import net.sourceforge.hatbox.RTreeDml;
import net.sourceforge.hatbox.RTreeSessionDb;
import net.sourceforge.hatbox.jts.AbstractTrigger;

public class DeleteTrigger
extends AbstractTrigger {
    private String schema;
    private String table;

    public void fire(Connection con, Object[] oldRow, Object[] newRow) throws SQLException {
        RTreeDml dml = RTreeDml.createDml(con, this.schema, this.table);
        RTreeSessionDb session = new RTreeSessionDb(con, dml, true);
        RTree rTree = new RTree(session);
        int pkI = dml.getPkColumnIndex();
        int geomI = dml.getGeomColumnIndex();
        if (oldRow[geomI] != null) {
            byte[] bytes;
            try {
                bytes = this.toBytes(oldRow[geomI]);
            }
            catch (IOException e) {
                throw (SQLException)new SQLException("Failed to obtain geom for " + oldRow[pkI]).initCause(e);
            }
            WKBReader reader = new WKBReader();
            Geometry geom = null;
            try {
                geom = reader.read(bytes);
            }
            catch (ParseException pe) {
                throw new SQLException("Failed to parse geom for " + oldRow[pkI]);
            }
            Envelope e = geom.getEnvelopeInternal();
            Entry entry = new Entry(e.getMinX(), e.getMaxX(), e.getMinY(), e.getMaxY(), ((Number)oldRow[pkI]).longValue());
            rTree.delete(entry);
        }
        session.closeAll();
    }

    public void init(Connection con, String schema, String trigger, String table, boolean before, int type) throws SQLException {
        this.schema = schema;
        this.table = table;
    }
}

