/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import net.sourceforge.hatbox.AbstractResultSet;
import net.sourceforge.hatbox.IdResultSetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdResultSet
extends AbstractResultSet {
    protected List<Long> ids;
    protected Long id;
    protected int currentIndex = -1;
    protected int size;
    protected boolean rowAvailable = false;
    private String schema;
    private String table;

    public IdResultSet(List<Long> ids, String schema, String table) {
        this.ids = ids;
        this.size = ids.size();
        this.schema = schema;
        this.table = table;
    }

    @Override
    public void close() throws SQLException {
        this.ids = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.ids == null;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return 1;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.ids == null) {
            this.rowAvailable = false;
        } else {
            ++this.currentIndex;
            if (this.currentIndex < this.size) {
                this.id = this.ids.get(this.currentIndex);
                this.rowAvailable = true;
            } else {
                this.rowAvailable = false;
            }
        }
        return this.rowAvailable;
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.id == null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.check(columnIndex);
        return this.id;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.check(columnIndex);
        if (this.id == null) {
            return null;
        }
        return this.id.toString();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.check(columnIndex);
        if (this.id == null) {
            return 0L;
        }
        return this.id;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new IdResultSetMetaData(this.schema, this.table);
    }

    private void check(int columnIndex) throws SQLException {
        if (this.rowAvailable) {
            if (columnIndex != 1) {
                throw new SQLException("Column index out of range");
            }
        } else {
            throw new SQLException("No row is current");
        }
    }
}

