/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.hatbox;

public class AbstractNode {
    public static final int PARENT_OFFSET = 0;
    public static final int LEVEL_OFFSET = 8;
    public static final int COUNT_OFFSET = 10;
    public static final int MAX_OFFSET = 12;
    public static final int BOUNDS_MIN_X_OFFSET = 16;
    public static final int BOUNDS_MAX_X_OFFSET = 24;
    public static final int BOUNDS_MIN_Y_OFFSET = 32;
    public static final int BOUNDS_MAX_Y_OFFSET = 40;
    public static final int ENTRY_LIST_OFFSET = 48;
    public static final int ENTRY_ORDINATE_SIZE = 8;
    public static final int ENTRY_KEY_SIZE = 8;
    protected long id = -1L;
    protected byte[] data;
    protected boolean dirty = false;

    public AbstractNode() {
    }

    public AbstractNode(long id, byte[] data) {
        this.id = id;
        this.data = data;
    }

    public int getIndexNodeSize(int entriesMax) {
        return 48 + entriesMax * 8 + entriesMax * 4 * 8;
    }

    public final int getByte(int offset) {
        return this.data[offset];
    }

    public final void putByte(int val, int offset) {
        this.data[offset] = (byte)val;
        this.dirty = true;
    }

    public final boolean getBoolean(int offset) {
        return this.data[offset] == 1;
    }

    public final void putBoolean(boolean val, int offset) {
        this.data[offset] = (byte)(val ? 1 : 0);
        this.dirty = true;
    }

    public final char getChar(int offset) {
        return (char)((this.data[offset] & 0xFF) << 8 | this.data[offset + 1] & 0xFF);
    }

    public final void putChar(char val, int offset) {
        this.data[offset] = (byte)(val >> 8);
        this.data[offset + 1] = (byte)val;
        this.dirty = true;
    }

    public final int getShort(int offset) {
        return (this.data[offset] & 0xFF) << 8 | this.data[offset + 1] & 0xFF;
    }

    public final void putShort(int val, int offset) {
        this.data[offset] = (byte)(val >> 8);
        this.data[offset + 1] = (byte)val;
        this.dirty = true;
    }

    public final int getInt(int offset) {
        return (this.data[offset] & 0xFF) << 24 | (this.data[offset + 1] & 0xFF) << 16 | (this.data[offset + 2] & 0xFF) << 8 | this.data[offset + 3] & 0xFF;
    }

    public final void putInt(int val, int offset) {
        this.data[offset] = (byte)(val >> 24);
        this.data[offset + 1] = (byte)(val >> 16);
        this.data[offset + 2] = (byte)(val >> 8);
        this.data[offset + 3] = (byte)val;
        this.dirty = true;
    }

    public final long getLong(int offset) {
        return ((long)this.data[offset] & 0xFFL) << 56 | ((long)this.data[offset + 1] & 0xFFL) << 48 | ((long)this.data[offset + 2] & 0xFFL) << 40 | ((long)this.data[offset + 3] & 0xFFL) << 32 | ((long)this.data[offset + 4] & 0xFFL) << 24 | ((long)this.data[offset + 5] & 0xFFL) << 16 | ((long)this.data[offset + 6] & 0xFFL) << 8 | (long)this.data[offset + 7] & 0xFFL;
    }

    public final void putLong(long val, int offset) {
        this.data[offset] = (byte)(val >> 56);
        this.data[offset + 1] = (byte)(val >> 48);
        this.data[offset + 2] = (byte)(val >> 40);
        this.data[offset + 3] = (byte)(val >> 32);
        this.data[offset + 4] = (byte)(val >> 24);
        this.data[offset + 5] = (byte)(val >> 16);
        this.data[offset + 6] = (byte)(val >> 8);
        this.data[offset + 7] = (byte)val;
        this.dirty = true;
    }

    public final double getDouble(int offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    public final void putDouble(double val, int offset) {
        this.putLong(Double.doubleToLongBits(val), offset);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractNode) {
            AbstractNode that = (AbstractNode)obj;
            return this.id == that.id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }
}

