/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.collection.AbstractFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.gs.WrappingIterator;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RasterProcess;
import org.geotools.referencing.CRS;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.util.Utilities;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

@DescribeProcess(title="Raster As Point Collection", description="Returns a collection of point features for the pixels of a raster.  The band values are provided as attributes.")
public class RasterAsPointCollectionProcess
implements RasterProcess {
    @DescribeResult(name="result", description="Point features")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input raster") GridCoverage2D gc2d) throws ProcessException {
        if (gc2d == null) {
            throw new ProcessException("Invalid input, source grid coverage should be not null");
        }
        try {
            return new RasterAsPointFeatureCollection(gc2d);
        }
        catch (IOException e) {
            throw new ProcessException("Unable to wrap provided grid coverage", e);
        }
    }

    private static final class RasterAsPointFeatureIterator
    implements SimpleFeatureIterator {
        private final double[] temp;
        private final SimpleFeatureBuilder fb;
        private final RasterAsPointFeatureCollection fc;
        private int index = 0;
        private final int size;
        private final RectIter iterator;
        private final Coordinate coord = new Coordinate();

        public RasterAsPointFeatureIterator(RasterAsPointFeatureCollection fc) {
            Utilities.ensureNonNull((String)"fc", (Object)fc);
            this.fc = fc;
            this.fb = new SimpleFeatureBuilder(fc.getSchema());
            this.size = fc.size;
            this.iterator = RectIterFactory.create((RenderedImage)fc.gc2d.getRenderedImage(), null);
            this.iterator.startLines();
            if (this.iterator.finishedLines()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            this.iterator.startPixels();
            if (this.iterator.finishedPixels()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            this.temp = new double[fc.numBands];
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            if (this.iterator.finishedPixels()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            if (this.iterator.finishedLines()) {
                throw new NoSuchElementException("Index beyond size:" + this.index + ">" + this.size);
            }
            int id = this.index;
            this.coord.x = 0.5 + (double)this.fc.rasterBounds.x + (double)(this.index % this.fc.rasterBounds.width);
            this.coord.y = 0.5 + (double)this.fc.rasterBounds.y + (double)(this.index / this.fc.rasterBounds.width);
            Point point = RasterAsPointFeatureCollection.geometryFactory.createPoint(this.coord);
            try {
                this.fb.add((Object)JTS.transform(point, (MathTransform)this.fc.mt2D));
            }
            catch (MismatchedDimensionException e) {
                NoSuchElementException nse = new NoSuchElementException();
                nse.initCause(e);
                throw nse;
            }
            catch (TransformException e) {
                NoSuchElementException nse = new NoSuchElementException();
                nse.initCause(e);
                throw nse;
            }
            this.iterator.getPixel(this.temp);
            for (double d : this.temp) {
                this.fb.add((Object)d);
            }
            if (this.iterator.nextPixelDone() && !this.iterator.nextLineDone()) {
                this.iterator.startPixels();
            }
            SimpleFeature returnValue = this.fb.buildFeature(String.valueOf(id));
            ++this.index;
            return returnValue;
        }
    }

    private static final class RasterAsPointFeatureCollection
    extends AbstractFeatureCollection
    implements SimpleFeatureCollection {
        static final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory((Hints)GeoTools.getDefaultHints());
        final GridCoverage2D gc2d;
        final int size;
        final MathTransform2D mt2D;
        private ReferencedEnvelope bounds;
        final Rectangle rasterBounds;
        final int numBands;

        public RasterAsPointFeatureCollection(GridCoverage2D gc2d) throws IOException {
            super(CoverageUtilities.createFeatureType(gc2d, Point.class));
            this.gc2d = gc2d;
            RenderedImage raster = gc2d.getRenderedImage();
            this.size = raster.getWidth() * raster.getHeight();
            this.mt2D = gc2d.getGridGeometry().getGridToCRS2D(PixelOrientation.UPPER_LEFT);
            this.rasterBounds = PlanarImage.wrapRenderedImage((RenderedImage)raster).getBounds();
            XRectangle2D rasterBounds_ = new XRectangle2D((double)raster.getMinX() + 0.5, (double)raster.getMinY() + 0.5, (double)(raster.getWidth() - 1), (double)(raster.getHeight() - 1));
            try {
                this.bounds = new ReferencedEnvelope(CRS.transform((MathTransform2D)this.mt2D, (Rectangle2D)rasterBounds_, null), gc2d.getCoordinateReferenceSystem2D());
            }
            catch (MismatchedDimensionException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            catch (TransformException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            this.numBands = gc2d.getNumSampleDimensions();
        }

        @Override
        public SimpleFeatureIterator features() {
            return new RasterAsPointFeatureIterator(this);
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public ReferencedEnvelope getBounds() {
            return new ReferencedEnvelope(this.bounds);
        }

        protected Iterator<SimpleFeature> openIterator() {
            return new WrappingIterator(this.features());
        }

        protected void closeIterator(Iterator<SimpleFeature> close) {
            if (close instanceof WrappingIterator) {
                ((WrappingIterator)close).close();
            }
        }
    }
}

