/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.BaseCoverageAlgebraProcess;
import org.geotools.process.raster.RasterProcess;
import org.opengis.coverage.processing.Operation;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Multiply Coverages", description="Returns a raster generated by pixel-by-pixel multiplication of two source rasters.  Source rasters must have the same bounding box and resolution.")
public class MultiplyCoveragesProcess
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final Operation MULTIPLY = PROCESSOR.getOperation("Multiply");

    @DescribeResult(name="result", description="Computed raster")
    public GridCoverage2D execute(@DescribeParameter(name="coverageA", description="First input raster") GridCoverage2D coverageA, @DescribeParameter(name="coverageB", description="Second input raster") GridCoverage2D coverageB, ProgressListener progressListener) throws ProcessException {
        BaseCoverageAlgebraProcess.checkCompatibleCoverages(coverageA, coverageB);
        ParameterValueGroup param = MULTIPLY.getParameters();
        param.parameter("Source0").setValue((Object)coverageA);
        param.parameter("Source1").setValue((Object)coverageB);
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }
}

