/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

@DescribeProcess(title="Area Grid", description="Computes a raster grid of given geographic extent with cell values equal to the area the cell represents on the surface of the earth.  Area is computed using the EckertIV projection.")
public class AreaGridProcess
implements RasterProcess {
    private static final String targetCRSWKT = "PROJCS[\"World_Eckert_IV\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Eckert_IV\"],PARAMETER[\"Central_Meridian\",0.0],UNIT[\"Meter\",1.0]]";

    @DescribeResult(name="result", description="Output raster")
    public GridCoverage2D execute(@DescribeParameter(name="envelope", description="Bounding box for the computed raster, in WGS84 geographic coordinates.") ReferencedEnvelope bounds, @DescribeParameter(name="width", description="Width of the output raster in pixels") int width, @DescribeParameter(name="height", description="Height of the output raster in pixels") int height) throws ProcessException {
        if (height <= 0 || width <= 0) {
            throw new ProcessException("height and width parameters must be greater than 0");
        }
        if (bounds.getCoordinateReferenceSystem() == null) {
            throw new ProcessException("Envelope CRS must not be null");
        }
        GeometryFactory geomFactory = new GeometryFactory();
        try {
            Geometry polygon = null;
            DefaultGeographicCRS sourceCRS = DefaultGeographicCRS.WGS84;
            CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)targetCRSWKT);
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
            double pX = bounds.getMinX();
            double pY = bounds.getMaxY();
            double stepX = (bounds.getMaxX() - bounds.getMinX()) / (double)width;
            double stepY = (bounds.getMaxY() - bounds.getMinY()) / (double)height;
            float[][] matrix = new float[height][width];
            Coordinate[] tempCoordinates = new Coordinate[5];
            for (int i = 0; i < height; ++i) {
                pX = bounds.getMinX();
                for (int j = 0; j < width; ++j) {
                    double nX = pX + stepX;
                    double nY = pY - stepY;
                    if (polygon == null) {
                        tempCoordinates[0] = new Coordinate(pX, pY);
                        tempCoordinates[1] = new Coordinate(nX, pY);
                        tempCoordinates[2] = new Coordinate(nX, nY);
                        tempCoordinates[3] = new Coordinate(pX, nY);
                        tempCoordinates[4] = tempCoordinates[0];
                        LinearRing linearRing = geomFactory.createLinearRing(tempCoordinates);
                        polygon = geomFactory.createPolygon(linearRing, null);
                    } else {
                        tempCoordinates[0].x = pX;
                        tempCoordinates[0].y = pY;
                        tempCoordinates[1].x = nX;
                        tempCoordinates[1].y = pY;
                        tempCoordinates[2].x = nX;
                        tempCoordinates[2].y = nY;
                        tempCoordinates[3].x = pX;
                        tempCoordinates[3].y = nY;
                        polygon.geometryChanged();
                    }
                    Geometry targetGeometry = JTS.transform(polygon, transform);
                    matrix[i][j] = (float)targetGeometry.getArea();
                    pX += stepX;
                }
                pY -= stepY;
            }
            GridCoverageFactory coverageFactory = new GridCoverageFactory();
            GridCoverage2D grid = coverageFactory.create((CharSequence)"AreaGridCoverage", matrix, (Envelope)bounds);
            return grid;
        }
        catch (FactoryException ef) {
            throw new ProcessException("Unable to create the target CRS", ef);
        }
        catch (TransformException et) {
            throw new ProcessException("Unable to tranform the coordinate system", et);
        }
    }
}

