/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.wps.response;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.ows11.ExceptionReportType;
import net.opengis.wps10.ExecuteResponseType;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.ows.ServiceException;
import org.geotools.wps.WPSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.xml.sax.SAXException;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParserException;

public class ExecuteProcessResponse
extends Response {
    private ExecuteResponseType exeResponse;
    private ExceptionReportType excepResponse;
    private InputStream rawResponseStream;
    private String rawContentType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecuteProcessResponse(HTTPResponse httpResponse, boolean raw) throws IOException, ServiceException {
        block10: {
            super(httpResponse);
            InputStream inputStream = null;
            try {
                block11: {
                    if (!raw) {
                        inputStream = httpResponse.getResponseStream();
                        this.parseDocumentResponse(inputStream);
                        break block10;
                    }
                    this.rawContentType = httpResponse.getContentType();
                    if (this.rawContentType.matches(".*/xml.*")) {
                        inputStream = new BufferedInputStream(httpResponse.getResponseStream());
                        inputStream.mark(8192);
                        try {
                            MXParser parser = new MXParser();
                            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
                            parser.setInput(inputStream, "UTF-8");
                            parser.nextTag();
                            String name = parser.getName();
                            inputStream.reset();
                            if ("ServiceException".equals(name) || "ExceptionReport".equals(name) || "ExecuteResponse".equals(name)) {
                                this.parseDocumentResponse(inputStream);
                                return;
                            }
                            break block11;
                        }
                        catch (XmlPullParserException e) {
                            throw new IOException("Failed to parse the response", e);
                        }
                    }
                    inputStream = httpResponse.getResponseStream();
                }
                this.rawResponseStream = inputStream;
                inputStream = null;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    private void parseDocumentResponse(InputStream inputStream) throws IOException {
        Object object;
        WPSConfiguration config = new WPSConfiguration();
        Parser parser = new Parser((Configuration)config);
        this.excepResponse = null;
        this.exeResponse = null;
        try {
            object = parser.parse(inputStream);
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
        if (object instanceof ExecuteResponseType) {
            this.exeResponse = (ExecuteResponseType)object;
            if (this.exeResponse.getStatus() != null && this.exeResponse.getStatus().getProcessFailed() != null) {
                this.excepResponse = this.exeResponse.getStatus().getProcessFailed().getExceptionReport();
            }
        } else if (object instanceof ExceptionReportType) {
            this.excepResponse = (ExceptionReportType)object;
        }
    }

    public ExecuteResponseType getExecuteResponse() {
        return this.exeResponse;
    }

    public ExceptionReportType getExceptionResponse() {
        return this.excepResponse;
    }

    public InputStream getRawResponseStream() {
        return this.rawResponseStream;
    }

    public String getRawContentType() {
        return this.rawContentType;
    }
}

