/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.wps10.WPSCapabilitiesType;
import org.geotools.data.ResourceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.data.ows.AbstractWPSGetCapabilitiesResponse;
import org.geotools.data.ows.Capabilities;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Request;
import org.geotools.data.ows.Response;
import org.geotools.data.ows.SimpleHttpClient;
import org.geotools.data.ows.Specification;
import org.geotools.ows.ServiceException;
import org.geotools.util.logging.Logging;

public abstract class AbstractWPS<C extends WPSCapabilitiesType, R> {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.data.ows");
    protected HTTPClient httpClient;
    protected final URL serverURL;
    protected C capabilities;
    protected ServiceInfo info;
    protected Map<R, ResourceInfo> resourceInfo = new HashMap<R, ResourceInfo>();
    protected Specification[] specs;
    protected Specification specification;

    public AbstractWPS(URL serverURL) throws IOException, ServiceException {
        this(serverURL, (HTTPClient)new SimpleHttpClient(), null);
        this.capabilities = this.negotiateVersion();
        if (this.capabilities == null) {
            throw new ServiceException("Unable to retrieve or parse Capabilities document.");
        }
        if (this.capabilities != null) {
            super.setupSpecification(this.capabilities);
        }
    }

    public AbstractWPS(URL serverURL, int requestTimeout) throws ServiceException, IOException {
        this(serverURL, (HTTPClient)new SimpleHttpClient(), null);
        this.httpClient.setConnectTimeout(requestTimeout);
        this.httpClient.setReadTimeout(requestTimeout);
    }

    public AbstractWPS(C capabilties, URL serverURL) throws ServiceException, IOException {
        this(serverURL, (HTTPClient)new SimpleHttpClient(), capabilties);
    }

    public AbstractWPS(URL serverURL, HTTPClient httpClient, C capabilities) throws ServiceException, IOException {
        if (serverURL == null) {
            throw new NullPointerException("serverURL");
        }
        if (httpClient == null) {
            throw new NullPointerException("httpClient");
        }
        this.serverURL = serverURL;
        this.httpClient = httpClient;
        this.setupSpecifications();
        if (capabilities != null) {
            this.setupSpecification(capabilities);
            this.capabilities = capabilities;
        } else {
            this.capabilities = this.negotiateVersion();
            if (this.capabilities == null) {
                throw new ServiceException("Unable to retrieve or parse Capabilities document.");
            }
            this.setupSpecification(this.capabilities);
        }
    }

    private void setupSpecification(C capabilities) {
        for (int i = 0; i < this.specs.length; ++i) {
            if (!this.specs[i].getVersion().equals(capabilities.getVersion())) continue;
            this.specification = this.specs[i];
            break;
        }
        if (this.specification == null) {
            this.specification = this.specs[this.specs.length - 1];
            LOGGER.warning("Unable to choose a specification based on cached capabilities. Arbitrarily choosing spec '" + this.specification.getVersion() + "'.");
        }
    }

    public void setHttpClient(HTTPClient httpClient) {
        this.httpClient = httpClient;
    }

    public HTTPClient getHTTPClient() {
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo getInfo() {
        C c = this.capabilities;
        synchronized (c) {
            if (this.info == null) {
                this.info = this.createInfo();
            }
            return this.info;
        }
    }

    protected abstract ServiceInfo createInfo();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceInfo getInfo(R resource) {
        C c = this.capabilities;
        synchronized (c) {
            if (!this.resourceInfo.containsKey(resource)) {
                this.resourceInfo.put(resource, this.createInfo(resource));
            }
        }
        return this.resourceInfo.get(resource);
    }

    protected abstract ResourceInfo createInfo(R var1);

    private void syncrhonized(Capabilities capabilities2) {
    }

    protected abstract void setupSpecifications();

    protected C negotiateVersion() throws IOException, ServiceException {
        int maxClient;
        ArrayList<String> versions = new ArrayList<String>(this.specs.length);
        Throwable exception = null;
        for (int i = 0; i < this.specs.length; ++i) {
            versions.add(i, this.specs[i].getVersion());
        }
        int minClient = 0;
        int test = maxClient = this.specs.length - 1;
        while (minClient <= test && test <= maxClient) {
            WPSCapabilitiesType tempCapabilities;
            Specification tempSpecification = this.specs[test];
            String clientVersion = tempSpecification.getVersion();
            GetCapabilitiesRequest request = tempSpecification.createGetCapabilitiesRequest(this.serverURL);
            try {
                tempCapabilities = this.issueRequest(request).getCapabilities();
            }
            catch (ServiceException e) {
                tempCapabilities = null;
                exception = e;
            }
            int compare = -1;
            String serverVersion = clientVersion;
            if (tempCapabilities != null) {
                serverVersion = tempCapabilities.getVersion();
                compare = serverVersion.compareTo(clientVersion);
            }
            if (compare == 0) {
                this.specification = tempSpecification;
                return (C)tempCapabilities;
            }
            if (tempCapabilities != null && versions.contains(serverVersion)) {
                int index = versions.indexOf(serverVersion);
                this.specification = this.specs[index];
                return (C)tempCapabilities;
            }
            if (compare < 0) {
                maxClient = test - 1;
                clientVersion = this.before(versions, serverVersion);
                if (clientVersion == null) {
                    if (exception != null) {
                        if (exception instanceof ServiceException) {
                            throw (ServiceException)exception;
                        }
                        IOException e = new IOException(exception.getMessage());
                        throw e;
                    }
                    return null;
                }
                test = versions.indexOf(clientVersion);
                continue;
            }
            minClient = test + 1;
            clientVersion = this.after(versions, serverVersion);
            if (clientVersion == null) {
                if (exception != null) {
                    if (exception instanceof ServiceException) {
                        throw (ServiceException)exception;
                    }
                    IOException e = new IOException(exception.getMessage());
                    throw e;
                }
                return null;
            }
            test = versions.indexOf(clientVersion);
        }
        if (exception != null) {
            IOException e = new IOException(exception.getMessage());
            throw e;
        }
        return null;
    }

    String before(List known, String version) {
        if (known.isEmpty()) {
            return null;
        }
        String before = null;
        for (String test : known) {
            if (test.compareTo(version) >= 0 || before != null && before.compareTo(test) >= 0) continue;
            before = test;
        }
        return before;
    }

    String after(List known, String version) {
        if (known.isEmpty()) {
            return null;
        }
        String after = null;
        for (String test : known) {
            if (test.compareTo(version) <= 0 || after != null && after.compareTo(test) >= 0) continue;
            after = test;
        }
        return after;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response internalIssueRequest(Request request) throws IOException, ServiceException {
        HTTPResponse httpResponse;
        URL finalURL = request.getFinalURL();
        if (request.requiresPost()) {
            String postContentType = request.getPostContentType();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            request.performPostOutput((OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            try {
                httpResponse = this.httpClient.post(finalURL, (InputStream)in, postContentType);
            }
            finally {
                ((InputStream)in).close();
            }
        } else {
            httpResponse = this.httpClient.get(finalURL);
        }
        Response response = request.createResponse(httpResponse);
        return response;
    }

    public AbstractWPSGetCapabilitiesResponse issueRequest(GetCapabilitiesRequest request) throws IOException, ServiceException {
        return (AbstractWPSGetCapabilitiesResponse)this.internalIssueRequest((Request)request);
    }

    public void setLoggingLevel(Level newLevel) {
        LOGGER.setLevel(newLevel);
    }
}

