/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.spatial;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class PolygonNoGapsValidation
extends DefaultFeatureValidation {
    @Override
    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        if (feature != null) {
            Geometry layer = (Geometry)feature.getDefaultGeometry();
            if (layer instanceof Polygon) {
                Polygon p = (Polygon)layer;
                if (p.getNumInteriorRing() != 0) {
                    results.error(feature, "The generated result was had gaps.");
                    return false;
                }
                return true;
            }
            results.error(feature, "The generated result was not of type polygon.");
            return false;
        }
        return true;
    }
}

