/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.network;

import java.util.Map;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.graph.build.line.LineStringGraphGenerator;
import org.geotools.graph.structure.Graph;
import org.geotools.validation.DefaultIntegrityValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;

public class OrphanNodeValidation
extends DefaultIntegrityValidation {
    private String typeName;

    @Override
    public String[] getTypeRefs() {
        return new String[]{this.typeName};
    }

    @Override
    public boolean validate(Map layers, ReferencedEnvelope envelope, ValidationResults results) throws Exception {
        SimpleFeatureCollection fr;
        LineStringGraphGenerator lgb = new LineStringGraphGenerator();
        SimpleFeatureSource fs = (SimpleFeatureSource)layers.get(this.typeName);
        SimpleFeatureCollection fc = fr = fs.getFeatures();
        SimpleFeatureIterator f = fc.features();
        while (f.hasNext()) {
            SimpleFeature ft = (SimpleFeature)f.next();
            if (!envelope.contains(ft.getBounds())) continue;
            lgb.add(ft.getDefaultGeometry());
        }
        Graph g = lgb.getGraph();
        return g.getNodesOfDegree(0).size() == 0;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

