/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.attributes;

import org.geotools.validation.DefaultFeatureValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class AttributeValidation
extends DefaultFeatureValidation {
    public static final int LESS_THAN = -1;
    public static final int EQUALITY = 0;
    public static final int GREATER_THAN = 1;
    private String attributeComparisonValue;
    private String attributeName;
    private int attributeComparisonType;

    @Override
    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        int surface = (Integer)feature.getAttribute("surface");
        int speed = (Integer)feature.getAttribute("speed");
        if (surface == 1 && speed > 110) {
            results.error(feature, "speed over 110");
            return false;
        }
        if (surface == 2 && speed > 110) {
            results.error(feature, "speed over 70");
            return false;
        }
        return true;
    }

    public int getAttributeComparisonType() {
        return this.attributeComparisonType;
    }

    public void setAttributeComparisonType(int attributeComparisonType) {
        this.attributeComparisonType = attributeComparisonType;
    }

    public String getAttributeComparisonValue() {
        return this.attributeComparisonValue;
    }

    public void setAttributeComparisonValue(String attributeComparisonValue) {
        this.attributeComparisonValue = attributeComparisonValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }
}

