/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.trim.internal;

import com.vividsolutions.jts.geom.LineString;
import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.ui.util.DialogUtil;
import eu.udig.tools.internal.ui.util.LayerUtil;
import eu.udig.tools.trim.internal.TrimFeaturesCommand;
import java.io.IOException;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.support.GeometryCreationUtil;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class TrimGeometryBehaviour
implements Behaviour {
    public boolean isValid(EditToolHandler handler) {
        PrimitiveShape currentShape = handler.getCurrentShape();
        if (currentShape == null) {
            return false;
        }
        int nCoords = currentShape.getNumCoords();
        return nCoords > 1;
    }

    public UndoableMapCommand getCommand(EditToolHandler handler) {
        FeatureCollection<SimpleFeatureType, SimpleFeature> featuresToTrim;
        LineString trimmingLineInLayerCrs;
        ILayer selectedLayer = handler.getContext().getSelectedLayer();
        try {
            trimmingLineInLayerCrs = this.getTrimmingLineInLayerCrs(handler);
        }
        catch (OperationNotFoundException e) {
            throw (RuntimeException)new RuntimeException("Cannot reproject trim line from layer's crs to map's crs").initCause(e);
        }
        catch (TransformException e) {
            throw (RuntimeException)new RuntimeException("Cannot reproject trim line from layer's crs to map's crs").initCause(e);
        }
        try {
            featuresToTrim = this.getFeaturesToTrim(selectedLayer, trimmingLineInLayerCrs);
        }
        catch (OperationNotFoundException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        catch (TransformException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        if (featuresToTrim.size() == 0) {
            DialogUtil.openInformation(Messages.TrimFeaturesCommand_no_features_modified, Messages.TrimFeaturesCommand_did_not_apply_to_any_feature);
            return null;
        }
        TrimFeaturesCommand trimCommand = new TrimFeaturesCommand(handler, selectedLayer, featuresToTrim, trimmingLineInLayerCrs);
        return trimCommand;
    }

    private FeatureCollection<SimpleFeatureType, SimpleFeature> getFeaturesToTrim(ILayer selectedLayer, LineString trimmingLine) throws IOException, OperationNotFoundException, TransformException {
        Filter extraFilter = this.createTrimmingLineFilter(selectedLayer, trimmingLine);
        FeatureCollection<SimpleFeatureType, SimpleFeature> selection = LayerUtil.getSelectedFeatures(selectedLayer, extraFilter);
        return selection;
    }

    private LineString getTrimmingLineInLayerCrs(EditToolHandler handler) throws OperationNotFoundException, TransformException {
        PrimitiveShape currentShape = handler.getCurrentShape();
        LineString line = (LineString)GeometryCreationUtil.createGeom(LineString.class, (PrimitiveShape)currentShape, (boolean)false);
        return line;
    }

    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        DialogUtil.openError(Messages.TrimGeometryBehaviour_operation_failed, error.getMessage());
    }

    private Filter createTrimmingLineFilter(ILayer selectedLayer, LineString trimmingLineInLayerCrs) throws OperationNotFoundException, TransformException {
        Intersects intersectsFilter;
        Object filter = selectedLayer.getFilter();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        try {
            SimpleFeatureType schema = selectedLayer.getSchema();
            String typeName = schema.getGeometryDescriptor().getLocalName();
            intersectsFilter = ff.intersects((Expression)ff.property(typeName), (Expression)ff.literal((Object)trimmingLineInLayerCrs));
        }
        catch (IllegalFilterException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        filter = Filter.EXCLUDE.equals(filter) ? intersectsFilter : ff.and(filter, (Filter)intersectsFilter);
        return filter;
    }
}

