/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.split;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.ui.util.StatusBar;
import eu.udig.tools.split.AddSplitVertexBehaviour;
import eu.udig.tools.split.SplitGeometryBehaviour;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.AbstractEditTool;
import net.refractions.udig.tools.edit.Activator;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditToolConfigurationHelper;
import net.refractions.udig.tools.edit.EnablementBehaviour;
import net.refractions.udig.tools.edit.EventBehaviour;
import net.refractions.udig.tools.edit.activator.DrawCurrentGeomVerticesActivator;
import net.refractions.udig.tools.edit.activator.DrawGeomsActivator;
import net.refractions.udig.tools.edit.activator.EditStateListenerActivator;
import net.refractions.udig.tools.edit.activator.ResetAllStateActivator;
import net.refractions.udig.tools.edit.activator.SetSnapBehaviourCommandHandlerActivator;
import net.refractions.udig.tools.edit.behaviour.AcceptOnDoubleClickBehaviour;
import net.refractions.udig.tools.edit.behaviour.DefaultCancelBehaviour;
import net.refractions.udig.tools.edit.behaviour.DrawCreateVertexSnapAreaBehaviour;
import net.refractions.udig.tools.edit.behaviour.RefreshLayersBehaviour;
import net.refractions.udig.tools.edit.behaviour.SetSnapSizeBehaviour;
import net.refractions.udig.tools.edit.behaviour.StartEditingBehaviour;
import net.refractions.udig.tools.edit.enablement.ValidToolDetectionActivator;
import net.refractions.udig.tools.edit.support.ShapeType;

public class SplitTool
extends AbstractEditTool {
    private static final String EXTENSION_ID = "eu.udig.tools.split.SplitTool";

    public void setActive(boolean active) {
        super.setActive(active);
        IToolContext context = this.getContext();
        if (active && context.getMapLayers().size() > 0) {
            String message = Messages.SplitTool_draw_line_to_split;
            StatusBar.setStatusBarMessage(context, message);
        } else {
            StatusBar.setStatusBarMessage(context, "");
        }
    }

    protected void initActivators(Set<Activator> activators) {
        activators.add((Activator)new EditStateListenerActivator());
        activators.add((Activator)new DrawGeomsActivator(DrawGeomsActivator.DrawType.LINE));
        activators.add((Activator)new DrawCurrentGeomVerticesActivator());
        activators.add((Activator)new ResetAllStateActivator());
        activators.add((Activator)new SetSnapBehaviourCommandHandlerActivator());
    }

    protected void initAcceptBehaviours(List<Behaviour> acceptBehaviours) {
        acceptBehaviours.add(new SplitGeometryBehaviour());
        acceptBehaviours.add((Behaviour)new RefreshLayersBehaviour());
    }

    protected void initCancelBehaviours(List<Behaviour> cancelBehaviours) {
        cancelBehaviours.add((Behaviour)new DefaultCancelBehaviour());
    }

    protected void initEventBehaviours(EditToolConfigurationHelper helper) {
        helper.add((EventBehaviour)new DrawCreateVertexSnapAreaBehaviour());
        helper.startMutualExclusiveList();
        helper.add((EventBehaviour)new AddSplitVertexBehaviour());
        helper.add((EventBehaviour)new StartEditingBehaviour(ShapeType.LINE));
        helper.stopMutualExclusiveList();
        helper.add((EventBehaviour)new SetSnapSizeBehaviour());
        helper.add((EventBehaviour)new AcceptOnDoubleClickBehaviour());
        helper.done();
    }

    protected void initEnablementBehaviours(List<EnablementBehaviour> enablementBehaviours) {
        enablementBehaviours.add((EnablementBehaviour)new ValidToolDetectionActivator(new Class[]{LineString.class, MultiLineString.class, MultiPolygon.class, Polygon.class}));
    }
}

