/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.split;

import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.ui.util.DialogUtil;
import eu.udig.tools.split.SplitFeaturesCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.tools.edit.Behaviour;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.SetEditStateCommand;
import net.refractions.udig.tools.edit.support.PrimitiveShape;

class SplitGeometryBehaviour
implements Behaviour {
    public boolean isValid(EditToolHandler handler) {
        PrimitiveShape currentShape = handler.getCurrentShape();
        if (currentShape == null) {
            return false;
        }
        int nCoords = currentShape.getNumCoords();
        return nCoords > 1;
    }

    public UndoableMapCommand getCommand(EditToolHandler handler) {
        assert (handler != null);
        UndoableComposite commands = new UndoableComposite();
        commands.addCommand((MapCommand)new SetEditStateCommand(handler, EditState.BUSY));
        commands.addCommand((MapCommand)new SplitFeaturesCommand(handler));
        commands.addCommand((MapCommand)new SetEditStateCommand(handler, EditState.NONE));
        return commands;
    }

    public void handleError(EditToolHandler handler, Throwable error, UndoableMapCommand command) {
        assert (error != null);
        String message = error.getMessage();
        DialogUtil.openError(Messages.SplitGeometryBehaviour_transaction_failed, message);
        handler.setCurrentState(EditState.NONE);
        handler.setCurrentShape(null);
        handler.getEditBlackboard(handler.getEditLayer()).clear();
    }
}

