/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.view;

import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.parallel.internal.ParallelContext;
import eu.udig.tools.parallel.internal.PrecisionToolsMode;
import eu.udig.tools.parallel.view.ParallelParametersComposite;
import java.util.Observable;
import java.util.Observer;
import net.refractions.udig.project.ui.IUDIGView;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.opengis.feature.simple.SimpleFeature;

public class ParallelParametersView
extends ViewPart
implements IUDIGView,
Observer {
    private ParallelContext parallelContext = null;
    private ParallelParametersComposite parametersComposite = null;
    private IToolContext context = null;
    public static final String id = "eu.udig.tools.parallel.view.ParallelParametersView";
    private cancelButtonAction cancelButton = null;
    private acceptButtonAction acceptButton = null;

    public void setParallelContext(ParallelContext context) {
        assert (context != null);
        this.parallelContext = context;
        this.parametersComposite.setToolContext(this.parallelContext);
        this.parallelContext.addObserver(this);
    }

    public void createPartControl(Composite parent) {
        this.parametersComposite = new ParallelParametersComposite(parent, 0);
        this.createActions();
        this.createToolbar();
    }

    private void createToolbar() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.acceptButton);
        toolbar.add((IAction)this.cancelButton);
    }

    private void createActions() {
        this.acceptButton = new acceptButtonAction();
        this.cancelButton = new cancelButtonAction();
        this.enableAcceptButton(false);
    }

    public void setFocus() {
    }

    public void editFeatureChanged(SimpleFeature feature) {
    }

    public IToolContext getContext() {
        return this.context;
    }

    public void setContext(IToolContext newContext) {
        this.context = newContext;
        this.parametersComposite.setContext(newContext);
    }

    public void enableAcceptButton(boolean enable) {
        if (this.acceptButton != null) {
            this.acceptButton.setEnabled(enable);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        boolean enable = this.parallelContext.getMode() == PrecisionToolsMode.READY;
        this.enableAcceptButton(enable);
    }

    private class acceptButtonAction
    extends Action {
        public acceptButtonAction() {
            this.setToolTipText(Messages.PrecisionTool_ok_tooltip_text);
            String imgFile = "images/apply_co.gif";
            this.setImageDescriptor(ImageDescriptor.createFromFile(ParallelParametersView.class, (String)imgFile));
        }

        public void run() {
            ParallelParametersView.this.parametersComposite.acceptChanges();
        }
    }

    private class cancelButtonAction
    extends Action {
        public cancelButtonAction() {
            this.setToolTipText(Messages.PrecisionTool_cancel_tooltip_text);
            String imgFile = "images/reset_co.gif";
            this.setImageDescriptor(ImageDescriptor.createFromFile(ParallelParametersView.class, (String)imgFile));
        }

        public void run() {
            ParallelParametersView.this.parametersComposite.discardChanges();
        }
    }
}

