/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.view;

import eu.udig.tools.feature.util.UnitList;
import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.parallel.internal.InfoMessage;
import eu.udig.tools.parallel.internal.PrecisionToolsContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import javax.measure.unit.Unit;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.BehaviourCommand;
import net.refractions.udig.tools.edit.EditToolHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractParametersComposite
extends Composite
implements Observer {
    protected Thread fatherThread = null;
    protected PrecisionToolsContext toolContext = null;
    protected IEditManagerListener editManagerListener = null;
    protected IToolContext context = null;
    protected CLabel messageImage = null;
    protected CLabel messageText = null;
    protected Composite compositeLegend = null;
    protected Composite compositeOperations = null;
    protected ViewForm viewForm = null;
    protected CLabel labelReferenceLine = null;
    protected String referenceLine = "";
    protected String referenceLineToolTip = "";
    private Set<Map.Entry<String, Unit<?>>> unitset;
    private boolean loadComplete = false;

    public AbstractParametersComposite(Composite parent, int style) {
        super(parent, style);
        this.init();
        this.setVisible(false);
    }

    private void init() {
        this.fatherThread = Thread.currentThread();
        this.initListener();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 3;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.verticalAlignment = 1;
        this.viewForm = new ViewForm((Composite)this, 0);
        this.viewForm.setLayout((Layout)gridLayout);
        this.viewForm.setLayoutData((Object)gridData2);
        this.createCompositeLegend((Composite)this.viewForm);
        this.viewForm.setTopLeft((Control)this.compositeLegend);
        this.createCompositeOperations((Composite)this.viewForm);
        this.viewForm.setContent((Control)this.compositeOperations);
        this.initializeUnitSet();
    }

    private void initializeUnitSet() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Set<Unit<?>> commonLengthUnits = UnitList.getInstance().getCommonLengthUnits();
                    TreeMap units = new TreeMap();
                    for (Unit<?> unit : commonLengthUnits) {
                        units.put(UnitList.getInstance().getUnitName(unit), unit);
                    }
                    AbstractParametersComposite.this.unitset = units.entrySet();
                    AbstractParametersComposite.this.loadComplete = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected String getUnitName(Unit<?> mapUnits) {
        String shorUnitName = "";
        if (this.loadComplete) {
            for (Map.Entry<String, Unit<?>> entry : this.unitset) {
                if (!entry.getValue().equals(mapUnits)) continue;
                shorUnitName = entry.getKey();
            }
        }
        return shorUnitName;
    }

    private void createCompositeOperations(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 4;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.verticalAlignment = 4;
        this.compositeOperations = new Composite(parent, 0);
        this.compositeOperations.setLayout((Layout)gridLayout);
        this.compositeOperations.setLayoutData((Object)gridData2);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 4;
        gridData.verticalAlignment = 4;
        this.labelReferenceLine = new CLabel(this.compositeOperations, 0);
        this.labelReferenceLine.setLayoutData((Object)gridData);
        this.labelReferenceLine.setText(String.valueOf(Messages.PrecisionTool_reference_line) + ":" + this.referenceLine);
        this.labelReferenceLine.setToolTipText(Messages.PrecisionTool_reference_line);
    }

    private void createCompositeLegend(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 3;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.verticalAlignment = 1;
        this.compositeLegend = new Composite(parent, 0);
        this.compositeLegend.setLayout((Layout)gridLayout);
        this.compositeLegend.setLayoutData((Object)gridData2);
        this.messageImage = new CLabel(this.compositeLegend, 0);
        GridData gridData7 = new GridData();
        gridData7.horizontalAlignment = 1;
        gridData7.minimumWidth = 30;
        gridData7.widthHint = 30;
        this.messageImage.setLayoutData((Object)gridData7);
        this.messageText = new CLabel(this.compositeLegend, 0);
        GridData gridData8 = new GridData();
        gridData8.horizontalAlignment = 4;
        gridData8.grabExcessHorizontalSpace = true;
        gridData8.grabExcessVerticalSpace = true;
        gridData8.verticalAlignment = 4;
        this.messageText.setLayoutData((Object)gridData8);
        this.messageText.setFont(JFaceResources.getDialogFont());
        InfoMessage infoMessage = new InfoMessage(Messages.PrecisionParallel_InitialMessage, InfoMessage.Type.INFORMATION);
        this.messageImage.setImage(infoMessage.getImage());
        this.messageText.setText(infoMessage.getText());
    }

    protected void addEmptyLabel(Composite parent) {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = false;
        gridData1.verticalAlignment = 1;
        CLabel lbl = new CLabel((Composite)this, 0);
        lbl.setLayoutData((Object)gridData1);
        lbl.setText("");
    }

    public void setToolContext(PrecisionToolsContext toolContext) {
        assert (toolContext != null) : "Can not be null";
        this.toolContext = toolContext;
        this.toolContext.addObserver(this);
        this.setVisible(true);
        this.setCustomToolContext();
    }

    protected abstract void setCustomToolContext();

    protected void createContent() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 1;
        Composite composite = new Composite(this.compositeOperations, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
    }

    protected void applyChanges() {
    }

    public void discardChanges() {
    }

    public void acceptChanges() {
        if (this.toolContext == null) {
            return;
        }
        EditToolHandler handler = this.toolContext.getHandler();
        ArrayList<BehaviourCommand> commands = new ArrayList<BehaviourCommand>();
        commands.add(handler.getCommand(handler.getAcceptBehaviours()));
        UndoableComposite undoableComposite = new UndoableComposite(commands);
        undoableComposite.setMap(handler.getContext().getMap());
        handler.getContext().sendASyncCommand((Command)undoableComposite);
        handler.getContext().getViewportPane().repaint();
    }

    protected abstract void displayMessage(InfoMessage.Type var1);

    protected abstract void clearData();

    protected abstract void populate();

    @Override
    public abstract void update(Observable var1, Object var2);

    private void initListener() {
        this.editManagerListener = new IEditManagerListener(){

            public void changed(EditManagerEvent event) {
                AbstractParametersComposite.this.updateEditManagerAction(event);
            }
        };
    }

    private void updateEditManagerAction(EditManagerEvent event) {
        int eventType = event.getType();
        switch (eventType) {
            case -4: 
            case -1: {
                this.clearData();
                break;
            }
        }
    }

    public void setContext(IToolContext context) {
        if (context == null) {
            IEditManager editManager = this.getCurrentEditManager();
            if (editManager != null) {
                this.removeListenerFrom(editManager);
            }
        } else {
            IEditManager editManager = context.getEditManager();
            if (editManager != null) {
                this.addListenersTo(editManager);
            }
        }
        this.context = context;
    }

    private void removeListenerFrom(IEditManager editManager) {
        assert (editManager != null);
        assert (this.editManagerListener != null);
        editManager.removeListener(this.editManagerListener);
    }

    private IEditManager getCurrentEditManager() {
        if (this.context == null) {
            return null;
        }
        return this.context.getEditManager();
    }

    private void addListenersTo(IEditManager editManager) {
        assert (editManager != null);
        assert (this.editManagerListener != null);
        editManager.addListener(this.editManagerListener);
    }
}

