/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal.command;

import com.vividsolutions.jts.geom.Coordinate;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.tool.edit.internal.Messages;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.animation.AddVertexAnimation;
import net.refractions.udig.tools.edit.animation.DeleteVertexAnimation;
import net.refractions.udig.tools.edit.commands.AddVertexCommand;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.Point;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddCustomVertexCommand
extends AddVertexCommand
implements UndoableMapCommand {
    private Coordinate toAdd = null;
    private Point point;
    private Coordinate addedCoord;
    private final EditBlackboard board;
    private IBlockingProvider<PrimitiveShape> shapeProvider;
    private EditToolHandler handler;
    private int index;
    private boolean showAnimation = true;
    private PrimitiveShape shape = null;

    public AddCustomVertexCommand(EditToolHandler handler2, EditBlackboard bb, IBlockingProvider<PrimitiveShape> provider, Coordinate coordinate, PrimitiveShape shape) {
        super(handler2, bb, provider, null, false);
        this.handler = handler2;
        this.board = bb;
        this.shapeProvider = provider;
        this.toAdd = coordinate;
        this.point = this.board.toPoint(this.toAdd);
        this.shape = shape;
    }

    public String getName() {
        return String.valueOf(Messages.AddVertexCommand_name) + this.toAdd;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        PrimitiveShape shape = this.shape;
        this.handler.setCurrentShape(shape);
        boolean collapseVertices = this.board.isCollapseVertices();
        try {
            this.board.setCollapseVertices(false);
            this.board.addCoordinate(this.toAdd, shape);
            this.addedCoord = this.toAdd;
            this.index = shape.getNumPoints() - 1;
        }
        finally {
            this.board.setCollapseVertices(collapseVertices);
        }
        if (this.handler.getContext().getMapDisplay() != null && this.showAnimation) {
            AddVertexAnimation animation = new AddVertexAnimation(this.point.getX(), this.point.getY());
            AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)animation);
        }
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        if (this.addedCoord == null) {
            return;
        }
        if (this.handler.getContext().getMapDisplay() != null && this.showAnimation) {
            DeleteVertexAnimation animation = new DeleteVertexAnimation(this.point);
            AnimationUpdater.runTimer((IMapDisplay)this.handler.getContext().getMapDisplay(), (IAnimation)animation);
        }
        this.board.removeCoordinate(this.index, this.addedCoord, this.shape);
        this.addedCoord = null;
    }
}

