/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;

final class SpecificLineBuilder {
    SpecificLineBuilder() {
    }

    public LineString mountTheLine(LineSegment key, LineSegment value, GeometryFactory gf) {
        Coordinate[] coordsFromRef = new Coordinate[]{key.getCoordinate(0), key.getCoordinate(1)};
        Coordinate[] coordsFromOff = new Coordinate[]{value.getCoordinate(0), value.getCoordinate(1)};
        CoordName resultRef1 = this.calculateReference1(coordsFromRef, coordsFromOff);
        CoordName resultRef2 = this.calculateReference2(coordsFromRef, coordsFromOff);
        CoordName resultOff1 = this.calculateOffset1(coordsFromOff, coordsFromRef);
        CoordName resultOff2 = this.calculateOffset2(coordsFromOff, coordsFromRef);
        Coordinate[] finalCoords = new Coordinate[2];
        if (resultRef1.equals((Object)resultRef2)) {
            finalCoords = this.mountLineReferencesEqual(resultRef1, resultOff1, resultOff2, finalCoords, coordsFromRef, coordsFromOff);
        }
        if (resultOff1.equals((Object)resultOff2)) {
            finalCoords = this.mountLineOffsetEqual(resultOff1, resultRef1, resultRef2, finalCoords, coordsFromRef, coordsFromOff);
        }
        finalCoords = this.mountLineRestOfTheCases(resultRef1, resultRef2, resultOff1, resultOff2, finalCoords, coordsFromRef, coordsFromOff);
        LineString resultLine = gf.createLineString(finalCoords);
        return resultLine;
    }

    private CoordName calculateReference1(Coordinate[] coordsFromRef, Coordinate[] coordsFromOff) {
        double distRef1Ref2 = coordsFromRef[0].distance(coordsFromRef[1]);
        double distRef1Off1 = coordsFromRef[0].distance(coordsFromOff[0]);
        double distRef1Off2 = coordsFromRef[0].distance(coordsFromOff[1]);
        double max = this.calculateLargestDistance(distRef1Ref2, distRef1Off1, distRef1Off2);
        assert (max != -1.0);
        CoordName resultRef1 = CoordName.EMPTY;
        if (max == distRef1Ref2) {
            resultRef1 = CoordName.REFERENCE_2;
        } else if (max == distRef1Off1) {
            resultRef1 = CoordName.OFFSET_1;
        } else if (max == distRef1Off2) {
            resultRef1 = CoordName.OFFSET_2;
        } else assert (false) : "impossible situation.";
        return resultRef1;
    }

    private CoordName calculateReference2(Coordinate[] coordsFromRef, Coordinate[] coordsFromOff) {
        double distRef2Ref1 = coordsFromRef[1].distance(coordsFromRef[0]);
        double distRef2Off1 = coordsFromRef[1].distance(coordsFromOff[0]);
        double distRef2Off2 = coordsFromRef[1].distance(coordsFromOff[1]);
        double max = this.calculateLargestDistance(distRef2Ref1, distRef2Off1, distRef2Off2);
        assert (max != -1.0);
        CoordName resultRef2 = CoordName.EMPTY;
        if (max == distRef2Ref1) {
            resultRef2 = CoordName.REFERENCE_1;
        } else if (max == distRef2Off1) {
            resultRef2 = CoordName.OFFSET_1;
        } else if (max == distRef2Off2) {
            resultRef2 = CoordName.OFFSET_2;
        } else assert (false) : "impossible situation.";
        return resultRef2;
    }

    private CoordName calculateOffset1(Coordinate[] coordsFromOff, Coordinate[] coordsFromRef) {
        double distOff1Off2 = coordsFromOff[0].distance(coordsFromOff[1]);
        double distOff1Ref1 = coordsFromOff[0].distance(coordsFromRef[0]);
        double distOff1Ref2 = coordsFromOff[0].distance(coordsFromRef[1]);
        double max = this.calculateLargestDistance(distOff1Off2, distOff1Ref1, distOff1Ref2);
        assert (max != -1.0);
        CoordName resultOff1 = CoordName.EMPTY;
        if (max == distOff1Off2) {
            resultOff1 = CoordName.OFFSET_2;
        } else if (max == distOff1Ref1) {
            resultOff1 = CoordName.REFERENCE_1;
        } else if (max == distOff1Ref2) {
            resultOff1 = CoordName.REFERENCE_2;
        } else assert (false) : "impossible situation.";
        return resultOff1;
    }

    private CoordName calculateOffset2(Coordinate[] coordsFromOff, Coordinate[] coordsFromRef) {
        double distOff2Off1 = coordsFromOff[1].distance(coordsFromOff[0]);
        double distOff2Ref1 = coordsFromOff[1].distance(coordsFromRef[0]);
        double distOff2Ref2 = coordsFromOff[1].distance(coordsFromRef[1]);
        double max = this.calculateLargestDistance(distOff2Off1, distOff2Ref1, distOff2Ref2);
        assert (max != -1.0);
        CoordName resultOff2 = CoordName.EMPTY;
        if (max == distOff2Off1) {
            resultOff2 = CoordName.OFFSET_1;
        } else if (max == distOff2Ref1) {
            resultOff2 = CoordName.REFERENCE_1;
        } else if (max == distOff2Ref2) {
            resultOff2 = CoordName.REFERENCE_2;
        } else assert (false) : "impossible situation.";
        return resultOff2;
    }

    private Coordinate[] mountLineReferencesEqual(CoordName resultRef1, CoordName resultOff1, CoordName resultOff2, Coordinate[] finalCoords, Coordinate[] coordsFromRef, Coordinate[] coordsFromOff) {
        if (resultRef1.equals((Object)CoordName.OFFSET_1) && resultOff1.equals((Object)CoordName.REFERENCE_1)) {
            finalCoords[0] = coordsFromOff[0];
            finalCoords[1] = coordsFromRef[0];
        }
        if (resultRef1.equals((Object)CoordName.OFFSET_1) && resultOff1.equals((Object)CoordName.REFERENCE_2)) {
            finalCoords[0] = coordsFromOff[0];
            finalCoords[1] = coordsFromRef[1];
        }
        if (resultRef1.equals((Object)CoordName.OFFSET_2) && resultOff2.equals((Object)CoordName.REFERENCE_1)) {
            finalCoords[0] = coordsFromOff[1];
            finalCoords[1] = coordsFromRef[0];
        }
        if (resultRef1.equals((Object)CoordName.OFFSET_2) && resultOff2.equals((Object)CoordName.REFERENCE_2)) {
            finalCoords[0] = coordsFromOff[1];
            finalCoords[1] = coordsFromRef[1];
        }
        return finalCoords;
    }

    private Coordinate[] mountLineOffsetEqual(CoordName resultOff1, CoordName resultRef1, CoordName resultRef2, Coordinate[] finalCoords, Coordinate[] coordsFromRef, Coordinate[] coordsFromOff) {
        if (resultOff1.equals((Object)CoordName.REFERENCE_1) && resultRef1.equals((Object)CoordName.OFFSET_1)) {
            finalCoords[0] = coordsFromRef[0];
            finalCoords[1] = coordsFromOff[0];
        }
        if (resultOff1.equals((Object)CoordName.REFERENCE_1) && resultRef1.equals((Object)CoordName.OFFSET_2)) {
            finalCoords[0] = coordsFromRef[0];
            finalCoords[1] = coordsFromOff[1];
        }
        if (resultOff1.equals((Object)CoordName.REFERENCE_2) && resultRef2.equals((Object)CoordName.OFFSET_1)) {
            finalCoords[0] = coordsFromRef[1];
            finalCoords[1] = coordsFromOff[0];
        }
        if (resultOff1.equals((Object)CoordName.REFERENCE_2) && resultRef2.equals((Object)CoordName.OFFSET_2)) {
            finalCoords[0] = coordsFromRef[1];
            finalCoords[1] = coordsFromOff[1];
        }
        return finalCoords;
    }

    private Coordinate[] mountLineRestOfTheCases(CoordName resultRef1, CoordName resultRef2, CoordName resultOff1, CoordName resultOff2, Coordinate[] finalCoords, Coordinate[] coordsFromRef, Coordinate[] coordsFromOff) {
        if (resultRef1.equals((Object)CoordName.REFERENCE_2) && resultRef2.equals((Object)CoordName.REFERENCE_1)) {
            finalCoords[0] = coordsFromRef[0];
            finalCoords[1] = coordsFromRef[1];
        }
        if (resultOff1.equals((Object)CoordName.OFFSET_2) && resultOff2.equals((Object)CoordName.OFFSET_1)) {
            finalCoords[0] = coordsFromOff[0];
            finalCoords[1] = coordsFromOff[1];
        }
        if (resultRef1.equals((Object)CoordName.OFFSET_1) && resultOff1.equals((Object)CoordName.REFERENCE_1)) {
            finalCoords[0] = coordsFromRef[0];
            finalCoords[1] = coordsFromOff[0];
        }
        if (resultRef1.equals((Object)CoordName.OFFSET_2) && resultOff2.equals((Object)CoordName.REFERENCE_1)) {
            finalCoords[0] = coordsFromRef[0];
            finalCoords[1] = coordsFromOff[1];
        }
        if (resultRef2.equals((Object)CoordName.OFFSET_1) && resultOff1.equals((Object)CoordName.REFERENCE_2)) {
            finalCoords[0] = coordsFromRef[1];
            finalCoords[1] = coordsFromOff[0];
        }
        if (resultRef2.equals((Object)CoordName.OFFSET_2) && resultOff2.equals((Object)CoordName.REFERENCE_2)) {
            finalCoords[0] = coordsFromRef[1];
            finalCoords[1] = coordsFromOff[1];
        }
        return finalCoords;
    }

    private double calculateLargestDistance(double dist1, double dist2, double dist3) {
        if (dist1 > dist2) {
            if (dist1 > dist3) {
                return dist1;
            }
            return dist3;
        }
        if (dist2 > dist3) {
            return dist2;
        }
        return dist3;
    }

    private static enum CoordName {
        OFFSET_1,
        OFFSET_2,
        REFERENCE_1,
        REFERENCE_2,
        EMPTY;

    }
}

