/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import eu.udig.tools.parallel.internal.ParallelContext;
import eu.udig.tools.parallel.internal.PrecisionToolsMode;
import eu.udig.tools.parallel.internal.command.AddCustomVertexCommand;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.EditState;
import net.refractions.udig.tools.edit.EditToolHandler;
import net.refractions.udig.tools.edit.commands.DeselectEditGeomCommand;
import net.refractions.udig.tools.edit.support.EditBlackboard;
import net.refractions.udig.tools.edit.support.EditGeom;
import net.refractions.udig.tools.edit.support.EditUtils;
import net.refractions.udig.tools.edit.support.PrimitiveShape;
import net.refractions.udig.tools.edit.support.ShapeType;

public class ParallelPreview
implements Observer {
    private ParallelContext parallelContext = null;
    private IToolContext context = null;
    private EditToolHandler handler = null;
    private static final ParallelPreview THIS = new ParallelPreview();

    private ParallelPreview() {
    }

    public static ParallelPreview getInstance() {
        return THIS;
    }

    public void setParameters(IToolContext toolContext, EditToolHandler editToolHandler, ParallelContext parallelContext) {
        this.context = toolContext;
        this.handler = editToolHandler;
        this.parallelContext = parallelContext;
    }

    @Override
    public void update(Observable o, Object arg) {
        if ("UPDATE_LAYER".equals(arg) || "UPDATE_ERROR".equals(arg)) {
            this.redraw();
        }
    }

    private void redraw() {
        UndoableComposite composite = new UndoableComposite();
        this.delete(composite);
        this.draw(composite);
        composite.setMap(this.handler.getContext().getMap());
        this.context.sendASyncCommand((Command)composite);
        this.handler.getContext().getViewportPane().repaint();
    }

    private void delete(UndoableComposite composite) {
        LinkedList list = new LinkedList();
        EditBlackboard bb = this.handler.getCurrentEditBlackboard();
        list.addAll(bb.getGeoms());
        composite.addCommand((MapCommand)new DeselectEditGeomCommand(this.handler, list));
    }

    public void draw(UndoableComposite composite) {
        if (this.parallelContext.mode != PrecisionToolsMode.READY) {
            return;
        }
        EditBlackboard bb = this.handler.getEditBlackboard(this.handler.getEditLayer());
        List<Geometry> resultList = this.parallelContext.getOutputCoordinates();
        for (Geometry result : resultList) {
            Coordinate[] coordinates = result.getCoordinates();
            ArrayList<Coordinate> array = new ArrayList<Coordinate>();
            Coordinate[] coordinateArray = coordinates;
            int n = coordinates.length;
            int n2 = 0;
            while (n2 < n) {
                Coordinate coord = coordinateArray[n2];
                array.add(coord);
                ++n2;
            }
            Iterator coorIt = array.iterator();
            EditGeom newEditGeom = bb.newGeom("", ShapeType.LINE);
            PrimitiveShape shape = newEditGeom.getShell();
            this.handler.setCurrentShape(shape);
            this.handler.setCurrentState(EditState.MODIFYING);
            Coordinate coor = null;
            while (coorIt.hasNext()) {
                coor = (Coordinate)coorIt.next();
                composite.addFinalizerCommand((MapCommand)new AddCustomVertexCommand(this.handler, bb, (IBlockingProvider<PrimitiveShape>)new EditUtils.EditToolHandlerShapeProvider(this.handler), coor, shape));
            }
        }
    }
}

