/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import eu.udig.tools.parallel.internal.AlgorithmUtils;
import eu.udig.tools.parallel.internal.DataDirectionUntil;
import eu.udig.tools.parallel.internal.DataSegmentIntersection;
import eu.udig.tools.parallel.internal.InvalidDistanceException;
import eu.udig.tools.parallel.internal.QuadrantAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class OffsetOrientationAnalyzer {
    private final GeometryFactory gf;
    private List<Coordinate> inputList;
    private final List<Coordinate> sourceList;
    private Map<Integer, List<DataSegmentIntersection>> intersectionData;
    private List<Coordinate> eliminatedCoords = new ArrayList<Coordinate>();
    private Map<Integer, Map<Coordinate, Boolean>> addedCoords = new HashMap<Integer, Map<Coordinate, Boolean>>();
    private int intersectionLastPosition;
    private int badCoordinate;
    private int totalIntersection;
    private static final double SMALL_DISTANCE = 1.0E-6;

    public OffsetOrientationAnalyzer(List<Coordinate> inputList, GeometryFactory gf, List<Coordinate> sourceList, Map<Integer, List<DataSegmentIntersection>> intersectionData) {
        this.inputList = inputList;
        this.gf = gf;
        this.sourceList = sourceList;
        this.intersectionData = intersectionData;
    }

    public List<Geometry> discardClosed() {
        assert (this.inputList.size() == this.sourceList.size()) : "size not equal";
        int n = this.inputList.size();
        boolean found = false;
        List<LinearRing> ringList = this.getRings();
        ArrayList<LinearRing> finalRings = new ArrayList<LinearRing>();
        finalRings.addAll(ringList);
        DataDirectionUntil[] indexList = new DataDirectionUntil[n];
        int i = 0;
        while (i < n - 1) {
            found = false;
            Coordinate intersectionCoord = null;
            Coordinate[] segCoord = new Coordinate[]{this.inputList.get(i), i == n - 1 ? this.inputList.get(0) : this.inputList.get(i + 1)};
            LineString segment = this.gf.createLineString(segCoord);
            intersectionCoord = this.findIntersectionForward((Geometry)segment, segCoord, i, n);
            if (intersectionCoord == null) {
                if (this.intersectionData.containsKey(i)) {
                    indexList = this.storeIndex(i, n, indexList, segment, segCoord);
                }
            } else {
                this.intersectionLastPosition = this.intersectionLastPosition == n - 1 ? 0 : this.intersectionLastPosition + 1;
                int h = i;
                while (!found) {
                    found = this.findIntersectionBackward(segment, intersectionCoord, h, n);
                    int n2 = h = h == 0 ? n - 1 : (h - 1) % n;
                }
                Coordinate[] firstOriginalSegment = new Coordinate[]{this.sourceList.get(i), this.sourceList.get(i + 1)};
                Coordinate[] secondOriginalSegment = new Coordinate[]{this.sourceList.get(this.intersectionLastPosition), this.sourceList.get(this.intersectionLastPosition == 0 ? n - 1 : this.intersectionLastPosition - 1)};
                Coordinate imaginaryCoord = GeometryUtil.intersection(firstOriginalSegment[0], firstOriginalSegment[1], secondOriginalSegment[0], secondOriginalSegment[1]);
                assert (imaginaryCoord != null) : "can't be null";
                if (this.belongsToSegment(firstOriginalSegment, secondOriginalSegment, imaginaryCoord) && !this.checkQuadrantClosedLines(i, n, intersectionCoord, imaginaryCoord)) {
                    List<LinearRing> deletedRings = this.getDeletedRings(ringList);
                    double min = Double.MAX_VALUE;
                    LinearRing candidate = null;
                    for (LinearRing ring : deletedRings) {
                        double size = ring.getCoordinates().length;
                        if (!(size < min)) continue;
                        min = size;
                        candidate = ring;
                    }
                    finalRings.remove(candidate);
                }
            }
            ++i;
        }
        ArrayList<Geometry> resultList = new ArrayList<Geometry>();
        ArrayList<Integer> usedIndexes = new ArrayList<Integer>();
        for (LinearRing result : finalRings) {
            Coordinate[] ringCoords = result.getCoordinates();
            this.eliminatedCoords.clear();
            this.addedCoords.clear();
            int i2 = 0;
            while (i2 < ringCoords.length) {
                Coordinate actualCoord = ringCoords[i2];
                int j = 0;
                while (j < indexList.length) {
                    DataDirectionUntil data = indexList[j];
                    if (data != null) {
                        Integer indexKey = j;
                        Boolean forward = data.getIsForwardDirection();
                        int until = data.getUntilPosition();
                        if (actualCoord.equals2D(this.inputList.get(indexKey)) && !usedIndexes.contains(indexKey)) {
                            try {
                                result = this.improveTheRing(i2, indexKey, n, ringCoords, forward, until);
                                usedIndexes.add(indexKey);
                            }
                            catch (InvalidDistanceException invalidDistanceException) {}
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            resultList.add((Geometry)result);
        }
        return resultList;
    }

    private List<LinearRing> getDeletedRings(List<LinearRing> ringList) {
        ArrayList<LinearRing> deletedRings = new ArrayList<LinearRing>();
        for (LinearRing ring : ringList) {
            Coordinate eliminateCoord;
            Point eliminatePoint;
            if (!ring.intersects((Geometry)(eliminatePoint = this.gf.createPoint(eliminateCoord = this.inputList.get(this.badCoordinate))))) continue;
            deletedRings.add(ring);
        }
        return deletedRings;
    }

    private LinearRing improveTheRing(int i, int j, int n, Coordinate[] ringCoords, Boolean forward, int until) throws InvalidDistanceException {
        int fourthIndex;
        int thirdIndex;
        int secondIndex;
        int firstIndex;
        LinearRing result = null;
        int untilDifference = 0;
        int ringLength = ringCoords.length;
        untilDifference = this.calculateUntilDifference(forward, until, j, i, n, ringLength);
        if (forward.booleanValue()) {
            firstIndex = j;
            secondIndex = firstIndex == n - 2 ? 0 : j + 1;
            thirdIndex = until - 1;
            fourthIndex = thirdIndex == n - 2 ? 0 : thirdIndex + 1;
        } else {
            firstIndex = j + 1;
            secondIndex = firstIndex == 0 ? n - 2 : firstIndex - 1;
            thirdIndex = until + 1;
            fourthIndex = thirdIndex == 0 ? n - 2 : thirdIndex - 1;
        }
        LineString firstLine = this.createLineSegment(firstIndex, secondIndex);
        LineString secondLine = this.createLineSegment(thirdIndex, fourthIndex);
        Coordinate intersection = GeometryUtil.intersection(firstLine.getCoordinateN(0), firstLine.getCoordinateN(1), secondLine.getCoordinateN(0), secondLine.getCoordinateN(1));
        List<DataSegmentIntersection> pointsThatBelongs = this.intersectionData.get(j);
        if (forward.booleanValue()) {
            firstIndex = i;
            secondIndex = i == ringLength - 2 ? 0 : i + 1;
            thirdIndex = untilDifference - 1;
            fourthIndex = thirdIndex == ringLength - 2 ? 0 : thirdIndex + 1;
        } else {
            firstIndex = i + 1;
            secondIndex = firstIndex == 0 ? ringLength - 2 : firstIndex - 1;
            thirdIndex = untilDifference + 1;
            fourthIndex = thirdIndex == 0 ? ringLength - 2 : thirdIndex - 1;
        }
        Coordinate coordinateToAdd = this.getClosestPoint(intersection, pointsThatBelongs);
        result = this.modifyRing(coordinateToAdd, firstIndex, secondIndex, thirdIndex, fourthIndex, ringCoords, forward, untilDifference);
        return result;
    }

    private int calculateUntilDifference(boolean forward, int until, int j, int i, int n, int ringLength) {
        int diff;
        int untilDifference = forward ? (until > j ? (i + (diff = until - j) > ringLength - 2 ? ringLength - diff - i + 1 : i + diff) : (i + (diff = n - j) > ringLength - 2 ? ringLength - diff - i : i + diff)) : (j > until ? (i - (diff = j - until) < 0 ? ringLength - diff + i - 1 : i - diff) : (i - (diff = n - until) < 0 ? ringLength - diff + i : i - diff));
        return untilDifference;
    }

    private DataDirectionUntil[] storeIndex(int i, int n, DataDirectionUntil[] indexList, LineString segment, Coordinate[] segCoord) {
        List<DataSegmentIntersection> dataList = this.intersectionData.get(i);
        if (dataList.size() > 1) {
            return indexList;
        }
        for (DataSegmentIntersection data : dataList) {
            boolean same;
            int startSegmentIndex = data.getStartSegmentIndex();
            boolean isForward = data.getIsForward();
            boolean isValidForStore = false;
            if (isForward) {
                int j = i;
                while (j < startSegmentIndex - 1) {
                    same = this.hasSameOrientation(i, true);
                    if (same) {
                        isValidForStore = false;
                        break;
                    }
                    isValidForStore = true;
                    ++j;
                }
                if (!isValidForStore) continue;
                indexList[i] = new DataDirectionUntil(isForward, startSegmentIndex + 1);
                continue;
            }
            ++i;
            int endIndex = startSegmentIndex + 2;
            if (endIndex == n - 1) {
                endIndex = 0;
            } else if (endIndex == 0) {
                endIndex = 1;
            }
            int j = i;
            do {
                if (same = this.hasSameOrientationReverse(i, true)) {
                    isValidForStore = false;
                    break;
                }
                isValidForStore = true;
            } while ((j = j == 0 ? n - 2 : j - 1) != endIndex);
            if (!isValidForStore) continue;
            indexList[i - 1] = new DataDirectionUntil(isForward, startSegmentIndex);
        }
        return indexList;
    }

    private List<LinearRing> getRings() {
        ArrayList<LinearRing> ringList = new ArrayList<LinearRing>();
        boolean isCCWinputList = CGAlgorithms.isCCW((Coordinate[])this.inputList.toArray(new Coordinate[this.inputList.size()]));
        LineString inputLineString = this.gf.createLineString(this.inputList.toArray(new Coordinate[this.inputList.size()]));
        Geometry multiLines = inputLineString.union();
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add(multiLines);
        Collection polyCollection = polygonizer.getPolygons();
        for (Polygon pol : polyCollection) {
            Coordinate[] polCoord = pol.getExteriorRing().getCoordinates();
            boolean isCCWpolygon = CGAlgorithms.isCCW((Coordinate[])polCoord);
            if (isCCWinputList != isCCWpolygon) {
                CoordinateArrays.reverse((Coordinate[])polCoord);
            }
            LinearRing polygonRing = this.gf.createLinearRing(polCoord);
            ringList.add(polygonRing);
        }
        return ringList;
    }

    private LinearRing modifyRing(Coordinate coordinateToAdd, Integer firstIndex, int secondIndex, int thirdIndex, int fourthIndex, Coordinate[] ringCoords, Boolean forward, int untilDifference) {
        ArrayList<Coordinate> createdRing = new ArrayList<Coordinate>();
        int i = 0;
        while (i < ringCoords.length) {
            if (!this.eliminateCoords(forward, firstIndex, untilDifference, i, ringCoords) && !this.eliminatedCoords.contains(ringCoords[i])) {
                if (this.addedCoords.containsKey(i)) {
                    Map<Coordinate, Boolean> values = this.addedCoords.get(i);
                    Map.Entry<Coordinate, Boolean> entry = values.entrySet().iterator().next();
                    Coordinate coordToAdd = entry.getKey();
                    Boolean whereToAdd = entry.getValue();
                    if (whereToAdd.booleanValue()) {
                        createdRing.add(ringCoords[i]);
                        createdRing.add(coordToAdd);
                    } else {
                        createdRing.add(coordToAdd);
                        createdRing.add(ringCoords[i]);
                    }
                } else {
                    createdRing.add(ringCoords[i]);
                }
                if (i == firstIndex) {
                    HashMap<Coordinate, Boolean> added = new HashMap<Coordinate, Boolean>();
                    added.put(coordinateToAdd, forward);
                    this.addedCoords.put(i, added);
                    if (forward.booleanValue()) {
                        createdRing.add(coordinateToAdd);
                    } else {
                        createdRing.remove(createdRing.size() - 1);
                        createdRing.add(coordinateToAdd);
                        createdRing.add(ringCoords[i]);
                    }
                }
            }
            ++i;
        }
        int size = createdRing.size();
        if (!((Coordinate)createdRing.get(0)).equals2D((Coordinate)createdRing.get(size - 1))) {
            createdRing.add((Coordinate)createdRing.get(0));
        }
        Coordinate[] createdCoords = createdRing.toArray(new Coordinate[createdRing.size()]);
        LinearRing result = this.gf.createLinearRing(createdCoords);
        return result;
    }

    private boolean eliminateCoords(boolean forward, int firstIndex, int untilDifference, int i, Coordinate[] ringCoords) {
        if (forward) {
            if (firstIndex > untilDifference) {
                if (i > firstIndex || i < untilDifference) {
                    this.eliminatedCoords.add(ringCoords[i]);
                    return true;
                }
            } else if (i > firstIndex && i < untilDifference) {
                this.eliminatedCoords.add(ringCoords[i]);
                return true;
            }
        } else if (firstIndex > untilDifference) {
            if (i > untilDifference && i < firstIndex) {
                this.eliminatedCoords.add(ringCoords[i]);
                return true;
            }
        } else if (i < firstIndex || i > untilDifference) {
            this.eliminatedCoords.add(ringCoords[i]);
            return true;
        }
        return false;
    }

    private Coordinate getClosestPoint(Coordinate intersection, List<DataSegmentIntersection> pointsThatBelongs) throws InvalidDistanceException {
        Double min = Double.MAX_VALUE;
        Coordinate closest = null;
        for (DataSegmentIntersection point : pointsThatBelongs) {
            double dist = point.getIntersectionCoordinate().distance(intersection);
            if (!(dist < min)) continue;
            min = dist;
            closest = point.getIntersectionCoordinate();
        }
        if (!(min < 1.0E-6)) {
            throw new InvalidDistanceException(min.toString());
        }
        return closest;
    }

    private boolean belongsToSegment(Coordinate[] firstOriginalSegment, Coordinate[] secondOriginalSegment, Coordinate imaginaryCoord) {
        if (this.totalIntersection == 1) {
            return true;
        }
        LineString firstSegment = this.gf.createLineString(firstOriginalSegment);
        LineString secondSegment = this.gf.createLineString(secondOriginalSegment);
        Point point = this.gf.createPoint(imaginaryCoord);
        return this.totalIntersection == 2 && (firstSegment.distance((Geometry)point) < 1.0E-6 || secondSegment.distance((Geometry)point) < 1.0E-6);
    }

    private boolean hasSameOrientation(int i, boolean isClosedLine) {
        boolean result;
        int n = this.inputList.size();
        int second = i + 1;
        int third = i + 2;
        if (isClosedLine) {
            if (i == n - 1) {
                second = 1;
                third = 2;
            } else if (i == n - 2) {
                third = 1;
            }
        } else if (i == n - 1) {
            second = 0;
            third = 1;
        } else if (i == n - 2) {
            third = 0;
        }
        int offsetOrientation = CGAlgorithms.orientationIndex((Coordinate)this.inputList.get(i), (Coordinate)this.inputList.get(second), (Coordinate)this.inputList.get(third));
        int originalOrientation = CGAlgorithms.orientationIndex((Coordinate)this.sourceList.get(i), (Coordinate)this.sourceList.get(second), (Coordinate)this.sourceList.get(third));
        boolean bl = result = offsetOrientation == originalOrientation;
        if (result) {
            Coordinate secondCoordInput = this.inputList.get(second);
            Coordinate thirdCoordInput = this.inputList.get(third);
            Coordinate secondCoordSrc = this.sourceList.get(second);
            Coordinate thirdCoordSrc = this.sourceList.get(third);
            if (!secondCoordInput.equals2D(thirdCoordInput) && !secondCoordSrc.equals2D(thirdCoordSrc)) {
                int orientationQuadrant;
                int offsetQuadrant = Quadrant.quadrant((Coordinate)secondCoordInput, (Coordinate)thirdCoordInput);
                result = offsetQuadrant == (orientationQuadrant = Quadrant.quadrant((Coordinate)secondCoordSrc, (Coordinate)thirdCoordSrc));
            }
        }
        return result;
    }

    private boolean hasSameOrientationReverse(int i, boolean isClosedLine) {
        boolean result;
        int n = this.inputList.size();
        int second = i - 1;
        int third = i - 2;
        if (isClosedLine) {
            if (i == 0) {
                second = n - 2;
                third = n - 3;
            } else if (i == 1) {
                third = n - 2;
            }
        } else if (i == 0) {
            second = n - 1;
            third = n - 2;
        } else if (i == 1) {
            third = n - 1;
        }
        int offsetOrientation = CGAlgorithms.orientationIndex((Coordinate)this.inputList.get(i), (Coordinate)this.inputList.get(second), (Coordinate)this.inputList.get(third));
        int originalOrientation = CGAlgorithms.orientationIndex((Coordinate)this.sourceList.get(i), (Coordinate)this.sourceList.get(second), (Coordinate)this.sourceList.get(third));
        boolean bl = result = originalOrientation == offsetOrientation;
        if (result) {
            Coordinate secondCoordInput = this.inputList.get(second);
            Coordinate thirdCoordInput = this.inputList.get(third);
            Coordinate secondCoordSrc = this.sourceList.get(second);
            Coordinate thirdCoordSrc = this.sourceList.get(third);
            if (!secondCoordInput.equals2D(thirdCoordInput) && !secondCoordSrc.equals2D(thirdCoordSrc)) {
                int orientationQuadrant;
                int offsetQuadrant = Quadrant.quadrant((Coordinate)secondCoordInput, (Coordinate)thirdCoordInput);
                result = offsetQuadrant == (orientationQuadrant = Quadrant.quadrant((Coordinate)secondCoordSrc, (Coordinate)thirdCoordSrc));
            }
        }
        return result;
    }

    private boolean findIntersectionBackward(LineString segment, Coordinate firstCandidateCoord, int i, int n) {
        Coordinate[] segCoord = new Coordinate[]{this.inputList.get(i), i == 0 ? this.inputList.get(n - 1) : this.inputList.get(i - 1)};
        LineString secondSegment = this.gf.createLineString(segCoord);
        if (segment.intersects((Geometry)secondSegment)) {
            Geometry resultPoints = segment.intersection((Geometry)secondSegment);
            int k = 0;
            while (k < resultPoints.getNumGeometries()) {
                Coordinate intersectionCoord = resultPoints.getGeometryN(k).getCoordinate();
                if (firstCandidateCoord.equals2D(intersectionCoord)) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    private Coordinate findIntersectionForward(Geometry segment, Coordinate[] segCoord, int j, int n) {
        LineString interSegment = null;
        Coordinate candidateCoord = null;
        Coordinate finalCoordinate = null;
        this.intersectionLastPosition = -1;
        int count = 0;
        int h = j;
        do {
            h = (h + 1) % n;
            Coordinate[] interCoord = new Coordinate[]{this.inputList.get(h), h == n - 1 ? this.inputList.get(0) : this.inputList.get(h + 1)};
            interSegment = this.gf.createLineString(interCoord);
            candidateCoord = AlgorithmUtils.getIntersectionCoord(segment, (Geometry)interSegment, segCoord);
            if (candidateCoord == null) continue;
            finalCoordinate = new Coordinate(candidateCoord);
            this.intersectionLastPosition = h;
            ++count;
        } while (h != j);
        this.totalIntersection = count;
        return finalCoordinate;
    }

    public List<Geometry> discardNonClosed() {
        if (this.inputList.size() < 4) {
            ArrayList<Geometry> resultList = new ArrayList<Geometry>();
            Coordinate[] resultCoord = this.inputList.toArray(new Coordinate[this.inputList.size()]);
            resultList.add((Geometry)this.gf.createLineString(resultCoord));
            return resultList;
        }
        assert (this.inputList.size() == this.sourceList.size()) : "size not equal";
        int n = this.inputList.size();
        boolean lastAddedWasIntersection = false;
        ArrayList<Coordinate> filteredResult = new ArrayList<Coordinate>();
        Coordinate intersectCoord = null;
        Coordinate candidateCoord = null;
        int start = 0;
        if (!this.hasSameOrientation(0, false) && !this.hasBeginIntersections()) {
            start = 1;
        }
        int i = start;
        while (i < n - 1) {
            candidateCoord = null;
            this.intersectionLastPosition = -1;
            LineString firstSegment = intersectCoord == null ? this.createLineSegment(i, i + 1) : this.createLineSegment(intersectCoord, i + 1);
            intersectCoord = null;
            candidateCoord = this.findIntersectionWithProvidedSegment(firstSegment, i + 1, n);
            if (candidateCoord != null) {
                assert (this.intersectionLastPosition != -1) : "intersection must be found";
                boolean sameQuadrant = true;
                sameQuadrant = this.checkQuadrantOpenLines(i);
                if (!sameQuadrant) {
                    if (lastAddedWasIntersection) {
                        filteredResult.add(candidateCoord);
                    } else {
                        filteredResult.add(this.inputList.get(i));
                        filteredResult.add(candidateCoord);
                    }
                    lastAddedWasIntersection = true;
                    intersectCoord = new Coordinate(candidateCoord);
                } else {
                    if (!lastAddedWasIntersection) {
                        filteredResult.add(this.inputList.get(i));
                    }
                    lastAddedWasIntersection = false;
                }
            } else {
                if (!lastAddedWasIntersection) {
                    filteredResult.add(this.inputList.get(i));
                }
                lastAddedWasIntersection = false;
            }
            int n2 = i = lastAddedWasIntersection ? this.intersectionLastPosition : i + 1;
        }
        if (this.hasSameOrientationReverse(n - 1, false) || this.hasEndIntersections(n)) {
            filteredResult.add(this.inputList.get(n - 1));
        }
        ArrayList<Geometry> resultList = new ArrayList<Geometry>();
        Coordinate[] resultCoord = filteredResult.toArray(new Coordinate[filteredResult.size()]);
        resultList.add((Geometry)this.gf.createLineString(resultCoord));
        return resultList;
    }

    private boolean checkQuadrantOpenLines(int i) {
        boolean isOk = false;
        QuadrantAnalyzer qAnalyzer = new QuadrantAnalyzer(this.inputList, this.sourceList, i, this.intersectionLastPosition);
        qAnalyzer.analyzeNonClosedLines();
        isOk = qAnalyzer.isValid();
        if (isOk) {
            boolean sameOrientation;
            isOk = sameOrientation = this.hasSameOrientation(i + 1, false);
        }
        return isOk;
    }

    private boolean checkQuadrantClosedLines(int i, int size, Coordinate realIntersectionCoord, Coordinate imaginaryCoord) {
        boolean isOk = false;
        QuadrantAnalyzer qAnalyzer = new QuadrantAnalyzer(this.inputList, this.sourceList, i, this.intersectionLastPosition, size, realIntersectionCoord, imaginaryCoord);
        qAnalyzer.analyzeClosedLines();
        isOk = qAnalyzer.isValid();
        if (!isOk) {
            QuadrantAnalyzer.AnalyzerPosition positionIndex = qAnalyzer.getResultIndex();
            switch (positionIndex) {
                case SEGMENT_1_POINT_1: {
                    this.badCoordinate = i;
                    break;
                }
                case SEGMENT_1_POINT_2: {
                    this.badCoordinate = i + 1;
                    break;
                }
                case SEGMENT_2_POINT_1: {
                    this.badCoordinate = this.intersectionLastPosition;
                    break;
                }
                case SEGMENT_2_POINT_2: {
                    this.badCoordinate = this.intersectionLastPosition == 0 ? size - 1 : this.intersectionLastPosition - 1;
                    break;
                }
            }
        }
        return isOk;
    }

    private boolean hasBeginIntersections() {
        LineString firstSegment = this.createLineSegment(0, 1);
        LineString secondSegment = this.createLineSegment(2, 3);
        Coordinate[] firstSegC = new Coordinate[]{this.inputList.get(0), this.inputList.get(1)};
        Coordinate interCoord = AlgorithmUtils.getIntersectionCoord((Geometry)firstSegment, (Geometry)secondSegment, firstSegC);
        return interCoord != null;
    }

    private boolean hasEndIntersections(int n) {
        LineString firstSegment = this.createLineSegment(n - 1, n - 2);
        LineString secondSegment = this.createLineSegment(n - 3, n - 4);
        Coordinate[] firstSegC = new Coordinate[]{this.inputList.get(n - 1), this.inputList.get(n - 2)};
        Coordinate interCoord = AlgorithmUtils.getIntersectionCoord((Geometry)firstSegment, (Geometry)secondSegment, firstSegC);
        return interCoord != null;
    }

    private LineString createLineSegment(Coordinate firstCoord, int second) {
        Coordinate[] firstSegC = new Coordinate[]{new Coordinate(firstCoord), this.inputList.get(second)};
        return this.gf.createLineString(firstSegC);
    }

    private LineString createLineSegment(int first, int second) {
        Coordinate[] firstSegC = new Coordinate[]{this.inputList.get(first), this.inputList.get(second)};
        return this.gf.createLineString(firstSegC);
    }

    private Coordinate findIntersectionWithProvidedSegment(LineString firstSegment, int start, int n) {
        LineString interSegment = null;
        Coordinate candidateCoord = null;
        Coordinate finalCoordinate = null;
        Coordinate[] firstSegC = new Coordinate[]{firstSegment.getCoordinateN(0), firstSegment.getCoordinateN(1)};
        this.intersectionLastPosition = -1;
        int h = start;
        while (h < n - 1) {
            interSegment = this.createLineSegment(h, h + 1);
            candidateCoord = AlgorithmUtils.getIntersectionCoord((Geometry)firstSegment, (Geometry)interSegment, firstSegC);
            if (candidateCoord != null) {
                finalCoordinate = new Coordinate(candidateCoord);
                this.intersectionLastPosition = h;
            }
            ++h;
        }
        return finalCoordinate;
    }
}

