/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.parallel.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;

public final class AlgorithmUtils {
    public static int forwardIntersectedSegmentsCounter(LineString subjectLine, Coordinate[] subjectLineCoord, int j, int n, Coordinate[] inputList, GeometryFactory gf, Coordinate intersectionCoord) {
        Coordinate[] interCoord;
        LineString interSegment = null;
        Coordinate candidateCoord = null;
        int counter = 0;
        int h = j;
        do {
            ++counter;
            h = (h + 1) % n;
            interCoord = new Coordinate[]{inputList[h], h == n - 1 ? inputList[0] : inputList[h + 1]};
        } while (((candidateCoord = AlgorithmUtils.getIntersectionCoord((Geometry)subjectLine, (Geometry)(interSegment = gf.createLineString(interCoord)), subjectLineCoord)) == null || !candidateCoord.equals2D(intersectionCoord)) && h != j);
        return counter;
    }

    public static int backwardIntersectedSegmentCounter(Geometry subjectLine, Coordinate[] subjectLineCoord, int j, int n, Coordinate[] inputList, GeometryFactory gf, Coordinate intersectionCoord) {
        Coordinate[] interCoord;
        LineString interSegment = null;
        Coordinate candidateCoord = null;
        int counter = 0;
        int h = j;
        do {
            ++counter;
        } while (((candidateCoord = AlgorithmUtils.getIntersectionCoord(subjectLine, (Geometry)(interSegment = gf.createLineString(interCoord = new Coordinate[]{inputList[h], h == 0 ? inputList[n - 1] : inputList[h - 1]})), subjectLineCoord)) == null || !candidateCoord.equals2D(intersectionCoord)) && (h = h == 0 ? n - 1 : h - 1) != j);
        return counter;
    }

    public static Coordinate getIntersectionCoord(Geometry firstSegment, Geometry interSegment, Coordinate[] firstSegC) {
        Coordinate candidateCoord = null;
        if (firstSegment.intersects(interSegment)) {
            Geometry resultPoints = firstSegment.intersection(interSegment);
            int k = 0;
            while (k < resultPoints.getNumGeometries()) {
                Coordinate intersectionCoord = resultPoints.getGeometryN(k).getCoordinate();
                if (!firstSegC[1].equals2D(intersectionCoord) && !firstSegC[0].equals2D(intersectionCoord)) {
                    candidateCoord = new Coordinate(intersectionCoord);
                    break;
                }
                ++k;
            }
        }
        return candidateCoord;
    }
}

