/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.merge.internal.view;

import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.mediator.AppGISAdapter;
import eu.udig.tools.internal.mediator.PlatformGISMediator;
import eu.udig.tools.internal.ui.util.StatusBar;
import eu.udig.tools.merge.MergeContext;
import eu.udig.tools.merge.Util;
import eu.udig.tools.merge.internal.view.MergeComposite;
import eu.udig.tools.merge.internal.view.MergeFeatureBuilder;
import eu.udig.tools.merge.internal.view.MergeFeaturesCommand;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.IUDIGView;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.tools.edit.animation.MessageBubble;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class MergeView
extends ViewPart
implements IUDIGView {
    public static final String ID = "eu.udig.tools.merge.internal.view.MergeView";
    private MergeComposite mergeComposite = null;
    private CancelButtonAction cancelButton = null;
    private MergeButtonAction mergeButton = null;
    private MergeContext mergeContext = null;
    private String message;
    private boolean canMerge;
    private IMapCompositionListener mapListener = null;
    private ILayerListener layerListener = null;
    protected Thread uiThread;
    private boolean wasInitialized = false;
    private IToolContext context = null;
    private ILayer currEventTriggeringLayer = null;

    protected void initializeOperationModeSupport() {
        this.wasInitialized = false;
        this.uiThread = Thread.currentThread();
        this.initListeners();
        this.wasInitialized = true;
    }

    private void initListeners() {
        this.mapListener = new IMapCompositionListener(){

            public void changed(MapCompositionEvent event) {
                if (!MergeView.this.wasInitialized()) {
                    return;
                }
                MergeView.this.updatedMapLayersActions(event);
            }
        };
        this.layerListener = new ILayerListener(){

            public void refresh(LayerEvent event) {
                if (!MergeView.this.wasInitialized()) {
                    return;
                }
                MergeView.this.updateLayerActions(event);
            }
        };
    }

    private void addListenersTo(IMap map, List<ILayer> layerList) {
        assert (map != null);
        assert (layerList != null);
        if (MergeContext.getInstance().getMergeMode() == 2) {
            assert (this.mapListener != null);
            assert (this.layerListener != null);
        }
        map.addMapCompositionListener(this.mapListener);
        for (ILayer layer : layerList) {
            layer.addListener(this.layerListener);
        }
    }

    private void updatedMapLayersActions(final MapCompositionEvent event) {
        MapCompositionEvent.EventType eventType = event.getType();
        switch (eventType) {
            case ADDED: {
                Display.findDisplay((Thread)this.uiThread).asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ILayer layer = event.getLayer();
                        MergeView.this.addedLayerActions(layer);
                        System.out.print("Layer ADDED");
                    }
                });
                break;
            }
            case REMOVED: {
                Display.findDisplay((Thread)this.uiThread).asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ILayer layer = event.getLayer();
                        MergeView.this.removedLayerActions(layer);
                        System.out.print("Layer REMOVED");
                    }
                });
                break;
            }
            case MANY_REMOVED: 
            case MANY_ADDED: {
                Display.findDisplay((Thread)this.uiThread).asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.print("Layer MANY ADDED-REMOVED");
                    }
                });
                break;
            }
            default: {
                System.out.print("Layer DEFAULT");
            }
        }
    }

    private void updateLayerActions(final LayerEvent event) {
        final ILayer modifiedLayer = event.getSource();
        if (modifiedLayer == ApplicationGIS.getActiveMap().getEditManager().getSelectedLayer()) {
            this.currEventTriggeringLayer = modifiedLayer;
            PlatformGISMediator.syncInDisplayThread(new Runnable(){

                @Override
                public void run() {
                    LayerEvent.EventType type = event.getType();
                    switch (type) {
                        case ALL: {
                            MergeView.this.changedLayerActions(modifiedLayer);
                            break;
                        }
                        case FILTER: {
                            Filter newFilter = modifiedLayer.getFilter();
                            MergeView.this.changedFilterSelectionActions(modifiedLayer, newFilter);
                            break;
                        }
                    }
                }
            });
        }
    }

    protected void addedLayerActions(ILayer layer) {
        layer.addListener(this.layerListener);
    }

    protected void removedLayerActions(ILayer layer) {
        layer.removeListener(this.layerListener);
    }

    protected void changedFilterSelectionActions(ILayer layer, Filter newFilter) {
        List<SimpleFeature> selectedFeatures = null;
        try {
            selectedFeatures = Util.retrieveFeatures(newFilter, layer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (selectedFeatures != null) {
            this.addSourceFeatures(selectedFeatures);
            this.display();
        }
    }

    protected void changedLayerActions(ILayer modifiedLayer) {
    }

    public IMap getCurrentMap() {
        if (this.context == null) {
            return null;
        }
        return this.context.getMap();
    }

    private void removeListenerFrom(IMap map) {
        assert (map != null);
        assert (this.mapListener != null);
        assert (this.layerListener != null);
        for (ILayer layer : this.getCurrentLayerList()) {
            layer.removeListener(this.layerListener);
        }
        map.removeMapCompositionListener(this.mapListener);
    }

    protected List<ILayer> getLayerListOf(IMap map) {
        assert (map != null);
        return AppGISAdapter.getMapLayers(map);
    }

    protected List<ILayer> getCurrentLayerList() {
        if (this.getCurrentMap() == null) {
            return Collections.emptyList();
        }
        return AppGISAdapter.getMapLayers(this.getCurrentMap());
    }

    public boolean wasInitialized() {
        return !this.isDisposed() && this.wasInitialized;
    }

    public boolean isOperationMode() {
        boolean isOpMode = MergeContext.getInstance().getMergeMode() == 2;
        return isOpMode;
    }

    public ILayer getCurrentEventTriggeringLayer() {
        return this.currEventTriggeringLayer;
    }

    private void addPreSelectedFeatures() {
        MergeContext mergeContextSingleton = MergeContext.getInstance();
        List<SimpleFeature> selectedFeatures = mergeContextSingleton.getPreselectedFeatures();
        this.currEventTriggeringLayer = mergeContextSingleton.getPreSelectedLayer();
        if (selectedFeatures != null) {
            this.addSourceFeatures(selectedFeatures);
            mergeContextSingleton.clearPreselectedFeatures();
            this.display();
        }
    }

    public void createPartControl(Composite parent) {
        this.mergeComposite = new MergeComposite(parent, 0);
        this.mergeComposite.setView(this);
        this.createActions();
        this.createToolbar();
        if (this.isOperationMode()) {
            this.initializeOperationModeSupport();
            this.addPreSelectedFeatures();
        }
    }

    private void createToolbar() {
        IToolBarManager toolbar = this.getViewSite().getActionBars().getToolBarManager();
        toolbar.add((IAction)this.mergeButton);
        toolbar.add((IAction)this.cancelButton);
    }

    private void createActions() {
        this.mergeButton = new MergeButtonAction();
        this.cancelButton = new CancelButtonAction();
    }

    private void close() {
        try {
            ApplicationGIS.getView((boolean)false, (String)ID);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart viewPart = page.findView(ID);
            page.hideView(viewPart);
        }
        finally {
            IToolContext context = this.getContext();
            if (context != null) {
                UndoableMapCommand clearSelectionCommand = context.getSelectionFactory().createNoSelectCommand();
                context.sendASyncCommand((Command)clearSelectionCommand);
            }
        }
    }

    public void setFocus() {
    }

    public void setBuilder(MergeFeatureBuilder builder) {
        throw new UnsupportedOperationException();
    }

    protected void canMerge(boolean bValue) {
        this.canMerge = bValue;
        this.mergeButton.setEnabled(this.canMerge);
    }

    private void handleError(IToolContext context, MapMouseEvent e) {
        AnimationUpdater.runTimer((IMapDisplay)context.getMapDisplay(), (IAnimation)new MessageBubble(e.x, e.y, this.message, PreferenceUtil.instance().getMessageDisplayDelay()));
    }

    public void addSourceFeatures(List<SimpleFeature> sourceFeatures) {
        assert (sourceFeatures != null);
        this.mergeComposite.addSourceFeatures(sourceFeatures);
    }

    public void display() {
        this.mergeComposite.display();
    }

    public void dispose() {
        if (this.mergeContext != null) {
            this.mergeContext.disposeMergeView();
        }
        super.dispose();
    }

    public void editFeatureChanged(SimpleFeature feature) {
    }

    public void setContext(IToolContext newContext) {
        if (newContext == null) {
            IMap map = this.getCurrentMap();
            if (map != null) {
                this.removeListenerFrom(map);
            }
        } else {
            IMap map = newContext.getMap();
            if (MergeContext.getInstance().getMergeMode() == 2 && map != null) {
                List<ILayer> layerList = this.getLayerListOf(map);
                this.addListenersTo(map, layerList);
            }
        }
        this.context = newContext;
    }

    public IToolContext getContext() {
        if (this.mergeContext == null) {
            return null;
        }
        IToolContext itc = this.mergeContext.getToolContext();
        return itc;
    }

    public void setMergeContext(MergeContext mergeContext) {
        this.mergeContext = mergeContext;
    }

    public boolean isDisposed() {
        return this.mergeComposite.isDisposed();
    }

    private class CancelButtonAction
    extends Action {
        public CancelButtonAction() {
            this.setToolTipText(Messages.MergeView_cancel_tool_tip);
            String imgFile = "images/reset_co.gif";
            this.setImageDescriptor(ImageDescriptor.createFromFile(MergeView.class, (String)imgFile));
        }

        public void run() {
            MergeView.this.close();
        }
    }

    private class MergeButtonAction
    extends Action {
        public MergeButtonAction() {
            this.setToolTipText(Messages.MergeView_finish_tool_tip);
            String imgFile = "images/apply_co.gif";
            this.setImageDescriptor(ImageDescriptor.createFromFile(MergeView.class, (String)imgFile));
        }

        public void run() {
            ILayer layer = null;
            if (MergeContext.getInstance().getMergeMode() == 1) {
                IToolContext context = MergeView.this.getContext();
                layer = context.getSelectedLayer();
            } else if (MergeContext.getInstance().getMergeMode() == 2) {
                layer = ApplicationGIS.getActiveMap().getEditManager().getSelectedLayer();
            }
            MergeFeatureBuilder mergeBuilder = MergeView.this.mergeComposite.getMergeBuilder();
            List<SimpleFeature> sourceFeatures = mergeBuilder.getSourceFeatures();
            SimpleFeatureCollection sourceFeaturesCollection = DataUtilities.collection(sourceFeatures);
            SimpleFeature mergedFeature = mergeBuilder.buildMergedFeature();
            mergeBuilder.removeFromSourceFeatures(sourceFeatures);
            MergeFeaturesCommand cmd = MergeFeaturesCommand.getInstance(layer, (FeatureCollection<SimpleFeatureType, SimpleFeature>)sourceFeaturesCollection, mergedFeature);
            MergeView.this.context.getMap().sendCommandASync((MapCommand)cmd);
            StatusBar.setStatusBarMessage(MergeView.this.context, Messages.MergeTool_successful);
            MergeView.this.context.getViewportPane().repaint();
            MergeView.this.close();
        }
    }
}

