/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.merge.internal.view;

import java.util.LinkedList;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.internal.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

final class MergeFeaturesCommand
implements UndoableMapCommand {
    private UndoableComposite compositeCmd = null;

    public static MergeFeaturesCommand getInstance(ILayer layer, FeatureCollection<SimpleFeatureType, SimpleFeature> sourceFeatures, SimpleFeature mergedFeature) {
        return new MergeFeaturesCommand(layer, sourceFeatures, mergedFeature);
    }

    private MergeFeaturesCommand(ILayer layer, FeatureCollection<SimpleFeatureType, SimpleFeature> sourceFeatures, SimpleFeature mergedFeature) {
        assert (layer != null);
        assert (sourceFeatures != null);
        assert (mergedFeature != null);
        EditCommandFactory cmdFactory = EditCommandFactory.getInstance();
        IMap map = layer.getMap();
        LinkedList<UndoableMapCommand> cmdList = new LinkedList<UndoableMapCommand>();
        FeatureIterator iter = sourceFeatures.features();
        while (iter.hasNext()) {
            SimpleFeature feature = (SimpleFeature)iter.next();
            UndoableMapCommand deleteCmd = cmdFactory.createDeleteFeature(feature, layer);
            deleteCmd.setMap(map);
            cmdList.add(deleteCmd);
        }
        iter.close();
        UndoableMapCommand addCmd = cmdFactory.createAddFeatureCommand(mergedFeature, layer);
        addCmd.setMap(map);
        cmdList.add(addCmd);
        assert (cmdList.size() >= 3);
        this.compositeCmd = new UndoableComposite(cmdList);
    }

    public void rollback(IProgressMonitor monitor) throws Exception {
        this.compositeCmd.rollback(monitor);
    }

    public MapCommand copy() {
        return this.compositeCmd.copy();
    }

    public String getName() {
        return "Merge Features Command";
    }

    public void setMap(IMap map) {
        this.compositeCmd.setMap(map);
    }

    public Map getMap() {
        return this.compositeCmd.getMap();
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.compositeCmd.run(monitor);
    }
}

