/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.merge.internal.view;

import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.ui.util.InfoMessage;
import eu.udig.tools.internal.ui.util.LayerUtil;
import eu.udig.tools.merge.MergeContext;
import eu.udig.tools.merge.internal.view.MergeFeatureBuilder;
import eu.udig.tools.merge.internal.view.MergeView;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

class MergeComposite
extends Composite {
    private SashForm sashForm = null;
    private Composite compositeSourceFeatures = null;
    private CLabel cLabelSources = null;
    private Tree treeFeatures = null;
    private Composite compositeMergeFeature = null;
    private CLabel cLabelTarget = null;
    private Table tableMergeFeature = null;
    private Composite compositeMergeControls = null;
    private Label labelResult = null;
    private Label labelResultGeometry = null;
    private ViewForm viewForm = null;
    private Composite infoComposite = null;
    private String message = null;
    private CLabel messageTitle = null;
    private ImageRegistry registry = null;
    private Button trashButton = null;
    private MergeView mergeView = null;
    private Menu menu;
    private MergeFeatureBuilder mergeBuilder = null;
    private static final String UNION = "Union";
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final String NULL_LABEL = "<null>";
    private CLabel messagePanel;

    public MergeComposite(Composite parent, int style) {
        super(parent, style);
        this.createContent();
    }

    private void createContent() {
        this.setLayout((Layout)new FillLayout());
        this.viewForm = new ViewForm((Composite)this, 0);
        this.viewForm.setLayout((Layout)new FillLayout());
        this.infoComposite = new Composite((Composite)this.viewForm, 0);
        this.createCompositeInformation();
        this.viewForm.setTopLeft((Control)this.infoComposite);
        this.sashForm = new SashForm((Composite)this.viewForm, 512);
        this.sashForm.setOrientation(256);
        this.sashForm.setLayout((Layout)new FillLayout());
        this.createCompositeSourceFeatures();
        this.createCompositeMergeFeature();
        this.createContextMenu();
        this.viewForm.setContent((Control)this.sashForm);
    }

    private void createCompositeInformation() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        this.infoComposite.setLayout((Layout)gridLayout1);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 4;
        this.messageTitle = new CLabel(this.infoComposite, 1);
        this.messageTitle.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        this.messagePanel = new CLabel(this.infoComposite, 0);
        this.messagePanel.setLayoutData((Object)gridData2);
    }

    private void createCompositeMergeFeature() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 1;
        gridLayout1.makeColumnsEqualWidth = true;
        this.compositeMergeFeature = new Composite((Composite)this.sashForm, 2048);
        this.compositeMergeFeature.setLayout((Layout)gridLayout1);
        this.cLabelTarget = new CLabel(this.compositeMergeFeature, 0);
        this.cLabelTarget.setText(Messages.MergeFeaturesComposite_merge_feature);
        this.tableMergeFeature = new Table(this.compositeMergeFeature, 2);
        this.tableMergeFeature.setHeaderVisible(true);
        this.tableMergeFeature.setLayoutData((Object)gridData);
        this.tableMergeFeature.setLinesVisible(true);
        this.createCompositeMergeControls();
        TableColumn tableColumnName = new TableColumn(this.tableMergeFeature, 0);
        tableColumnName.setWidth(150);
        tableColumnName.setText(Messages.MergeFeaturesComposite_property);
        TableColumn tableColumnValue = new TableColumn(this.tableMergeFeature, 0);
        tableColumnValue.setWidth(60);
        tableColumnValue.setText(Messages.MergeFeaturesComposite_value);
    }

    private void createCompositeMergeControls() {
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.compositeMergeControls = new Composite(this.compositeMergeFeature, 0);
        this.compositeMergeControls.setLayout((Layout)gridLayout);
        this.compositeMergeControls.setLayoutData((Object)gridData1);
        this.labelResult = new Label(this.compositeMergeControls, 0);
        this.labelResult.setText(Messages.MergeFeaturesComposite_result_geometry);
        this.labelResult.setLayoutData((Object)gridData2);
        this.labelResultGeometry = new Label(this.compositeMergeControls, 0);
        this.labelResultGeometry.setText(Messages.MergeFeaturesComposite_result);
        this.labelResultGeometry.setLayoutData((Object)gridData3);
    }

    private void createCompositeSourceFeatures() {
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.horizontalSpan = 2;
        gridData4.verticalAlignment = 4;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = false;
        gridData3.grabExcessVerticalSpace = false;
        gridData3.verticalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 3;
        gridData2.grabExcessHorizontalSpace = false;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.verticalAlignment = 3;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.makeColumnsEqualWidth = true;
        this.compositeSourceFeatures = new Composite((Composite)this.sashForm, 2048);
        this.compositeSourceFeatures.setLayout((Layout)gridLayout2);
        this.cLabelSources = new CLabel(this.compositeSourceFeatures, 0);
        this.cLabelSources.setText(Messages.MergeFeaturesComposite_source);
        this.cLabelSources.setLayoutData((Object)gridData3);
        this.createImageRegistry();
        this.trashButton = new Button(this.compositeSourceFeatures, 0);
        this.trashButton.setLayoutData((Object)gridData2);
        this.trashButton.setToolTipText(Messages.MergeView_remove_tool_tip);
        this.trashButton.setImage(this.getImage());
        this.trashButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                MergeComposite.this.deleteSourceFeatures();
            }
        });
        this.treeFeatures = new Tree(this.compositeSourceFeatures, 36);
        this.treeFeatures.setHeaderVisible(true);
        this.treeFeatures.setLayoutData((Object)gridData4);
        this.treeFeatures.setLinesVisible(true);
        this.treeFeatures.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    MergeComposite.this.handleTreeEvent(event);
                }
            }
        });
        this.treeFeatures.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MergeContext mergeContextSingleton = MergeContext.getInstance();
                if (mergeContextSingleton.getMergeMode() == 1) {
                    MergeComposite.this.handleTreeEventClick(e);
                }
            }
        });
        this.treeFeatures.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    MergeComposite.this.showContextMenu(e);
                }
            }
        });
        TreeColumn treeColumnFeature = new TreeColumn(this.treeFeatures, 0);
        treeColumnFeature.setWidth(150);
        treeColumnFeature.setText(Messages.MergeFeaturesComposite_feature);
        TreeColumn treeColumnValue = new TreeColumn(this.treeFeatures, 0);
        treeColumnValue.setWidth(60);
        treeColumnValue.setText(Messages.MergeFeaturesComposite_value);
    }

    private void deleteSourceFeatures() {
        TreeItem[] items = this.treeFeatures.getSelection();
        int i = 0;
        while (i < items.length) {
            String id = items[i].getText();
            List<SimpleFeature> sourceFeatures = this.mergeBuilder.getSourceFeatures();
            for (SimpleFeature feature : sourceFeatures) {
                if (!feature.getID().equals(id)) continue;
                this.mergeBuilder.removeFromSourceFeatures(feature);
                this.unselect(feature);
                break;
            }
            items[i].dispose();
            ++i;
        }
        this.changed();
    }

    private void unselect(SimpleFeature unselectedFeature) {
        IToolContext context = this.mergeView.getContext();
        UndoableMapCommand unselectCommand = context.getSelectionFactory().createNoSelectCommand();
        context.sendASyncCommand((Command)unselectCommand);
    }

    private void createContextMenu() {
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        this.menu = contextMenu.createContextMenu((Control)this.compositeSourceFeatures);
    }

    private Image getImage() {
        return this.registry.get("trash");
    }

    private void createImageRegistry() {
        this.registry = new ImageRegistry();
        String imgFile = "images/trash.gif";
        this.registry.put("trash", ImageDescriptor.createFromFile(MergeComposite.class, (String)imgFile));
    }

    public void display(List<SimpleFeature> selectedFeatures, ILayer layer) {
        this.addSourceFeatures(selectedFeatures);
        this.display();
    }

    public void display() {
        this.mergeBuilder = this.getMergeBuilder();
        this.populateSourceFeaturesView();
        this.populateMergeFeatureView();
        this.changed();
    }

    private void mergeGeometryChanged(MergeFeatureBuilder builder) {
        String geomName = builder.getPrittyMergeGeometry();
        if (builder.isGeometriesUnion()) {
            this.labelResultGeometry.setText(UNION);
        } else {
            this.labelResultGeometry.setText(geomName.toString());
        }
        String msg = MessageFormat.format(Messages.MergeFeaturesComposite_result_will_be, geomName);
        this.setMessage(msg, InfoMessage.Type.INFORMATION);
    }

    public void setMessage(String usrMessage, InfoMessage.Type type) {
        InfoMessage info = new InfoMessage(usrMessage, type);
        this.messagePanel.setImage(info.getImage());
        this.messagePanel.setText(info.getText());
        this.messageTitle.setText(Messages.MergeFeaturesComposite_merge_result_title);
    }

    private void handleTreeEvent(Event event) {
        TreeItem item = (TreeItem)event.item;
        boolean isFeatureItem = this.isFeatureItem(item);
        boolean checked = item.getChecked();
        if (isFeatureItem) {
            int featureIndex = (Integer)item.getData();
            this.setSelectedFeature(featureIndex, checked);
        } else {
            TreeItem featureItem = item.getParentItem();
            int featureIndex = (Integer)featureItem.getData();
            int attributeIndex = (Integer)item.getData();
            this.selectAttributePropagate(featureIndex, attributeIndex, checked);
            this.setAttributeValue(featureIndex, attributeIndex, checked);
        }
    }

    private void handleTreeEventClick(SelectionEvent event) {
        Object obj;
        TreeItem item = (TreeItem)event.item;
        boolean isFeatureItem = this.isFeatureItem(item);
        if (isFeatureItem && (obj = item.getData()) instanceof Integer) {
            ILayer layer = this.mergeBuilder.getLayer();
            Filter filter = this.getSelectedFeatureFilter((Integer)obj);
            LayerUtil.presentSelection(layer, filter);
        }
    }

    private Filter getSelectedFeatureFilter(Integer index) {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String id = this.mergeBuilder.getFeature(index).getID();
        FeatureId fid = ff.featureId(id);
        HashSet<FeatureId> ids = new HashSet<FeatureId>(1);
        ids.add(fid);
        Id filter = ff.id(ids);
        return filter;
    }

    private void showContextMenu(MouseEvent e) {
        Tree tree = (Tree)e.getSource();
        TreeItem selection = tree.getSelection()[0];
        boolean isFather = this.isFeatureItem(selection);
        if (isFather) {
            this.menu.setVisible(true);
        }
    }

    private void changed() {
        this.updateMergePanel();
        this.updateCommandButtonStatus();
    }

    private void updateMergePanel() {
        List<SimpleFeature> sourceFeatures = this.mergeBuilder.getSourceFeatures();
        if (sourceFeatures.size() == 0) {
            this.tableMergeFeature.removeAll();
        } else {
            int attributeCount = this.mergeBuilder.getAttributeCount();
            int attIndex = 0;
            while (attIndex < attributeCount) {
                Object mergeFeatureProperty;
                TableItem attrItem = this.tableMergeFeature.getItem(attIndex);
                String strValue = attIndex == this.mergeBuilder.getDefaultGeometryIndex() ? this.mergeBuilder.getPrittyMergeGeometry() : ((mergeFeatureProperty = this.mergeBuilder.getMergeAttribute(attIndex)) == null ? NULL_LABEL : String.valueOf(mergeFeatureProperty));
                attrItem.setText(1, strValue);
                ++attIndex;
            }
        }
    }

    private void updateCommandButtonStatus() {
        this.canMerge();
        this.canDelete();
    }

    private void canDelete() {
        this.trashButton.setEnabled(!this.mergeBuilder.getSourceFeatures().isEmpty());
    }

    private void setAttributeValue(int sourceFeatureIndex, int attributeIndex, boolean setValue) {
        if (setValue) {
            this.mergeBuilder.copyAttributeToMerge(sourceFeatureIndex, attributeIndex);
        } else {
            this.mergeBuilder.clearMergeAttribute(attributeIndex);
        }
    }

    private void setSelectedFeature(int featureIndex, boolean checked) {
        int numFeatures = this.mergeBuilder.getFeatureCount();
        int numAttributes = this.mergeBuilder.getAttributeCount();
        TreeItem[] featureItems = this.treeFeatures.getItems();
        assert (numFeatures == featureItems.length);
        int currFeatureIdx = 0;
        while (currFeatureIdx < numFeatures) {
            TreeItem featureItem = featureItems[currFeatureIdx];
            boolean checkIt = checked && currFeatureIdx == featureIndex;
            featureItem.setChecked(checkIt);
            int attIdx = 0;
            while (attIdx < numAttributes) {
                this.selectAttribute(currFeatureIdx, attIdx, checkIt);
                if (currFeatureIdx == featureIndex) {
                    this.setAttributeValue(featureIndex, attIdx, checkIt);
                }
                ++attIdx;
            }
            ++currFeatureIdx;
        }
    }

    private void selectAttribute(int featureIndex, int attributeIndex, boolean checked) {
        TreeItem featureItem = this.treeFeatures.getItem(featureIndex);
        TreeItem attItem = featureItem.getItem(attributeIndex);
        attItem.setChecked(checked);
    }

    private void selectAttributePropagate(int featureIndex, int attributeIndex, boolean checked) {
        int numFeatures = this.mergeBuilder.getFeatureCount();
        int currFIndex = 0;
        while (currFIndex < numFeatures) {
            boolean checkIt = checked && currFIndex == featureIndex;
            this.selectAttribute(currFIndex, attributeIndex, checkIt);
            ++currFIndex;
        }
    }

    private boolean isFeatureItem(TreeItem item) {
        Object itemData = item.getData();
        boolean isFeatureItem = item.getItemCount() > 0;
        isFeatureItem = isFeatureItem && itemData instanceof Integer;
        return isFeatureItem;
    }

    private void populateSourceFeaturesView() {
        this.treeFeatures.removeAll();
        int featureCount = this.mergeBuilder.getFeatureCount();
        int featureIndex = 0;
        while (featureIndex < featureCount) {
            TreeItem featureItem = new TreeItem(this.treeFeatures, 0);
            featureItem.setData((Object)featureIndex);
            featureItem.setText(this.mergeBuilder.getID(featureIndex));
            int geometryIndex = this.mergeBuilder.getDefaultGeometryIndex();
            boolean isFisrtFeature = featureIndex == 0;
            int attIndex = 0;
            while (attIndex < this.mergeBuilder.getAttributeCount()) {
                TreeItem attrItem = new TreeItem(featureItem, 0);
                String attrName = this.mergeBuilder.getAttributeName(attIndex);
                attrItem.setText(0, attrName);
                attrItem.setData((Object)attIndex);
                Object attrValue = this.mergeBuilder.getAttribute(featureIndex, attIndex);
                String strValue = attrValue == null ? NULL_LABEL : String.valueOf(attrValue);
                attrItem.setText(1, strValue);
                if (isFisrtFeature && attIndex == geometryIndex) {
                    attrItem.setChecked(!this.mergeBuilder.isGeometriesUnion());
                } else {
                    attrItem.setChecked(isFisrtFeature);
                }
                ++attIndex;
            }
            featureItem.setExpanded(isFisrtFeature);
            ++featureIndex;
        }
    }

    private void displaySourceFeature(SimpleFeature feature) {
        this.setMessage("", InfoMessage.Type.NULL);
        MergeFeatureBuilder builder = this.getMergeBuilder();
        if (!builder.canMerge(feature)) {
            this.message = Messages.MergeFeatureBehaviour_must_intersect;
            this.setMessage(this.message, InfoMessage.Type.WARNING);
            return;
        }
        int position = this.mergeBuilder.addSourceFeature(feature);
        if (position == -1) {
            return;
        }
        TreeItem featureItem = new TreeItem(this.treeFeatures, 0);
        featureItem.setData((Object)position);
        featureItem.setText(builder.getID(position));
        int attIndex = 0;
        while (attIndex < builder.getAttributeCount()) {
            TreeItem attrItem = new TreeItem(featureItem, 0);
            String attrName = builder.getAttributeName(attIndex);
            attrItem.setText(0, attrName);
            attrItem.setData((Object)attIndex);
            Object attrValue = builder.getAttribute(position, attIndex);
            String strValue = attrValue == null ? NULL_LABEL : String.valueOf(attrValue);
            attrItem.setText(1, strValue);
            ++attIndex;
        }
        featureItem.setExpanded(true);
    }

    private void populateMergeFeatureView() {
        this.tableMergeFeature.removeAll();
        int attributeCount = this.mergeBuilder.getAttributeCount();
        int attIndex = 0;
        while (attIndex < attributeCount) {
            TableItem attrItem = new TableItem(this.tableMergeFeature, 0);
            attrItem.setData((Object)attIndex);
            String attrName = this.mergeBuilder.getAttributeName(attIndex);
            attrItem.setText(0, attrName);
            ++attIndex;
        }
    }

    public void setView(MergeView mergeView) {
        this.mergeView = mergeView;
    }

    public void addSourceFeatures(List<SimpleFeature> featureList) {
        if (MergeContext.getInstance().getMergeMode() == 2) {
            this.mergeBuilder = this.getMergeBuilder();
            this.mergeBuilder.removeFromSourceFeaturesAll();
        }
        for (SimpleFeature feature : featureList) {
            this.displaySourceFeature(feature);
        }
    }

    public void addSourceFeature(SimpleFeature newFeature) {
        this.displaySourceFeature(newFeature);
    }

    private boolean canMerge() {
        boolean valid = true;
        if (this.mergeBuilder.getSourceFeatures().size() < 2) {
            this.message = Messages.MergeFeatureBehaviour_select_two_or_more;
            this.setMessage(this.message, InfoMessage.Type.WARNING);
            valid = false;
        }
        this.mergeView.canMerge(valid);
        return valid;
    }

    public MergeFeatureBuilder getMergeBuilder() {
        if (this.mergeBuilder != null) {
            return this.mergeBuilder;
        }
        this.mergeBuilder = this.mergeView.isOperationMode() ? new MergeFeatureBuilder(this.mergeView.getCurrentEventTriggeringLayer()) : new MergeFeatureBuilder(this.mergeView.getContext().getSelectedLayer());
        this.mergeBuilder.addChangeListener(new MergeFeatureBuilder.ChangeListener(){

            @Override
            public void attributeChanged(MergeFeatureBuilder builder, int attributeIndex, Object oldValue) {
                if (attributeIndex == builder.getDefaultGeometryIndex()) {
                    MergeComposite.this.mergeGeometryChanged(builder);
                }
                MergeComposite.this.changed();
            }
        });
        return this.mergeBuilder;
    }
}

