/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.merge;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import eu.udig.tools.internal.i18n.Messages;
import eu.udig.tools.internal.ui.util.StatusBar;
import eu.udig.tools.merge.MergeContext;
import eu.udig.tools.merge.Util;
import eu.udig.tools.merge.internal.view.MergeView;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.commands.selection.BBoxSelectionCommand;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.commands.SelectionBoxCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.ModalTool;
import net.refractions.udig.project.ui.tool.SimpleTool;
import net.refractions.udig.tools.edit.animation.MessageBubble;
import net.refractions.udig.tools.edit.preferences.PreferenceUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class MergeTool
extends SimpleTool
implements ModalTool {
    public static final String ID = "eu.udig.tools.merge.MergeTool";
    private static final Logger LOGGER = Logger.getLogger(MergeTool.class.getName());
    private MergeContext mergeContext;
    private SelectionBoxCommand selectionBoxCommand = null;

    public MergeTool() {
        super(3);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.mergeContext = MergeContext.getInstance();
            this.mergeContext.setToolContext(this.getContext());
            if (this.mergeContext.getMergeMode() == 2) {
                this.closeMergeView();
            }
            this.mergeContext.setMergeMode(1);
            StatusBar.setStatusBarMessage(this.mergeContext.getToolContext(), "");
            if (this.mergeContext.getToolContext().getMapLayers().size() > 0) {
                String message = Messages.MergeTool_select_features_to_merge;
                StatusBar.setStatusBarMessage(this.mergeContext.getToolContext(), message);
            } else {
                String message = "The current Map has no layers. The tool cannot operate.";
                StatusBar.setStatusBarMessage(this.mergeContext.getToolContext(), message);
            }
        } else {
            if (this.mergeContext.isMergeViewActive()) {
                this.closeMergeView();
            }
            this.mergeContext = null;
        }
    }

    private void closeMergeView() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                ApplicationGIS.getView((boolean)false, (String)"eu.udig.tools.merge.internal.view.MergeView");
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewPart viewPart = page.findView("eu.udig.tools.merge.internal.view.MergeView");
                page.hideView(viewPart);
                MergeTool.this.mergeContext.disposeMergeView();
            }
        });
    }

    protected void onMousePressed(MapMouseEvent e) {
        if (!this.isActive()) {
            return;
        }
        if (e.button != 8) {
            return;
        }
        this.selectionBoxCommand = new SelectionBoxCommand();
        Point start = e.getPoint();
        this.mergeContext.setBBoxStartPoint(start);
        this.selectionBoxCommand.setValid(true);
        this.selectionBoxCommand.setShape((Shape)new Rectangle(start.x, start.y, 0, 0));
        this.context.sendASyncCommand((Command)this.selectionBoxCommand);
    }

    protected void onMouseDragged(MapMouseEvent e) {
        if (!this.isActive()) {
            return;
        }
        Point start = this.mergeContext.getBBoxStartPoint();
        if (start == null) {
            start = e.getPoint();
        }
        this.selectionBoxCommand.setShape((Shape)new Rectangle(Math.min(start.x, e.x), Math.min(start.y, e.y), Math.abs(e.x - start.x), Math.abs(start.y - e.y)));
        this.context.getViewportPane().repaint();
    }

    private void removeBBox(Point start, Point end) {
        int x1 = Math.min(start.x, end.x);
        int y1 = Math.min(start.y, end.y);
        int x2 = Math.abs(end.x - start.x);
        int y2 = Math.abs(start.y - end.y);
        Coordinate c1 = this.context.getMap().getViewportModel().pixelToWorld(x1, y1);
        Coordinate c2 = this.context.getMap().getViewportModel().pixelToWorld(x2, y2);
        Envelope bounds = new Envelope(c1, c2);
        BBoxSelectionCommand cmd = new BBoxSelectionCommand(bounds, 0);
        this.getContext().sendASyncCommand((Command)cmd);
        this.selectionBoxCommand.setValid(false);
        this.getContext().getViewportPane().repaint();
    }

    protected void onMouseReleased(MapMouseEvent mouseEvent) {
        if (!this.isActive()) {
            return;
        }
        if (mouseEvent.button != 8) {
            return;
        }
        Point start = this.mergeContext.getBBoxStartPoint();
        if (!this.mergeContext.isMergeViewActive()) {
            this.openMergeView(mouseEvent.x, mouseEvent.y, this.mergeContext);
        }
        MergeView mergeView = this.mergeContext.getMergeView();
        assert (mergeView != null);
        ILayer selectedLayer = this.getContext().getSelectedLayer();
        if (!start.equals(mouseEvent.getPoint())) {
            this.removeBBox(start, mouseEvent.getPoint());
            this.displayFeaturesUnderBBox(mouseEvent.getPoint(), selectedLayer, mergeView);
        } else if (start.equals(mouseEvent.getPoint()) && !mouseEvent.isControlDown()) {
            this.displayFeatureOnView(mouseEvent, selectedLayer, mergeView);
        }
    }

    private void displayFeatureOnView(MapMouseEvent e, ILayer selectedLayer, MergeView mergeView) {
        Envelope bound = this.buildBoundForPoint(e.getPoint());
        Filter filterSelectedFeatures = this.selectFeaturesUnderBBox(bound, 0);
        try {
            List<SimpleFeature> selectedFeatures = Util.retrieveFeatures(filterSelectedFeatures, selectedLayer);
            mergeView.addSourceFeatures(selectedFeatures);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private Envelope buildBoundForPoint(Point p) {
        return this.getContext().getBoundingBox(p, 3);
    }

    private void displayFeaturesUnderBBox(Point xyMouse, ILayer selectedLayer, MergeView mergeView) {
        Coordinate endPoint;
        IViewportModel viewportModel = this.getContext().getMap().getViewportModel();
        Coordinate startPoint = viewportModel.pixelToWorld(this.mergeContext.getBBoxStartPoint().x, this.mergeContext.getBBoxStartPoint().y);
        Object bound = startPoint.equals2D(endPoint = viewportModel.pixelToWorld(xyMouse.x, xyMouse.y)) ? this.getContext().getBoundingBox(xyMouse, 3) : new Envelope(startPoint, endPoint);
        try {
            Filter filterSelectedFeatures = this.selectFeaturesUnderBBox((Envelope)bound, 0);
            List<SimpleFeature> selectedFeatures = Util.retrieveFeatures(filterSelectedFeatures, selectedLayer);
            mergeView.addSourceFeatures(selectedFeatures);
            mergeView.display();
        }
        catch (IOException e1) {
            LOGGER.warning(e1.getMessage());
            return;
        }
    }

    private void openMergeView(int eventX, int eventY, MergeContext mergeContext) {
        try {
            MergeView view = (MergeView)ApplicationGIS.getView((boolean)true, (String)"eu.udig.tools.merge.internal.view.MergeView");
            if (view == null) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                view = (MergeView)page.findView("eu.udig.tools.merge.internal.view.MergeView");
            }
            assert (view != null) : "view is null";
            view.setMergeContext(mergeContext);
            mergeContext.activeMergeView(view);
        }
        catch (Exception exception) {
            AnimationUpdater.runTimer((IMapDisplay)this.getContext().getMapDisplay(), (IAnimation)new MessageBubble(eventX, eventY, "It cannot be merge", PreferenceUtil.instance().getMessageDisplayDelay()));
        }
    }

    private Filter selectFeaturesUnderBBox(Envelope boundDrawn, int SelectionType) {
        this.mergeContext.addBound(boundDrawn);
        UndoableMapCommand command = this.context.getSelectionFactory().createBBoxSelectionCommand(boundDrawn, SelectionType);
        this.getContext().sendSyncCommand((Command)command);
        this.getContext().getViewportPane().repaint();
        Filter filterSelectedFeatures = this.getContext().getSelectedLayer().getFilter();
        return filterSelectedFeatures;
    }
}

