/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.internal.ui.util;

import eu.udig.tools.internal.mediator.AppGISAdapter;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.render.IViewportModel;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public final class MapUtil {
    private MapUtil() {
    }

    public static CoordinateReferenceSystem getCRS(IMap map) {
        assert (map != null);
        IViewportModel viewportModel = map.getViewportModel();
        CoordinateReferenceSystem mapCrs = viewportModel.getCRS();
        return mapCrs;
    }

    public static ILayer addLayerToMap(IMap map, IGeoResource geoResource) {
        int index = map.getMapLayers().size();
        List<? extends ILayer> listLayer = AppGISAdapter.addLayersToMap(map, Collections.singletonList(geoResource), index);
        assert (listLayer.size() == 1);
        ILayer layer = listLayer.get(0);
        return layer;
    }

    public static ILayer getSelectedLayer(IMap map) {
        if (map == null) {
            return null;
        }
        ILayer layer = map.getEditManager().getSelectedLayer();
        return layer;
    }
}

