/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.internal.ui.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;

public final class InfoMessage {
    public static final InfoMessage NULL = new InfoMessage("", Type.NULL);
    private String text;
    private Type type;

    public InfoMessage() {
    }

    public InfoMessage(String text, Type type) {
        assert (text != null);
        assert (type != null);
        this.text = text;
        this.type = type;
    }

    public InfoMessage(String text, int type) {
        assert (text != null);
        this.text = text;
        switch (type) {
            case 1: {
                this.type = Type.INFORMATION;
                break;
            }
            case 3: {
                this.type = Type.ERROR;
                break;
            }
            case 0: {
                this.type = Type.NULL;
                break;
            }
            case 2: {
                this.type = Type.WARNING;
            }
        }
    }

    public void setText(String text) {
        assert (text != null);
        this.text = text;
    }

    public void setType(Type type) {
        assert (type != null);
        this.type = type;
    }

    public String toString() {
        return this.text;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfoMessage other = (InfoMessage)obj;
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return this.type == other.type;
    }

    public final String getText() {
        return this.text;
    }

    public final Type getType() {
        return this.type;
    }

    public final Image getImage() {
        Image image = null;
        switch (this.type) {
            case FAIL: {
                image = JFaceResources.getImage((String)"dialog_message_error_image");
                break;
            }
            case INFORMATION: 
            case IMPORTANT_INFO: {
                image = JFaceResources.getImage((String)"dialog_messasge_info_image");
                break;
            }
            case WARNING: {
                image = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                break;
            }
            case ERROR: {
                image = JFaceResources.getImage((String)"dialog_message_error_image");
                break;
            }
            case NULL: {
                image = null;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return image;
    }

    public static enum Type {
        INFORMATION,
        IMPORTANT_INFO,
        WARNING,
        ERROR,
        FAIL,
        NULL;

    }
}

