/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.trim;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Point;
import eu.udig.tools.internal.i18n.Messages;
import java.text.MessageFormat;

public class TrimGeometryStrategy {
    private LineString trimmingLine;

    public TrimGeometryStrategy(LineString trimmingLine) {
        this.trimmingLine = trimmingLine;
    }

    public static Geometry trim(Geometry input, LineString trimmingLine) {
        TrimGeometryStrategy op = new TrimGeometryStrategy(trimmingLine);
        Geometry trimmed = op.trim(input);
        return trimmed;
    }

    public Geometry trim(Geometry original) {
        LineString trimmed;
        if (original == null || original.isEmpty()) {
            return original;
        }
        if (original instanceof LineString) {
            trimmed = this.trimLine((LineString)original, this.trimmingLine);
        } else if (original instanceof MultiLineString) {
            MultiLineString input = (MultiLineString)original;
            GeometryFactory gf = input.getFactory();
            int numGeometries = input.getNumGeometries();
            LineString[] lines = new LineString[numGeometries];
            int i = 0;
            while (i < numGeometries) {
                LineString trimmedPart;
                LineString part = (LineString)input.getGeometryN(i);
                lines[i] = trimmedPart = this.trimLine(part, this.trimmingLine);
                ++i;
            }
            trimmed = gf.createMultiLineString(lines);
        } else {
            throw new IllegalArgumentException(Messages.TrimGeometryStrategy_defined_for_line_geometries);
        }
        return trimmed;
    }

    private LineString trimLine(LineString original, LineString trimmingLine) throws IllegalArgumentException {
        int firstLineOrientation;
        LineString splitLine2;
        LineString splitLine1;
        Coordinate lineFrom;
        Geometry intersectGeom = original.intersection((Geometry)trimmingLine);
        if (intersectGeom.isEmpty()) {
            return original;
        }
        assert (intersectGeom instanceof Point) : "The intersection between trim line and the feature must be a point.";
        Point intersection = (Point)intersectGeom;
        Coordinate intersectionPoint = intersection.getCoordinate();
        Coordinate lineTo = intersectionPoint.equals2D(lineFrom = this.getCoordinateBeforePoint(trimmingLine, intersectionPoint)) ? trimmingLine.getCoordinateN(1) : intersectionPoint;
        Geometry difference = original.difference((Geometry)trimmingLine);
        if (difference instanceof MultiLineString) {
            splitLine1 = (LineString)difference.getGeometryN(0);
            splitLine2 = (LineString)difference.getGeometryN(1);
        } else if (difference instanceof LineString) {
            splitLine1 = (LineString)difference;
            splitLine2 = difference.getFactory().createLineString(new Coordinate[0]);
        } else {
            throw new IllegalStateException(String.valueOf(Messages.TrimGeometryStrategy_difference_unknown_type) + difference);
        }
        Coordinate firstLinePoint = this.getCoordinateBeforePoint(splitLine1, intersectionPoint);
        if (firstLinePoint.equals2D(intersectionPoint)) {
            firstLinePoint = splitLine1.getCoordinateN(1);
        }
        LineString lineAtTheRight = -1 == (firstLineOrientation = CGAlgorithms.computeOrientation((Coordinate)lineFrom, (Coordinate)lineTo, (Coordinate)firstLinePoint)) ? splitLine2 : splitLine1;
        return lineAtTheRight;
    }

    private Coordinate getCoordinateBeforePoint(LineString line, Coordinate pointInLine) {
        Coordinate[] coordinates = line.getCoordinates();
        Coordinate[] segment = new Coordinate[2];
        GeometryFactory gf = line.getFactory();
        int i = 1;
        while (i < coordinates.length) {
            Geometry intersection;
            segment[0] = coordinates[i - 1];
            segment[1] = coordinates[i];
            LineString lineSegment = gf.createLineString(segment);
            lineSegment = lineSegment.buffer(1.0E-7, 2);
            Point point = gf.createPoint(pointInLine);
            if (point.equals(intersection = lineSegment.intersection((Geometry)point))) {
                return segment[0];
            }
            ++i;
        }
        String msg = MessageFormat.format(Messages.TrimGeometryStrategy_point_not_on_line, pointInLine, line);
        throw new IllegalArgumentException(msg);
    }
}

