/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.geometry.split;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import eu.udig.tools.geometry.internal.util.GeometryUtil;
import java.util.ArrayList;
import java.util.List;

public final class VertexStrategy {
    public static Geometry addIntersectionVertex(Geometry geomToAddVertex, Geometry line, List<Geometry> geomNeighbor) {
        assert (line instanceof LineString || line instanceof MultiLineString) : "Split line must be a line.";
        assert (geomToAddVertex instanceof Polygon || geomToAddVertex instanceof LineString || geomToAddVertex instanceof MultiPolygon || geomToAddVertex instanceof MultiLineString) : "Input geometry has unexpected class.";
        Geometry result = null;
        if (geomToAddVertex instanceof Polygon || geomToAddVertex instanceof MultiPolygon) {
            Polygon polygon;
            if (geomToAddVertex instanceof MultiPolygon) {
                MultiPolygon mpolygon = (MultiPolygon)geomToAddVertex;
                polygon = (Polygon)mpolygon.getGeometryN(0);
            } else {
                polygon = (Polygon)geomToAddVertex;
            }
            result = VertexStrategy.addIntersectionVertexToPolygon((Geometry)polygon, line, geomNeighbor);
        } else if (geomToAddVertex instanceof LineString || geomToAddVertex instanceof MultiLineString) {
            result = VertexStrategy.addIntersectionVertexToLine(geomToAddVertex, line);
        }
        return result;
    }

    private static Geometry addIntersectionVertexToPolygon(Geometry polygonToAddVertex, Geometry line, List<Geometry> geomNeighborList) {
        Polygon result = null;
        Geometry[] holes = null;
        LinearRing[] holesRing = null;
        List<Coordinate> shellCoordinates = null;
        List<LinearRing> holesList = null;
        GeometryFactory fc = polygonToAddVertex.getFactory();
        Polygon polygonGeom = (Polygon)polygonToAddVertex;
        LineString boundary = polygonGeom.getExteriorRing();
        Coordinate[] shellClosed = null;
        Coordinate[] boundaryCoordinates = boundary.getCoordinates();
        for (Geometry neighbor : geomNeighborList) {
            if (boundary.touches(neighbor)) {
                shellCoordinates = VertexStrategy.addIntersection(boundaryCoordinates, line, fc, neighbor);
                boundaryCoordinates = shellCoordinates.toArray(new Coordinate[shellCoordinates.size()]);
                shellClosed = boundaryCoordinates;
                continue;
            }
            shellClosed = boundaryCoordinates;
        }
        holes = VertexStrategy.getInteriorHoles((Geometry)polygonGeom);
        if (holes.length > 0) {
            holesList = VertexStrategy.addIntersectionToHoles(holes, line, fc, geomNeighborList);
            holesRing = holesList.toArray(new LinearRing[holesList.size()]);
        }
        shellClosed = GeometryUtil.closeGeometry(shellClosed);
        LinearRing shellRing = fc.createLinearRing(shellClosed);
        result = fc.createPolygon(shellRing, holesRing);
        return result;
    }

    private static Geometry addIntersectionVertexToLine(Geometry lineToAddVertex, Geometry line) {
        LineString result = null;
        List<Coordinate> shellCoordinates = null;
        GeometryFactory fc = lineToAddVertex.getFactory();
        Geometry boundary = lineToAddVertex.getBoundary();
        Coordinate[] boundaryCoordinates = boundary.getCoordinates();
        shellCoordinates = VertexStrategy.addIntersection(boundaryCoordinates, line, fc, line);
        Coordinate[] shellClosed = shellCoordinates.toArray(new Coordinate[shellCoordinates.size()]);
        shellClosed = GeometryUtil.closeGeometry(shellClosed);
        result = fc.createLineString(shellClosed);
        return result;
    }

    private static List<LinearRing> addIntersectionToHoles(Geometry[] holes, Geometry line, GeometryFactory fc, List<Geometry> geomNeighborList) {
        ArrayList<LinearRing> holesRing = new ArrayList<LinearRing>();
        List<Coordinate> holeCoordinates = null;
        int i = 0;
        while (i < holes.length) {
            LinearRing eachHole = fc.createLinearRing(holes[i].getCoordinates());
            Coordinate[] boundaryCoordinates = eachHole.getCoordinates();
            Coordinate[] holeClosed = null;
            for (Geometry neighbor : geomNeighborList) {
                if (eachHole.touches(neighbor)) {
                    holeCoordinates = VertexStrategy.addIntersection(boundaryCoordinates, line, fc, neighbor);
                    boundaryCoordinates = holeCoordinates.toArray(new Coordinate[holeCoordinates.size()]);
                    holeClosed = boundaryCoordinates = GeometryUtil.closeGeometry(boundaryCoordinates);
                    continue;
                }
                holeClosed = boundaryCoordinates;
            }
            holesRing.add(fc.createLinearRing(holeClosed));
            ++i;
        }
        return holesRing;
    }

    private static List<Coordinate> addIntersection(Coordinate[] boundaryCoordinates, Geometry line, GeometryFactory fc, Geometry neighbor) {
        List<Coordinate> resultCoordinates = new ArrayList<Coordinate>();
        int i = 0;
        resultCoordinates.add(boundaryCoordinates[i]);
        i = 0;
        while (i < boundaryCoordinates.length - 1) {
            Coordinate[] segmentCoordinates = new Coordinate[]{boundaryCoordinates[i], boundaryCoordinates[i + 1]};
            LineString segment = fc.createLineString(segmentCoordinates);
            if (segment.intersects(line)) {
                Geometry point = segment.intersection(line);
                Geometry[] sorted = VertexStrategy.sortPoints(point, segment);
                int j = 0;
                while (j < sorted.length) {
                    resultCoordinates = VertexStrategy.addPoint((Geometry)segment, neighbor, sorted[j], resultCoordinates);
                    ++j;
                }
            }
            if (!resultCoordinates.contains(boundaryCoordinates[i + 1])) {
                resultCoordinates.add(boundaryCoordinates[i + 1]);
            }
            ++i;
        }
        return resultCoordinates;
    }

    private static Geometry[] sortPoints(Geometry point, LineString segment) {
        Geometry[] sorted = new Geometry[point.getNumGeometries()];
        int i = 0;
        while (i < point.getNumGeometries()) {
            sorted[i] = point.getGeometryN(i);
            ++i;
        }
        Geometry temp = null;
        int i2 = sorted.length - 1;
        while (i2 > 0) {
            int j = 0;
            while (j < i2) {
                double dist2;
                double dist1;
                Coordinate firstLineCoord = segment.getCoordinateN(0);
                Coordinate secondLineCoord = segment.getCoordinateN(1);
                Coordinate firstPoint = sorted[j].getCoordinate();
                Coordinate secondPoint = sorted[j + 1].getCoordinate();
                if (firstLineCoord.x - secondLineCoord.x != 0.0) {
                    dist1 = firstLineCoord.x - firstPoint.x;
                    dist2 = firstLineCoord.x - secondPoint.x;
                } else {
                    dist1 = firstLineCoord.y - firstPoint.y;
                    dist2 = firstLineCoord.y - secondPoint.y;
                }
                if (Math.abs(dist1) > Math.abs(dist2)) {
                    temp = sorted[j];
                    sorted[j] = sorted[j + 1];
                    sorted[j + 1] = temp;
                }
                ++j;
            }
            --i2;
        }
        return sorted;
    }

    private static List<Coordinate> addPoint(Geometry segment, Geometry neighbor, Geometry point, List<Coordinate> resultCoordinates) {
        Coordinate coord;
        if (segment.intersects(neighbor) && segment.intersection(neighbor).getDimension() > 0 && !resultCoordinates.contains(coord = point.getCoordinate())) {
            resultCoordinates.add(coord);
        }
        return resultCoordinates;
    }

    private static Geometry[] getInteriorHoles(Geometry geomToAddVertex) {
        Geometry[] holes = new Geometry[]{};
        Polygon polygon = (Polygon)geomToAddVertex;
        holes = new Geometry[polygon.getNumInteriorRing()];
        int j = 0;
        while (j < polygon.getNumInteriorRing()) {
            LineString interiorRing = polygon.getInteriorRingN(j);
            holes[j] = interiorRing;
            ++j;
        }
        return holes;
    }
}

